/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.jobmanagement.composite;

import com.clustercontrol.bean.Property;
import com.clustercontrol.bean.PropertyDefine;
import com.clustercontrol.jobmanagement.bean.JobTreeItem;

/**
 * ֥ץѥƥ
 * 
 * @version 1.0.0
 * @since 1.0.0
 */
public class JobPropertyDefine extends PropertyDefine {
	private static final long serialVersionUID = -5940758348294063798L;

	/**
     * 󥹥ȥ饯
     * 
     * @since 1.0.0
     */
    public JobPropertyDefine() {
        m_cellEditor = new JobDialogCellEditor(false);
    }

    public JobPropertyDefine(boolean treeOnly) {
        m_cellEditor = new JobDialogCellEditor(treeOnly);
    }

    public JobPropertyDefine(String parentJobId, String jobId) {
        m_cellEditor = new JobDialogCellEditor(parentJobId, jobId);
    }

    /*
     * (non-Javadoc)
     * 
     * @see com.clustercontrol.bean.PropertyDefine#getColumnText(java.lang.Object)
     */
    public String getColumnText(Object value) {
        //ץѥƥ֥ͤĥ꡼ʤСIDɽ
        if (value instanceof JobTreeItem) {
            return ((JobTreeItem) value).getData().getId();
        } else if (value instanceof String) {
            return (String) value;
        }
        return "";
    }

    /*
     * (non-Javadoc)
     * 
     * @see com.clustercontrol.bean.PropertyDefine#getValue(com.clustercontrol.bean.Property)
     */
    public Object getValue(Property element) {
        //ץѥƥ֥ͤĥ꡼ʤСIDɽ
        Object value = element.getValue();
        if (value instanceof JobTreeItem) {
            return ((JobTreeItem) value).getData().getId();
        } else if (value instanceof String) {
            return (String) value;
        }
        return new String("");
    }

    /*
     * (non-Javadoc)
     * 
     * @see com.clustercontrol.bean.PropertyDefine#modify(com.clustercontrol.bean.Property,
     *      java.lang.Object)
     */
    public void modify(Property element, Object value) {
        //ѹ֥ͤĥ꡼ʤСץѥƥͤꤹ
        if (value instanceof JobTreeItem) {
            element.setValue(value);
        }
    }

    /*
     * (non-Javadoc)
     * 
     * @see com.clustercontrol.bean.PropertyDefine#initEditer()
     */
    public void initEditer() {

    }
}