/*
 
 Copyright (C) 2006 NTT DATA Corporation
 
 This program is free software; you can redistribute it and/or
 Modify it under the terms of the GNU General Public License 
 as published by the Free Software Foundation, version 2.
 
 This program is distributed in the hope that it will be
 useful, but WITHOUT ANY WARRANTY; without even the implied 
 warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
 PURPOSE.  See the GNU General Public License for more details.
 
 */

package com.clustercontrol.jobmanagement.composite;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

import com.clustercontrol.bean.PriorityConstant;
import com.clustercontrol.bean.SizeConstant;
import com.clustercontrol.bean.YesNoConstant;
import com.clustercontrol.composite.NumberVerifyListener;
import com.clustercontrol.composite.TimeVerifyListener;
import com.clustercontrol.dialog.ValidateResult;
import com.clustercontrol.jobmanagement.bean.ConditionTypeConstant;
import com.clustercontrol.jobmanagement.bean.JobWaitRuleInfo;
import com.clustercontrol.jobmanagement.bean.OperationConstant;
import com.clustercontrol.util.Messages;

/**
 * ٱ䥳ݥåȥ饹
 * 
 * @version 2.1.0
 * @since 2.1.0
 */
public class StartDelayComposite extends Composite {
	protected Button m_sessionCondition = null;
	protected Text m_sessionValue = null;
	
	protected Button m_timeCondition = null;
	protected Text m_timeValue = null;
	
	protected Button m_andCondition = null;
	protected Button m_orCondition = null;
	
	protected Button m_notifyCondition = null;
	protected Combo m_notifyPriority = null;
	
	protected Button m_operationCondition = null;
	protected Group m_operationConditionGroup = null;
	protected Combo m_operationType = null;
	protected Text m_operationValue = null;
	
	protected Button m_startDelayCondition = null;
	protected Group m_startDelayConditionGroup = null;
	
	protected JobWaitRuleInfo m_waitRule = null;
	
	protected Shell m_shell = null;
	
	/**
	 * 󥹥ȥ饯
	 * 
	 * @param parent
	 * @param style
	 * @since 2.1.0
	 */
	public StartDelayComposite(Composite parent, int style) {
		super(parent, style);
		initialize();
		m_shell = this.getShell();
	}
	
	/**
	 * 
	 * 
	 * @since 2.1.0
	 */
	private void initialize() {
		RowLayout layout = new RowLayout();
		layout.type = SWT.VERTICAL;
		layout.spacing = 1;
		layout.marginWidth = 5;
		layout.marginHeight = 5;
		layout.fill = true;
		this.setLayout(layout);
		
		Composite composite = null;
		RowLayout rowLayout = null;
		Label label = null;
		
		//ٱ
		composite = new Composite(this, SWT.NONE);
		rowLayout = new RowLayout();
		rowLayout.type = SWT.VERTICAL;
		composite.setLayout(rowLayout);
		
		m_startDelayCondition = new Button(composite, SWT.CHECK);
		m_startDelayCondition.setText(Messages.getString("start.delay"));
		m_startDelayCondition.setLayoutData(new RowData(200,
				SizeConstant.SIZE_BUTTON_HEIGHT));
		m_startDelayCondition.addSelectionListener(new SelectionListener() {
			public void widgetSelected(SelectionEvent e) {
				Button check = (Button) e.getSource();

				//ٱ䥳ݥåȤΥ֥ȤλԲĤ
				setStartDelayEnabled(check.getSelection());
			}
			
			public void widgetDefaultSelected(SelectionEvent e) {
				
			}
		});
		
		m_startDelayConditionGroup = new Group(composite, SWT.NONE);
		rowLayout = new RowLayout();
		rowLayout.type = SWT.VERTICAL;
		rowLayout.marginWidth = 5;
		rowLayout.marginHeight = 5;
		rowLayout.spacing = 1;
		m_startDelayConditionGroup.setLayout(rowLayout);
		
		//Ƚоݰ
		Group group = new Group(m_startDelayConditionGroup, SWT.NONE);
		group.setText(Messages.getString("object.list"));
		rowLayout = new RowLayout();
		rowLayout.type = SWT.VERTICAL;
		rowLayout.marginWidth = 5;
		rowLayout.marginHeight = 5;
		rowLayout.spacing = 1;
		group.setLayout(rowLayout);
		
		//å󳫻ϸλ
		composite = new Composite(group, SWT.NONE);
		rowLayout = new RowLayout();
		rowLayout.type = SWT.HORIZONTAL;
		rowLayout.spacing = 10;
		composite.setLayout(rowLayout);
		m_sessionCondition = new Button(composite, SWT.CHECK);
		m_sessionCondition.setText(Messages.getString("time.after.session.start") + " : ");
		m_sessionCondition.setLayoutData(new RowData(180,
				SizeConstant.SIZE_BUTTON_HEIGHT));
		m_sessionCondition.addSelectionListener(new SelectionListener() {
			public void widgetSelected(SelectionEvent e) {
				Button check = (Button) e.getSource();
				if (check.getSelection()) {
					m_sessionValue.setEnabled(true);
				} else {
					m_sessionValue.setEnabled(false);
				}
			}
			
			public void widgetDefaultSelected(SelectionEvent e) {
				
			}
		});
		//å󳫻ϸλ֤
		m_sessionValue = new Text(composite, SWT.BORDER);
		m_sessionValue.setLayoutData(new RowData(100,
				SizeConstant.SIZE_TEXT_HEIGHT));
		m_sessionValue.addVerifyListener(new NumberVerifyListener());
		
		//
		composite = new Composite(group, SWT.NONE);
		rowLayout = new RowLayout();
		rowLayout.type = SWT.HORIZONTAL;
		rowLayout.spacing = 10;
		composite.setLayout(rowLayout);
		m_timeCondition = new Button(composite, SWT.CHECK);
		m_timeCondition.setText(Messages.getString("wait.rule.time.example") + " : ");
		m_timeCondition.setLayoutData(new RowData(180,
				SizeConstant.SIZE_BUTTON_HEIGHT));
		m_timeCondition.addSelectionListener(new SelectionListener() {
			public void widgetSelected(SelectionEvent e) {
				Button check = (Button) e.getSource();
				if (check.getSelection()) {
					m_timeValue.setEnabled(true);
				} else {
					m_timeValue.setEnabled(false);
				}
			}
			
			public void widgetDefaultSelected(SelectionEvent e) {
				
			}
		});
		//
		m_timeValue = new Text(composite, SWT.BORDER);
		m_timeValue.setLayoutData(new RowData(100,
				SizeConstant.SIZE_TEXT_HEIGHT));
		m_timeValue.addVerifyListener(new TimeVerifyListener());
		
		//Ƚоݤξط
		group = new Group(m_startDelayConditionGroup, SWT.NONE);
		group.setText(Messages.getString("condition.between.objects"));
		rowLayout = new RowLayout();
		rowLayout.type = SWT.VERTICAL;
		rowLayout.marginWidth = 5;
		rowLayout.marginHeight = 5;
		rowLayout.spacing = 1;
		group.setLayout(rowLayout);
		
		composite = new Composite(group, SWT.NONE);
		rowLayout = new RowLayout();
		rowLayout.type = SWT.HORIZONTAL;
		rowLayout.spacing = 10;
		composite.setLayout(rowLayout);
		m_andCondition = new Button(composite, SWT.RADIO);
		m_andCondition.setText(Messages.getString("and"));
		m_andCondition.setLayoutData(new RowData(100,
				SizeConstant.SIZE_BUTTON_HEIGHT));
		m_orCondition = new Button(composite, SWT.RADIO);
		m_orCondition.setText(Messages.getString("or"));
		m_orCondition.setLayoutData(new RowData(100,
				SizeConstant.SIZE_BUTTON_HEIGHT));
		label = new Label(composite, SWT.NONE);
		label.setLayoutData(new RowData(77, SizeConstant.SIZE_LABEL_HEIGHT));
		
		composite = new Composite(m_startDelayConditionGroup, SWT.NONE);
		rowLayout = new RowLayout();
		rowLayout.type = SWT.HORIZONTAL;
		rowLayout.spacing = 10;
		composite.setLayout(rowLayout);
		label = new Label(composite, SWT.NONE);
		label.setLayoutData(new RowData(5, SizeConstant.SIZE_LABEL_HEIGHT));
		
		//
		composite = new Composite(m_startDelayConditionGroup, SWT.NONE);
		rowLayout = new RowLayout();
		rowLayout.type = SWT.HORIZONTAL;
		rowLayout.spacing = 10;
		composite.setLayout(rowLayout);
		m_notifyCondition = new Button(composite, SWT.CHECK);
		m_notifyCondition.setText(Messages.getString("notify.attribute") + " : ");
		m_notifyCondition.setLayoutData(new RowData(100,
				SizeConstant.SIZE_BUTTON_HEIGHT));
		m_notifyCondition.addSelectionListener(new SelectionListener() {
			public void widgetSelected(SelectionEvent e) {
				Button check = (Button) e.getSource();
				if (check.getSelection()) {
					m_notifyPriority.setEnabled(true);
				} else {
					m_notifyPriority.setEnabled(false);
				}
			}
			
			public void widgetDefaultSelected(SelectionEvent e) {
				
			}
		});
		//Τν
		m_notifyPriority = new Combo(composite, SWT.CENTER | SWT.READ_ONLY);
		m_notifyPriority.setLayoutData(new RowData(100,
				SizeConstant.SIZE_COMBO_HEIGHT));
		m_notifyPriority.add(PriorityConstant.STRING_INFO);
		m_notifyPriority.add(PriorityConstant.STRING_WARNING);
		m_notifyPriority.add(PriorityConstant.STRING_CRITICAL);
		m_notifyPriority.add(PriorityConstant.STRING_UNKNOWN);
		
		//
		composite = new Composite(m_startDelayConditionGroup, SWT.NONE);
		rowLayout = new RowLayout();
		rowLayout.type = SWT.HORIZONTAL;
		rowLayout.spacing = 10;
		composite.setLayout(rowLayout);
		m_operationCondition = new Button(composite, SWT.CHECK);
		m_operationCondition.setText(Messages.getString("operations"));
		m_operationCondition.setLayoutData(new RowData(220,
				SizeConstant.SIZE_BUTTON_HEIGHT));
		m_operationCondition.addSelectionListener(new SelectionListener() {
			public void widgetSelected(SelectionEvent e) {
				Button check = (Button) e.getSource();
				if (check.getSelection()) {
					m_operationType.setEnabled(true);
					
					int type = getSelectOperationName(m_operationType);
					if (type == OperationConstant.TYPE_STOP_SKIP) {
						m_operationValue.setEnabled(true);
					} else if(type == OperationConstant.TYPE_STOP_WAIT){
						m_operationValue.setEnabled(false);
					}
					m_operationConditionGroup.setEnabled(true);
				} else {
					m_operationType.setEnabled(false);
					m_operationValue.setEnabled(false);
					m_operationConditionGroup.setEnabled(false);
				}
			}
			
			public void widgetDefaultSelected(SelectionEvent e) {
				
			}
		});
		
		m_operationConditionGroup = new Group(m_startDelayConditionGroup, SWT.NONE);
		rowLayout = new RowLayout();
		rowLayout.type = SWT.VERTICAL;
		rowLayout.marginWidth = 5;
		rowLayout.marginHeight = 5;
		rowLayout.spacing = 1;
		m_operationConditionGroup.setLayout(rowLayout);
		
		//̾
		composite = new Composite(m_operationConditionGroup, SWT.NONE);
		rowLayout = new RowLayout();
		rowLayout.type = SWT.HORIZONTAL;
		rowLayout.spacing = 10;
		composite.setLayout(rowLayout);
		label = new Label(composite, SWT.NONE);
		label.setText(Messages.getString("name") + " : ");
		label.setLayoutData(new RowData(100,
				SizeConstant.SIZE_LABEL_HEIGHT));
		m_operationType = new Combo(composite, SWT.CENTER | SWT.READ_ONLY);
		m_operationType.setLayoutData(new RowData(100,
				SizeConstant.SIZE_COMBO_HEIGHT));
		m_operationType.add(OperationConstant.STRING_STOP_SKIP);
		m_operationType.add(OperationConstant.STRING_STOP_WAIT);
		m_operationType.addSelectionListener(new SelectionListener() {
			public void widgetSelected(SelectionEvent e) {
				Combo check = (Combo) e.getSource();
				
				int type = getSelectOperationName(check);
				if (type == OperationConstant.TYPE_STOP_SKIP) {
					m_operationValue.setEnabled(true);
				} else if(type == OperationConstant.TYPE_STOP_WAIT){
					m_operationValue.setEnabled(false);
				}
			}
			
			public void widgetDefaultSelected(SelectionEvent e) {
				
			}
		});
		
		//νλ
		composite = new Composite(m_operationConditionGroup, SWT.NONE);
		rowLayout = new RowLayout();
		rowLayout.type = SWT.HORIZONTAL;
		rowLayout.spacing = 10;
		composite.setLayout(rowLayout);
		label = new Label(composite, SWT.NONE);
		label.setText(Messages.getString("end.value") + " : ");
		label.setLayoutData(new RowData(100,
				SizeConstant.SIZE_LABEL_HEIGHT));
		m_operationValue = new Text(composite, SWT.BORDER);
		m_operationValue.setLayoutData(new RowData(100,
				SizeConstant.SIZE_TEXT_HEIGHT));
		label = new Label(composite, SWT.NONE);
		label.setLayoutData(new RowData(70, SizeConstant.SIZE_LABEL_HEIGHT));
	}
	
	/**
	 * Ԥȿ
	 *  
	 */
	@SuppressWarnings("unchecked")
	public void reflectWaitRuleInfo() {
		if (m_waitRule instanceof JobWaitRuleInfo) {
			//ٱ
			m_startDelayCondition.setSelection(YesNoConstant.typeToBoolean(m_waitRule
					.getStart_delay()));
			
			//å󳫻ϸλ
			m_sessionCondition.setSelection(YesNoConstant.typeToBoolean(m_waitRule.getStart_delay_session()));
			
			//å󳫻ϸλ֤
			m_sessionValue.setText(String.valueOf(m_waitRule.getStart_delay_session_value()));
			
			//
			m_timeCondition.setSelection(YesNoConstant.typeToBoolean(m_waitRule.getStart_delay_time()));
			
			//
			if (m_waitRule.getStart_delay_time_value() instanceof Date) {
				SimpleDateFormat formatter = new SimpleDateFormat("HH:mm");
				m_timeValue.setText(formatter.format(m_waitRule.getStart_delay_time_value()));
			}
			else{
				m_timeValue.setText("");
			}
			
			//ط
			if (m_waitRule.getStart_delay_condition_type() == ConditionTypeConstant.TYPE_AND) {
				m_andCondition.setSelection(true);
			} else {
				m_orCondition.setSelection(true);
			}	
			
			//
			m_notifyCondition.setSelection(YesNoConstant.typeToBoolean(m_waitRule.getStart_delay_notify()));
			
			//Τν
			setSelectPriority(m_notifyPriority, 
					m_waitRule.getStart_delay_notify_priority());
			
			//
			m_operationCondition.setSelection(YesNoConstant.typeToBoolean(m_waitRule.getStart_delay_operation()));
			
			//̾
			setSelectOperationName(m_operationType, 
					m_waitRule.getStart_delay_operation_type());
			
			//νλ
			m_operationValue.setText(String.valueOf(m_waitRule.getStart_delay_operation_end_value()));
			
		} else {
			m_startDelayCondition.setSelection(false);
			m_sessionCondition.setSelection(false);
			m_sessionValue.setText(String.valueOf(1));
			m_timeCondition.setSelection(false);
			m_andCondition.setSelection(true);
			m_notifyCondition.setSelection(false);
			m_notifyPriority.select(0);
			m_operationCondition.setSelection(false);
			m_operationType.select(0);
			m_operationValue.setText(String.valueOf(0));
		}
		
		//ٱ䥳ݥåȤΥ֥ȤλԲĤ
		setStartDelayEnabled(m_startDelayCondition.getSelection());
	}
	
	/**
	 * Ԥ
	 * 
	 * @param m_waitRule
	 */
	public void setWaitRuleInfo(JobWaitRuleInfo start) {
		m_waitRule = start;
	}
	
	/**
	 * Ԥ
	 * 
	 * @return
	 */
	public JobWaitRuleInfo getWaitRuleInfo() {
		return m_waitRule;
	}
	
	/**
	 * Ԥ
	 * 
	 * @return
	 */
	@SuppressWarnings("unchecked")
	public ValidateResult createWaitRuleInfo() {
		ValidateResult result = null;
		
		//¹ƾ󥯥饹Υ󥹥󥹤
		if (m_waitRule == null)
			m_waitRule = new JobWaitRuleInfo();
		
		//ٱ
		m_waitRule.setStart_delay(YesNoConstant.booleanToType(m_startDelayCondition
				.getSelection()));
		
		//å󳫻ϸλ
		m_waitRule.setStart_delay_session(YesNoConstant.booleanToType(m_sessionCondition
				.getSelection()));
		
		//å󳫻ϸλ֤
		try {
			m_waitRule.setStart_delay_session_value(
					Integer.parseInt(m_sessionValue.getText()));
		} catch (NumberFormatException e) {
			if (m_waitRule.getStart_delay_session() == YesNoConstant.TYPE_YES) {
				result = new ValidateResult();
				result.setValid(false);
				result.setID(Messages.getString("message.hinemos.1"));
				result.setMessage(Messages.getString("message.job.52"));
				return result;
			}
		}
		
		//
		m_waitRule.setStart_delay_time(YesNoConstant.booleanToType(m_timeCondition
				.getSelection()));
		
		//
		try {
			SimpleDateFormat formatter = new SimpleDateFormat("HH:mm");
			Date date = formatter.parse((String)m_timeValue.getText());
			m_waitRule.setStart_delay_time_value(date);
		} catch (ParseException e) {
			if (m_waitRule.getStart_delay_time() == YesNoConstant.TYPE_YES) {
				result = new ValidateResult();
				result.setValid(false);
				result.setID(Messages.getString("message.hinemos.1"));
				result.setMessage(Messages.getString("message.job.54"));
				return result;
			}
		}
		
		//ط
		if (m_andCondition.getSelection()) {
			m_waitRule.setStart_delay_condition_type(ConditionTypeConstant.TYPE_AND);
		} else {
			m_waitRule.setStart_delay_condition_type(ConditionTypeConstant.TYPE_OR);
		}
		
		//
		m_waitRule.setStart_delay_notify(YesNoConstant.booleanToType(m_notifyCondition
				.getSelection()));
		
		//Τν
		m_waitRule.setStart_delay_notify_priority(getSelectPriority(m_notifyPriority));
		
		//
		m_waitRule.setStart_delay_operation(YesNoConstant.booleanToType(m_operationCondition
				.getSelection()));
		
		//̾
		m_waitRule.setStart_delay_operation_type(getSelectOperationName(m_operationType));
		
		//νλ
		try {
			m_waitRule.setStart_delay_operation_end_value(
					Integer.parseInt(m_operationValue.getText()));
		} catch (NumberFormatException e) {
			if (m_waitRule.getStart_delay_operation() == YesNoConstant.TYPE_YES) {
				result = new ValidateResult();
				result.setValid(false);
				result.setID(Messages.getString("message.hinemos.1"));
				result.setMessage(Messages.getString("message.job.21"));
				return result;
			}
		}
		
		return null;
	}
	
	/**
	 * ٱ䥳ݥåȤΥ֥ȤλԲĤ
	 * 
	 * @param enabled
	 */
	public void setStartDelayEnabled(boolean enabled) {
		if (enabled) {
			m_startDelayConditionGroup.setEnabled(true);
			
			//å󳫻ϸλ
			m_sessionCondition.setEnabled(true);
			if(m_sessionCondition.getSelection())
				m_sessionValue.setEnabled(true);
			else
				m_sessionValue.setEnabled(false);
			
			//
			m_timeCondition.setEnabled(true);
			if(m_timeCondition.getSelection())
				m_timeValue.setEnabled(true);
			else
				m_timeValue.setEnabled(false);
			
			//Ƚ
			m_andCondition.setEnabled(true);
			m_orCondition.setEnabled(true);
			
			//
			m_notifyCondition.setEnabled(true);
			if(m_notifyCondition.getSelection())
				m_notifyPriority.setEnabled(true);
			else
				m_notifyPriority.setEnabled(false);
			
			//
			m_operationConditionGroup.setEnabled(true);
			m_operationCondition.setEnabled(true);
			if(m_operationCondition.getSelection()){
				m_operationType.setEnabled(true);
				m_operationValue.setEnabled(false);
				
				int type = getSelectOperationName(m_operationType);
				if (type == OperationConstant.TYPE_STOP_SKIP) {
					m_operationValue.setEnabled(true);
				} else if(type == OperationConstant.TYPE_STOP_WAIT){
					m_operationValue.setEnabled(false);
				}
			}
			else{
				m_operationType.setEnabled(false);
				m_operationValue.setEnabled(false);
			}
		} else {
			m_startDelayConditionGroup.setEnabled(false);
			
			//å󳫻ϸλ
			m_sessionCondition.setEnabled(false);
			m_sessionValue.setEnabled(false);
			
			//
			m_timeCondition.setEnabled(false);
			m_timeValue.setEnabled(false);
			
			//Ƚ
			m_andCondition.setEnabled(false);
			m_orCondition.setEnabled(false);
			
			//
			m_notifyCondition.setEnabled(false);
			m_notifyPriority.setEnabled(false);
			
			//
			m_operationCondition.setEnabled(false);
			m_operationType.setEnabled(false);
			m_operationValue.setEnabled(false);
			m_operationConditionGroup.setEnabled(false);
		}
	}
	
	/**
	 * ٥ܥܥå򥤥ǥå
	 * 
	 * @param combo
	 * @param type
	 */
	public void setSelectPriority(Combo combo, int priority) {
		String select = "";
		
		if (priority == PriorityConstant.TYPE_CRITICAL) {
			select = PriorityConstant.STRING_CRITICAL;
		} else if (priority == PriorityConstant.TYPE_WARNING) {
			select = PriorityConstant.STRING_WARNING;
		} else if (priority == PriorityConstant.TYPE_INFO) {
			select = PriorityConstant.STRING_INFO;
		} else if (priority == PriorityConstant.TYPE_UNKNOWN) {
			select = PriorityConstant.STRING_UNKNOWN;
		} else if (priority == PriorityConstant.TYPE_NONE) {
			select = PriorityConstant.STRING_NONE;
		}
		
		combo.select(0);
		for (int i = 0; i < combo.getItemCount(); i++) {
			if (select.equals(combo.getItem(i))) {
				combo.select(i);
				break;
			}
		}
	}
	
	/**
	 * ٥ܥܥå򥤥ǥå
	 * 
	 * @param combo
	 * @return
	 */
	public int getSelectPriority(Combo combo) {
		String select = combo.getText();
		
		if (select.equals(PriorityConstant.STRING_CRITICAL)) {
			return PriorityConstant.TYPE_CRITICAL;
		} else if (select.equals(PriorityConstant.STRING_WARNING)) {
			return PriorityConstant.TYPE_WARNING;
		} else if (select.equals(PriorityConstant.STRING_INFO)) {
			return PriorityConstant.TYPE_INFO;
		} else if (select.equals(PriorityConstant.STRING_UNKNOWN)) {
			return PriorityConstant.TYPE_UNKNOWN;
		} else if (select.equals(PriorityConstant.STRING_NONE)) {
			return PriorityConstant.TYPE_NONE;
		}
		
		return -1;
	}
	
	/**
	 * ̾ܥܥå򥤥ǥå
	 * 
	 * @param combo
	 * @param operation
	 */
	public void setSelectOperationName(Combo combo, int operation) {
		String select = "";
		
		if (operation == OperationConstant.TYPE_STOP_SKIP) {
			select = OperationConstant.STRING_STOP_SKIP;
		} else if (operation == OperationConstant.TYPE_STOP_WAIT) {
			select = OperationConstant.STRING_STOP_WAIT;
		}
		
		combo.select(0);
		for (int i = 0; i < combo.getItemCount(); i++) {
			if (select.equals(combo.getItem(i))) {
				combo.select(i);
				break;
			}
		}
	}
	
	/**
	 * ̾ܥܥå򥤥ǥå
	 * 
	 * @param combo
	 * @return
	 */
	public int getSelectOperationName(Combo combo) {
		String select = combo.getText();
		
		if (select.equals(OperationConstant.STRING_STOP_SKIP)) {
			return OperationConstant.TYPE_STOP_SKIP;
		} else if (select.equals(OperationConstant.STRING_STOP_WAIT)) {
			return OperationConstant.TYPE_STOP_WAIT;
		}
		
		return -1;
	}
}