/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.jobmanagement.composite.action;

import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;

import com.clustercontrol.jobmanagement.bean.JobTreeItem;
import com.clustercontrol.jobmanagement.composite.JobListComposite;
import com.clustercontrol.jobmanagement.composite.JobTreeComposite;
import com.clustercontrol.jobmanagement.view.JobListView;

/**
 * ְSelectionChangedListener饹
 * 
 * @version 1.0.0
 * @since 1.0.0
 */
public class JobTreeSelectionChangedListener implements
        ISelectionChangedListener {
    protected JobTreeComposite m_tree;

    protected JobListComposite m_list;

    /**
     * 󥹥ȥ饯
     * 
     * @param composite
     * @since 1.0.0
     */
    public JobTreeSelectionChangedListener(JobTreeComposite tree,
            JobListComposite list) {
        m_tree = tree;
        m_list = list;
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.eclipse.jface.viewers.ISelectionChangedListener#selectionChanged(org.eclipse.jface.viewers.SelectionChangedEvent)
     */
    public void selectionChanged(SelectionChangedEvent event) {
        //򥢥ƥ
        JobTreeItem selectItem = (JobTreeItem) ((StructuredSelection) event
                .getSelection()).getFirstElement();

        //[Ͽ]ӥ塼Υ󥹥󥹤
        IWorkbenchPage page = PlatformUI.getWorkbench()
                .getActiveWorkbenchWindow().getActivePage();
        IViewPart viewPart = page.findView(JobListView.ID);
        JobListView view = (JobListView) viewPart.getAdapter(JobListView.class);

        if (selectItem instanceof JobTreeItem) {
            //ĥ꡼ƥ
            m_tree.setSelectItem(selectItem);

            //ӥ塼Υͭ/̵
            view.setEnabledAction(selectItem.getData().getType());
        } else {
            //ĥ꡼ƥ
            m_tree.setSelectItem(null);
        }

        //ְ򹹿
        m_list.update(selectItem);
    }
}