/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.jobmanagement.composite.action;

import java.util.ArrayList;

import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;

import com.clustercontrol.jobmanagement.bean.RunScheduleListTableDefine;
import com.clustercontrol.jobmanagement.composite.RunScheduleListComposite;
import com.clustercontrol.jobmanagement.view.RunScheduleDetailListView;

/**
 * ͽơ֥SelectionChangedListener饹
 * 
 * @version 2.0.0
 * @since 2.0.0
 */
public class RunScheduleSelectionChangedListener implements ISelectionChangedListener {
    protected RunScheduleListComposite m_composite;

    /**
     * 󥹥ȥ饯
     * 
     * @param composite
     * @since 1.0.0
     */
    public RunScheduleSelectionChangedListener(RunScheduleListComposite composite) {
        m_composite = composite;
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.eclipse.jface.viewers.ISelectionChangedListener#selectionChanged(org.eclipse.jface.viewers.SelectionChangedEvent)
     */
    public void selectionChanged(SelectionChangedEvent event) {
        String scheduleId = null;
        
        //ID
        if (((StructuredSelection) event.getSelection()).getFirstElement() != null) {
            ArrayList info = (ArrayList) ((StructuredSelection) event
                    .getSelection()).getFirstElement();
            scheduleId = (String) info.get(RunScheduleListTableDefine.SCHE_ID);
            //ID
            m_composite.setScheduleId(scheduleId);
        }

        //ƥ֥ڡ
        IWorkbenchPage page = PlatformUI.getWorkbench()
                .getActiveWorkbenchWindow().getActivePage();
        //ӥ塼򹹿
        IViewPart viewPart = page.findView(RunScheduleDetailListView.ID);
        if (viewPart != null) {
        	RunScheduleDetailListView view = (RunScheduleDetailListView) viewPart
                    .getAdapter(RunScheduleDetailListView.class);
            view.update(scheduleId);
        }
    }
}

