/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.jobmanagement.composite.action;

import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;

import com.clustercontrol.jobmanagement.composite.RunScheduleComposite;
import com.clustercontrol.jobmanagement.composite.RunScheduleDetailComposite;
import com.clustercontrol.jobmanagement.composite.RunScheduleDetailListComposite;
import com.clustercontrol.jobmanagement.composite.RunScheduleListComposite;
import com.clustercontrol.jobmanagement.view.RunScheduleDetailListView;
import com.clustercontrol.jobmanagement.view.RunScheduleListView;

/**
 * ľСSelectionListener饹
 * 
 * @version 2.0.0
 * @since 2.0.0
 */
public class VerticalBarSelectionListener implements SelectionListener {
    protected Composite m_composite;

    /**
     * 󥹥ȥ饯
     * 
     * @param composite
     */
    public VerticalBarSelectionListener(Composite composite) {
        m_composite = composite;
    }

	/* (non-Javadoc)
	 * @see org.eclipse.swt.events.SelectionListener#widgetSelected(org.eclipse.swt.events.SelectionEvent)
	 */
	public void widgetSelected(SelectionEvent e) {
        //ƥ֥ڡ
        IWorkbenchPage page = 
        	PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();

		if(m_composite instanceof RunScheduleListComposite){
	        //ӥ塼
	        IViewPart viewPart = page.findView(RunScheduleListView.ID);
	        if (viewPart != null) {
	        	RunScheduleListView view = 
	        		(RunScheduleListView)viewPart.getAdapter(
	        				RunScheduleListView.class);
	        	
	        	view.getScheduleComposite().getTable().setTopIndex(
	        			view.getListComposite().getTable().getTopIndex());
	        }
		}
		else if(m_composite instanceof RunScheduleComposite){
	        //ӥ塼
	        IViewPart viewPart = page.findView(RunScheduleListView.ID);
	        if (viewPart != null) {
	        	RunScheduleListView view = 
	        		(RunScheduleListView)viewPart.getAdapter(
	        				RunScheduleListView.class);
	        	
	        	view.getListComposite().getTable().setTopIndex(
	        			view.getScheduleComposite().getTable().getTopIndex());
	        }
		}
		else if(m_composite instanceof RunScheduleDetailListComposite){
	        //ӥ塼
	        IViewPart viewPart = page.findView(RunScheduleDetailListView.ID);
	        if (viewPart != null) {
	        	RunScheduleDetailListView view = 
	        		(RunScheduleDetailListView)viewPart.getAdapter(
	        				RunScheduleDetailListView.class);
	        	
	        	view.getScheduleComposite().getTable().setTopIndex(
	        			view.getListComposite().getTable().getTopIndex());
	        }
		}
		else if(m_composite instanceof RunScheduleDetailComposite){
	        //ӥ塼
	        IViewPart viewPart = page.findView(RunScheduleDetailListView.ID);
	        if (viewPart != null) {
	        	RunScheduleDetailListView view = 
	        		(RunScheduleDetailListView)viewPart.getAdapter(
	        				RunScheduleDetailListView.class);
	        	
	        	view.getListComposite().getTable().setTopIndex(
	        			view.getScheduleComposite().getTable().getTopIndex());
	        }
		}
	}

	/* (non-Javadoc)
	 * @see org.eclipse.swt.events.SelectionListener#widgetDefaultSelected(org.eclipse.swt.events.SelectionEvent)
	 */
	public void widgetDefaultSelected(SelectionEvent e) {

	}
}

