/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.jobmanagement.composite.action;

import java.util.ArrayList;

import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;

import com.clustercontrol.jobmanagement.composite.WaitRuleComposite;

/**
 * ơ֥SelectionChangedListener饹
 * 
 * @version 1.0.0
 * @since 1.0.0
 */
public class WaitRuleSelectionChangedListener implements
        ISelectionChangedListener {
    protected WaitRuleComposite m_composite;

    /**
     * 󥹥ȥ饯
     * 
     * @param composite
     * @since 1.0.0
     */
    public WaitRuleSelectionChangedListener(WaitRuleComposite composite) {
        m_composite = composite;
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.eclipse.jface.viewers.ISelectionChangedListener#selectionChanged(org.eclipse.jface.viewers.SelectionChangedEvent)
     */
    public void selectionChanged(SelectionChangedEvent event) {
        if (((StructuredSelection) event.getSelection()).getFirstElement() != null) {
            //Ԥ
            ArrayList info = (ArrayList) ((StructuredSelection) event
                    .getSelection()).getFirstElement();
            m_composite.setSelectItem(info);
        } else {
            m_composite.setSelectItem(null);
        }
    }
}