/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.jobmanagement.dialog;

import java.util.ArrayList;

import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.TableTree;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;

import com.clustercontrol.bean.Property;
import com.clustercontrol.composite.PropertySheet;
import com.clustercontrol.dialog.CommonDialog;
import com.clustercontrol.dialog.ValidateResult;
import com.clustercontrol.jobmanagement.action.GetHistoryFilterProperty;
import com.clustercontrol.jobmanagement.bean.HistoryFilterPropertyConstant;
import com.clustercontrol.jobmanagement.composite.JobPropertyDefine;
import com.clustercontrol.util.Messages;
import com.clustercontrol.util.PropertyUtil;

/**
 * ָ饹
 * 
 * @version 1.0.0
 * @since 1.0.0
 */
public class HistoryFilterDialog extends CommonDialog {
    private PropertySheet propertySheet = null;
    private static Property filterProperty = null;

    /**
     * 󥹥ȥ饯
     * 
     * @param parent
     */
    public HistoryFilterDialog(Shell parent) {
        super(parent);
    }

    /**
     * ν֤ޤ
     * 
     * @return 
     */
    protected Point getInitialSize() {
        return new Point(500, 500);
    }

    /*
     * (non-Javadoc)
     * 
     * @see com.clustercontrol.dialog.CommonDialog#customizeDialog(org.eclipse.swt.widgets.Composite)
     */
    protected void customizeDialog(Composite parent) {
        Shell shell = this.getShell();

        shell.setText(Messages.getString("dialog.job.filter.histories"));

        // 쥤
        GridLayout layout = new GridLayout(1, true);
        layout.marginWidth = 10;
        layout.marginHeight = 10;
        parent.setLayout(layout);

        /*
         * °ץѥƥ
         */

        // ٥
        Label label = new Label(parent, SWT.LEFT);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 1;
        label.setLayoutData(gridData);
        label.setText(Messages.getString("attribute") + " : ");

        // ץѥƥ
        TableTree table = new TableTree(parent, SWT.H_SCROLL | SWT.V_SCROLL
                | SWT.FULL_SELECTION | SWT.MULTI | SWT.BORDER);
        gridData = new GridData();
        gridData.horizontalAlignment = GridData.FILL;
        gridData.verticalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalSpan = 1;
        table.setLayoutData(gridData);

        this.propertySheet = new PropertySheet(table);

        // ץѥƥ
        if(filterProperty == null){
        	filterProperty = new GetHistoryFilterProperty().getProperty();
        }
        ArrayList jobId = PropertyUtil.getProperty(filterProperty,
                HistoryFilterPropertyConstant.JOB_ID);
        JobPropertyDefine define = new JobPropertyDefine();
        ((Property) jobId.get(0)).setDefine(define);
        this.propertySheet.setInput(filterProperty);

        // 饤
        Label line = new Label(parent, SWT.SEPARATOR | SWT.HORIZONTAL);
        gridData = new GridData();
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 1;
        line.setLayoutData(gridData);

        // 
        Display display = shell.getDisplay();
        shell.setLocation((display.getBounds().width - shell.getSize().x) / 2,
                (display.getBounds().height - shell.getSize().y) / 2);
    }

    /**
     * ͥå򤷤ޤ
     * 
     * @return ڷ
     */
    protected ValidateResult validate() {
        return super.validate();
    }

    /**
     * ͤݻǡǥޤ
     * 
     * @return ǡǥ
     */
    public Property getInputData() {
    	if(filterProperty != null){
        	Property copy = PropertyUtil.copy(filterProperty);
            return copy;
    	}
    	else{
    		return null;
    	}
    }

    /**
     * ¸Υܥ˲äꥢܥɲäޤ
     * 
     * @param parent
     *            ܥСݥå
     */
    protected void createButtonsForButtonBar(Composite parent) {
    	// ꥢܥ
    	this.createButton(parent, IDialogConstants.OPEN_ID, Messages
    			.getString("clear"), false);
    	this.getButton(IDialogConstants.OPEN_ID).addSelectionListener(
    			new SelectionAdapter() {
    				public void widgetSelected(SelectionEvent e) {
    					// ץѥƥ
    					filterProperty = new GetHistoryFilterProperty().getProperty();
    					ArrayList jobId = PropertyUtil.getProperty(filterProperty,
    							HistoryFilterPropertyConstant.JOB_ID);
    					JobPropertyDefine define = new JobPropertyDefine();
    					((Property) jobId.get(0)).setDefine(define);
    					propertySheet.setInput(filterProperty);
    				}
    			});
    	
    	super.createButtonsForButtonBar(parent);
    }
    
    /**
     * ϣ˥ܥΥƥȤ֤ޤ
     * 
     * @return ϣ˥ܥΥƥ
     */
    protected String getOkButtonText() {
        return Messages.getString("ok");
    }

    /**
     * 󥻥ܥΥƥȤ֤ޤ
     * 
     * @return 󥻥ܥΥƥ
     */
    protected String getCancelButtonText() {
        return Messages.getString("cancel");
    }
}