/*
 
 Copyright (C) 2006 NTT DATA Corporation
 
 This program is free software; you can redistribute it and/or
 Modify it under the terms of the GNU General Public License 
 as published by the Free Software Foundation, version 2.
 
 This program is distributed in the hope that it will be
 useful, but WITHOUT ANY WARRANTY; without even the implied 
 warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
 PURPOSE.  See the GNU General Public License for more details.
 
 */

package com.clustercontrol.jobmanagement.dialog;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.regex.Pattern;

import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.TableTree;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;

import com.clustercontrol.bean.JobParamTypeConstant;
import com.clustercontrol.bean.Property;
import com.clustercontrol.bean.PropertyConstant;
import com.clustercontrol.composite.PropertySheet;
import com.clustercontrol.dialog.CommonDialog;
import com.clustercontrol.dialog.ValidateResult;
import com.clustercontrol.jobmanagement.action.ParameterProperty;
import com.clustercontrol.jobmanagement.bean.ParameterTableDefine;
import com.clustercontrol.util.Messages;
import com.clustercontrol.util.PropertyUtil;

/**
 * ֥ѥ᡼饹
 * 
 * @version 2.1.0
 * @since 2.1.0
 */
public class ParameterDialog extends CommonDialog {
	/** ץѥƥ */
	protected PropertySheet m_viewer = null;
	
	private Shell m_shell = null;
	
	private ArrayList m_parameter = null;
	
	/**
	 * 󥹥ȥ饯
	 * 
	 * @param parent
	 */
	public ParameterDialog(Shell parent) {
		super(parent);
	}
	
	/*
	 * (non-Javadoc)
	 * 
	 * @see com.clustercontrol.dialog.CommonDialog#customizeDialog(org.eclipse.swt.widgets.Composite)
	 */
	protected void customizeDialog(Composite parent) {
		m_shell = this.getShell();
		
		parent.getShell().setText(Messages.getString("job.parameter"));
		
		GridLayout layout = new GridLayout(1, true);
		layout.marginWidth = 10;
		layout.marginHeight = 10;
		parent.setLayout(layout);
		
		Label tableTitle = new Label(parent, SWT.NONE);
		tableTitle.setText(Messages.getString("attribute") + " : ");
		GridData gridData = new GridData();
		gridData.horizontalAlignment = GridData.FILL;
		gridData.grabExcessHorizontalSpace = true;
		gridData.horizontalSpan = 1;
		tableTitle.setLayoutData(gridData);
		
		TableTree table = new TableTree(parent, SWT.BORDER | SWT.H_SCROLL
				| SWT.V_SCROLL | SWT.FULL_SELECTION | SWT.MULTI);
		gridData = new GridData();
		gridData.horizontalAlignment = GridData.FILL;
		gridData.verticalAlignment = GridData.FILL;
		gridData.grabExcessHorizontalSpace = true;
		gridData.grabExcessVerticalSpace = true;
		gridData.horizontalSpan = 1;
		table.setLayoutData(gridData);
		
		m_viewer = new PropertySheet(table);
		
		m_viewer.setInput(
				new ParameterProperty().getProperty(
						JobParamTypeConstant.TYPE_SYSTEM));
		
		Label line = new Label(parent, SWT.SEPARATOR | SWT.HORIZONTAL);
		gridData = new GridData();
		gridData.horizontalAlignment = GridData.FILL;
		gridData.grabExcessHorizontalSpace = true;
		gridData.horizontalSpan = 1;
		line.setLayoutData(gridData);
		
		// 
		Display display = m_shell.getDisplay();
		m_shell.setLocation(
				(display.getBounds().width - m_shell.getSize().x) / 2, (display
						.getBounds().height - m_shell.getSize().y) / 2);
		
		//Ͼȿ
		reflectParameter();
		
		m_viewer.expandAll();
	}
	
	/**
	 * Ͼȿ
	 *  
	 */
	private void reflectParameter() {
		Property property = null;
		
		if (m_parameter instanceof ArrayList) {
			//ѥ᡼
			Integer type = (Integer) m_parameter.get(
					ParameterTableDefine.TYPE);
			
			if (type.intValue() == JobParamTypeConstant.TYPE_SYSTEM) {
				//̤ƥξ
				property = new ParameterProperty().getProperty(JobParamTypeConstant.TYPE_SYSTEM);
				ArrayList propertyList = PropertyUtil.getProperty(property,
						ParameterProperty.ID_TYPE);
				Property paramType = (Property) propertyList.get(0);
				Object values[][] = paramType.getSelectValues();
				paramType.setValue(JobParamTypeConstant.STRING_SYSTEM);
				
				HashMap map = (HashMap) values[PropertyConstant.SELECT_VALUE][JobParamTypeConstant.TYPE_SYSTEM];
				ArrayList list = (ArrayList) map.get("property");
				
				//ѥ᡼ID
				String paramId = (String) m_parameter.get(ParameterTableDefine.PARAM_ID);
				((Property) list.get(0)).setValue(paramId);
				
				//
				String description = (String) m_parameter.get(ParameterTableDefine.DESCRIPTION);
				((Property) list.get(1)).setValue(description);
			}
			else if (type.intValue() == JobParamTypeConstant.TYPE_USER) {
				//̤桼ξ
				property = new ParameterProperty().getProperty(JobParamTypeConstant.TYPE_USER);
				ArrayList propertyList = PropertyUtil.getProperty(property,
						ParameterProperty.ID_TYPE);
				Property paramType = (Property) propertyList.get(0);
				Object values[][] = paramType.getSelectValues();
				paramType.setValue(JobParamTypeConstant.STRING_USER);
				
				HashMap map = (HashMap) values[PropertyConstant.SELECT_VALUE][JobParamTypeConstant.TYPE_USER];
				ArrayList list = (ArrayList) map.get("property");
				
				//ѥ᡼ID
				String paramId = (String) m_parameter.get(ParameterTableDefine.PARAM_ID);
				((Property) list.get(0)).setValue(paramId);

				//
				String value = (String) m_parameter.get(ParameterTableDefine.VALUE);
				((Property) list.get(1)).setValue(value);
				
				//
				String description = (String) m_parameter.get(ParameterTableDefine.DESCRIPTION);
				((Property) list.get(2)).setValue(description);
			}
			m_viewer.setInput(property);
			
			//ӥ塼
			m_viewer.refresh();
		}
	}
	
	/**
	 * Ͼȿ
	 *  
	 */
	@SuppressWarnings("unchecked")
	private ValidateResult createParameter() {
		ValidateResult result = null;
		
		m_parameter = new ArrayList();
		
		Property property = (Property) m_viewer.getInput();
		
		//̤
		ArrayList values = PropertyUtil.getPropertyValue(property,
				ParameterProperty.ID_TYPE);
		String type = (String) values.get(0);
		
		if (type.equals(JobParamTypeConstant.STRING_SYSTEM)) {
			//ѥ᡼ID
			String paramId = "";
			values = PropertyUtil.getPropertyValue(property,
					ParameterProperty.ID_SYSTEM_PARAM_ID);
			if (values.get(0) instanceof String) {
				paramId = (String) values.get(0);
			}
			if (paramId == null || paramId.length() == 0) {
				result = new ValidateResult();
				result.setValid(false);
				result.setID(Messages.getString("message.hinemos.1"));
				result.setMessage(Messages.getString("message.job.19"));
				return result;
			}
			m_parameter.add(paramId);
			
			//
			m_parameter.add(JobParamTypeConstant.TYPE_SYSTEM);
			
			//
			m_parameter.add("(" + Messages.getString("auto") + ")");
			
			//
			values = PropertyUtil.getPropertyValue(property,
					ParameterProperty.ID_DESCRIPTION);
			String description = (String) values.get(0);
			m_parameter.add(description);
		}
		else if (type.equals(JobParamTypeConstant.STRING_USER)) {
			//ѥ᡼ID
			values = PropertyUtil.getPropertyValue(property,
					ParameterProperty.ID_USER_PARAM_ID);
			String paramId = (String) values.get(0);
			if (paramId == null || paramId.length() == 0) {
				result = new ValidateResult();
				result.setValid(false);
				result.setID(Messages.getString("message.hinemos.1"));
				result.setMessage(Messages.getString("message.job.19"));
				return result;
			}
			else{
				//ե٥åȡ'_''-'ʳϵƤʤ
				if (!Pattern.matches("[a-zA-Z0-9_-]*", paramId)) {
					result = new ValidateResult();
					result.setValid(false);
					result.setID(Messages.getString("message.hinemos.1"));
					result.setMessage(Messages.getString("message.job.19"));
					return result;
				}
			}
			m_parameter.add(paramId);
			
			//
			m_parameter.add(JobParamTypeConstant.TYPE_USER);
			
			//
			values = PropertyUtil.getPropertyValue(property,
					ParameterProperty.ID_VALUE);
			String value = (String) values.get(0);
			if (value == null ) {
				result = new ValidateResult();
				result.setValid(false);
				result.setID(Messages.getString("message.hinemos.1"));
				result.setMessage(Messages.getString("message.job.17"));
				return result;
			}
			m_parameter.add(value);
			
			//
			values = PropertyUtil.getPropertyValue(property,
					ParameterProperty.ID_DESCRIPTION);
			String description = (String) values.get(0);
			m_parameter.add(description);
		}
		
		return null;
	}
	
	/**
	 * ν֤ޤ
	 * 
	 * @return 
	 */
	protected Point getInitialSize() {
		return new Point(350, 400);
	}
	
	/**
	 * ͤꤹ
	 * 
	 * @param list
	 * @return
	 */
	public void setInputData(ArrayList list) {
		m_parameter = list;
	}
	
	/**
	 * ͤ
	 * 
	 * @return
	 */
	public ArrayList getInputData() {
		return m_parameter;
	}
	
	/**
	 * ϣ˥ܥƥȼ
	 * 
	 * @return ϣ˥ܥΥƥ
	 * @since 2.1.0
	 */
	protected String getOkButtonText() {
		return Messages.getString("ok");
	}
	
	/**
	 * 󥻥ܥƥȼ
	 * 
	 * @return 󥻥ܥΥƥ
	 * @since 2.1.0
	 */
	protected String getCancelButtonText() {
		return Messages.getString("cancel");
	}
	
	/*
	 * (non-Javadoc)
	 * 
	 * @see com.clustercontrol.dialog.CommonDialog#validate()
	 */
	protected ValidateResult validate() {
		ValidateResult result = null;
		
		result = createParameter();
		if (result != null) {
			return result;
		}
		
		return null;
	}
}