/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.jobmanagement.dialog;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;

import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.TableTree;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;

import com.clustercontrol.bean.EndStatusConstant;
import com.clustercontrol.bean.JudgmentObjectConstant;
import com.clustercontrol.bean.Property;
import com.clustercontrol.bean.PropertyConstant;
import com.clustercontrol.composite.PropertySheet;
import com.clustercontrol.dialog.CommonDialog;
import com.clustercontrol.dialog.ValidateResult;
import com.clustercontrol.jobmanagement.action.WaitRuleProperty;
import com.clustercontrol.jobmanagement.bean.JobTreeItem;
import com.clustercontrol.jobmanagement.bean.WaitRuleTableDefine;
import com.clustercontrol.util.Messages;
import com.clustercontrol.util.PropertyUtil;

/**
 * ֳϾ饹
 * 
 * @version 1.0.0
 * @since 1.0.0
 */
public class WaitRuleDialog extends CommonDialog {
    /** ץѥƥ */
    protected PropertySheet m_viewer = null;

    private Shell m_shell = null;

    private ArrayList m_startCondition = null;

    private String m_parentJobId = null;

    private String m_jobId = null;

    /**
     * 󥹥ȥ饯
     * 
     * @param parent
     */
    public WaitRuleDialog(Shell parent, String parentJobId, String jobId) {
        super(parent);
        m_parentJobId = parentJobId;
        m_jobId = jobId;
    }

    /*
     * (non-Javadoc)
     * 
     * @see com.clustercontrol.dialog.CommonDialog#customizeDialog(org.eclipse.swt.widgets.Composite)
     */
    protected void customizeDialog(Composite parent) {
        m_shell = this.getShell();

        parent.getShell().setText(Messages.getString("wait.rule"));

        GridLayout layout = new GridLayout(1, true);
        layout.marginWidth = 10;
        layout.marginHeight = 10;
        parent.setLayout(layout);

        Label tableTitle = new Label(parent, SWT.NONE);
        tableTitle.setText(Messages.getString("attribute") + " : ");
        GridData gridData = new GridData();
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 1;
        tableTitle.setLayoutData(gridData);

        TableTree table = new TableTree(parent, SWT.BORDER | SWT.H_SCROLL
                | SWT.V_SCROLL | SWT.FULL_SELECTION | SWT.MULTI);
        gridData = new GridData();
        gridData.horizontalAlignment = GridData.FILL;
        gridData.verticalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalSpan = 1;
        table.setLayoutData(gridData);

        m_viewer = new PropertySheet(table);

        m_viewer.setInput(new WaitRuleProperty().getProperty(m_parentJobId,
                m_jobId, JudgmentObjectConstant.TYPE_JOB_END_STAUS));

        Label line = new Label(parent, SWT.SEPARATOR | SWT.HORIZONTAL);
        gridData = new GridData();
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 1;
        line.setLayoutData(gridData);

        // 
        Display display = m_shell.getDisplay();
        m_shell.setLocation(
                (display.getBounds().width - m_shell.getSize().x) / 2, (display
                        .getBounds().height - m_shell.getSize().y) / 2);

        //Ͼȿ
        reflectStartCondition();

        m_viewer.expandAll();
    }

    /**
     * Ͼȿ
     *  
     */
    private void reflectStartCondition() {
        Property property = null;

        if (m_startCondition instanceof ArrayList) {
            //Ƚоݤ
            Integer type = (Integer) m_startCondition
                    .get(WaitRuleTableDefine.JUDGMENT_OBJECT);

            if (type.intValue() == JudgmentObjectConstant.TYPE_JOB_END_STAUS) {
                //Ƚоݤ֤ξ
                property = new WaitRuleProperty().getProperty(m_parentJobId,
                        m_jobId, JudgmentObjectConstant.TYPE_JOB_END_STAUS);
                ArrayList propertyList = PropertyUtil.getProperty(property,
                        WaitRuleProperty.ID_JUDGMENT_OBJECT);
                Property judgmentObject = (Property) propertyList.get(0);
                Object values[][] = judgmentObject.getSelectValues();
                judgmentObject.setValue(JudgmentObjectConstant.STRING_JOB_END_STAUS);

                HashMap map = (HashMap) values[PropertyConstant.SELECT_VALUE][JudgmentObjectConstant.TYPE_JOB_END_STAUS];
                ArrayList list = (ArrayList) map.get("property");

                //ID
                String jobId = (String) m_startCondition
                        .get(WaitRuleTableDefine.JOB_ID);
                ((Property) list.get(0)).setValue(jobId);

                //
                String value = (String) m_startCondition
                        .get(WaitRuleTableDefine.START_VALUE);
                ((Property) list.get(1)).setValue(value);
            }
            else if (type.intValue() == JudgmentObjectConstant.TYPE_JOB_END_VALUE) {
                //Ƚоݤ֤ξ
                property = new WaitRuleProperty().getProperty(m_parentJobId,
                        m_jobId, JudgmentObjectConstant.TYPE_JOB_END_VALUE);
                ArrayList propertyList = PropertyUtil.getProperty(property,
                        WaitRuleProperty.ID_JUDGMENT_OBJECT);
                Property judgmentObject = (Property) propertyList.get(0);
                Object values[][] = judgmentObject.getSelectValues();
                judgmentObject.setValue(JudgmentObjectConstant.STRING_JOB_END_VALUE);

                HashMap map = (HashMap) values[PropertyConstant.SELECT_VALUE][JudgmentObjectConstant.TYPE_JOB_END_VALUE];
                ArrayList list = (ArrayList) map.get("property");

                //ID
                String jobId = (String) m_startCondition
                        .get(WaitRuleTableDefine.JOB_ID);
                ((Property) list.get(0)).setValue(jobId);

                //
                Integer value = (Integer) m_startCondition
                        .get(WaitRuleTableDefine.START_VALUE);
                ((Property) list.get(1)).setValue(value);
            }
            else {
                //Ƚоݤξ
                property = new WaitRuleProperty().getProperty(m_parentJobId,
                        m_jobId, JudgmentObjectConstant.TYPE_TIME);
                ArrayList propertyList = PropertyUtil.getProperty(property,
                        WaitRuleProperty.ID_JUDGMENT_OBJECT);
                Property judgmentObject = (Property) propertyList.get(0);
                Object values[][] = judgmentObject.getSelectValues();
                judgmentObject.setValue(JudgmentObjectConstant.STRING_TIME);

                HashMap map = (HashMap) values[PropertyConstant.SELECT_VALUE][JudgmentObjectConstant.TYPE_TIME];
                ArrayList list = (ArrayList) map.get("property");

                //ϻ
                Date time = (Date) m_startCondition
                        .get(WaitRuleTableDefine.START_VALUE);
                ((Property) list.get(0)).setValue(time);
            }
            m_viewer.setInput(property);

            //ӥ塼
            m_viewer.refresh();
        }
    }

    /**
     * Ͼȿ
     *  
     */
    @SuppressWarnings("unchecked")
	private ValidateResult createStartCondition() {
        ValidateResult result = null;

        m_startCondition = new ArrayList();

        Property property = (Property) m_viewer.getInput();

        //Ƚоݤ
        ArrayList values = PropertyUtil.getPropertyValue(property,
                WaitRuleProperty.ID_JUDGMENT_OBJECT);
        String type = (String) values.get(0);
        m_startCondition.add(new Integer(JudgmentObjectConstant
                .stringToType(type)));

        if (type.equals(JudgmentObjectConstant.STRING_JOB_END_STAUS)) {
            //ID
            String jobId = "";
            values = PropertyUtil.getPropertyValue(property,
                    WaitRuleProperty.ID_JOB_ID);
            if (values.get(0) instanceof JobTreeItem) {
                JobTreeItem item = (JobTreeItem) values.get(0);
                jobId = item.getData().getId();
            } else if (values.get(0) instanceof String) {
                jobId = (String) values.get(0);
            }
            if (jobId == null || jobId.length() == 0) {
                result = new ValidateResult();
                result.setValid(false);
                result.setID(Messages.getString("message.hinemos.1"));
                result.setMessage(Messages.getString("message.job.22"));
                return result;
            }
            m_startCondition.add(jobId);

            //
            values = PropertyUtil.getPropertyValue(property,
                    WaitRuleProperty.ID_CONDITION_END_STATUS);
            String value = (String) values.get(0);
            if (value == null || value.length() == 0) {
                result = new ValidateResult();
                result.setValid(false);
                result.setID(Messages.getString("message.hinemos.1"));
                result.setMessage(Messages.getString("message.job.17"));
                return result;
            }
            m_startCondition.add(value);
        }
        else if (type.equals(JudgmentObjectConstant.STRING_JOB_END_VALUE)) {
            //ID
            String jobId = "";
            values = PropertyUtil.getPropertyValue(property,
                    WaitRuleProperty.ID_JOB_ID);
            if (values.get(0) instanceof JobTreeItem) {
                JobTreeItem item = (JobTreeItem) values.get(0);
                jobId = item.getData().getId();
            } else if (values.get(0) instanceof String) {
                jobId = (String) values.get(0);
            }
            if (jobId == null || jobId.length() == 0) {
                result = new ValidateResult();
                result.setValid(false);
                result.setID(Messages.getString("message.hinemos.1"));
                result.setMessage(Messages.getString("message.job.22"));
                return result;
            }
            m_startCondition.add(jobId);

            //
            values = PropertyUtil.getPropertyValue(property,
                    WaitRuleProperty.ID_CONDITION_END_VALUE);
            Integer value = (Integer) values.get(0);
            if (value == null ) {
                result = new ValidateResult();
                result.setValid(false);
                result.setID(Messages.getString("message.hinemos.1"));
                result.setMessage(Messages.getString("message.job.17"));
                return result;
            }
            m_startCondition.add(value);
        }
        else {
            //ID
            m_startCondition.add("");

            //ϻ
            values = PropertyUtil.getPropertyValue(property,
                    WaitRuleProperty.ID_TIME);
            Date startTime = null;
            if(values.get(0) instanceof Date)
            	startTime = (Date) values.get(0);
            if (startTime == null) {
                result = new ValidateResult();
                result.setValid(false);
                result.setID(Messages.getString("message.hinemos.1"));
                result.setMessage(Messages.getString("message.job.18"));
                return result;
            }
            m_startCondition.add(startTime);
        }

        return null;
    }

    /**
     * ν֤ޤ
     * 
     * @return 
     */
    protected Point getInitialSize() {
        return new Point(350, 400);
    }

    /**
     * ͤꤹ
     * 
     * @param list
     * @return
     */
    public void setInputData(ArrayList list) {
        m_startCondition = list;
    }

    /**
     * ͤ
     * 
     * @return
     */
    public ArrayList getInputData() {
        return m_startCondition;
    }

    /**
     * ϣ˥ܥƥȼ
     * 
     * @return ϣ˥ܥΥƥ
     * @since 1.0.0
     */
    protected String getOkButtonText() {
        return Messages.getString("ok");
    }

    /**
     * 󥻥ܥƥȼ
     * 
     * @return 󥻥ܥΥƥ
     * @since 1.0.0
     */
    protected String getCancelButtonText() {
        return Messages.getString("cancel");
    }

    /*
     * (non-Javadoc)
     * 
     * @see com.clustercontrol.dialog.CommonDialog#validate()
     */
    protected ValidateResult validate() {
        ValidateResult result = null;

        result = createStartCondition();
        if (result != null) {
            return result;
        }

        return null;
    }
}