/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.jobmanagement.view;

import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Menu;

import com.clustercontrol.bean.JobConstant;
import com.clustercontrol.jobmanagement.bean.JobTreeItem;
import com.clustercontrol.jobmanagement.composite.JobListComposite;
import com.clustercontrol.jobmanagement.composite.JobTreeComposite;
import com.clustercontrol.jobmanagement.composite.action.JobListSelectionChangedListener;
import com.clustercontrol.jobmanagement.composite.action.JobTreeSelectionChangedListener;
import com.clustercontrol.jobmanagement.view.action.CopyJobAction;
import com.clustercontrol.jobmanagement.view.action.CreateFileJobAction;
import com.clustercontrol.jobmanagement.view.action.CreateJobAction;
import com.clustercontrol.jobmanagement.view.action.CreateJobNetAction;
import com.clustercontrol.jobmanagement.view.action.CreateJobUnitAction;
import com.clustercontrol.jobmanagement.view.action.DeleteJobAction;
import com.clustercontrol.jobmanagement.view.action.ModifyJobAction;
import com.clustercontrol.jobmanagement.view.action.PasteJobAction;
import com.clustercontrol.jobmanagement.view.action.RunJobAction;
import com.clustercontrol.view.CommonViewPart;

/**
 * Ͽӥ塼饹
 * 
 * @version 2.0.0
 * @since 1.0.0
 */
public class JobListView extends CommonViewPart {
    public static final String ID = "com.clustercontrol.jobmanagement.view.JobListView";

    protected SashForm m_sash = null;
    protected JobTreeComposite m_jobTree = null;
    protected JobListComposite m_jobList = null;
    protected JobTreeItem m_copyJobTreeItem = null;
    protected boolean m_update = false;

    /**
     * 󥹥ȥ饯
     * 
     * @since 1.0.0
     */
    public JobListView() {
        super();
    }

    /**
     * ViewPartؤΥȥ
     * 
     * @since 1.0.0
     * @see org.eclipse.ui.IWorkbenchPart#createPartControl(org.eclipse.swt.widgets.Composite)
     */
    public void createPartControl(Composite parent) {
        GridLayout layout = new GridLayout(1, true);
        parent.setLayout(layout);
        layout.marginHeight = 0;
        layout.marginWidth = 0;

        m_sash = new SashForm(parent, SWT.HORIZONTAL);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = GridData.FILL;
        gridData.verticalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        m_sash.setLayoutData(gridData);

        //ֳإĥ꡼
        m_jobTree = new JobTreeComposite(m_sash, SWT.NONE);

        //ְ
        m_jobList = new JobListComposite(m_sash, SWT.NONE);

        //SashζĴ 30% 70%
        m_sash.setWeights(new int[] { 30, 70 });

        m_jobTree.getTreeViewer().addSelectionChangedListener(
                new JobTreeSelectionChangedListener(m_jobTree, m_jobList));

        m_jobList.getTableViewer().addSelectionChangedListener(
                new JobListSelectionChangedListener(m_jobList));

        //ݥåץåץ˥塼
        createContextMenu();

        //ӥ塼򹹿
        this.update();

        //ĥ꡼򳫤
        m_jobTree.getTreeViewer().expandToLevel(2);
    }

    /**
     * ݥåץåץ˥塼
     * 
     *  @since 1.0.0
     */
    protected void createContextMenu() {
        MenuManager menuManager = new MenuManager();
        menuManager.setRemoveAllWhenShown(true);
        menuManager.addMenuListener(new IMenuListener() {
            /*
             * (non-Javadoc)
             * 
             * @see org.eclipse.jface.action.IMenuListener#menuAboutToShow(org.eclipse.jface.action.IMenuManager)
             */
            public void menuAboutToShow(IMenuManager manager) {
                
                //˥塼
                fillContextMenu(manager);
            }
        });
        Menu treeMenu = menuManager.createContextMenu(m_jobTree.getTree());
        m_jobTree.getTree().setMenu(treeMenu);

        Menu listMenu = menuManager.createContextMenu(m_jobList.getTable());
        m_jobList.getTable().setMenu(listMenu);
    }

    /**
     * ˥塼ɲ
     * 
     * @param manager
     * @since 1.0.0
     */
    protected void fillContextMenu(IMenuManager manager) {
        //ӥ塼ΥΥ󥹥󥹤
        IToolBarManager toolbar = this.getViewSite().getActionBars()
                .getToolBarManager();
        ActionContributionItem createJobUnitAction = (ActionContributionItem) toolbar
                .find(CreateJobUnitAction.ID);
        ActionContributionItem createJobNetAction = (ActionContributionItem) toolbar
                .find(CreateJobNetAction.ID);
        ActionContributionItem createJobAction = (ActionContributionItem) toolbar
                .find(CreateJobAction.ID);
        ActionContributionItem createFileJobAction = (ActionContributionItem) toolbar
        		.find(CreateFileJobAction.ID);
        ActionContributionItem deleteJobAction = (ActionContributionItem) toolbar
                .find(DeleteJobAction.ID);
        ActionContributionItem modifyJobAction = (ActionContributionItem) toolbar
                .find(ModifyJobAction.ID);
        ActionContributionItem runJobAction = (ActionContributionItem) toolbar
                .find(RunJobAction.ID);

        //ݥåץåץ˥塼˥ɲ
        //Ver2.0.0 ԡɲ
        CopyJobAction copyJobAction = new CopyJobAction(this);
        manager.add(copyJobAction);
        //Ver2.0.0 Žդɲ
        PasteJobAction pasteJobAction = new PasteJobAction(this);
        manager.add(pasteJobAction);
        manager.add(new Separator());
        manager.add(createJobUnitAction.getAction());
        manager.add(createJobNetAction.getAction());
        manager.add(createJobAction.getAction());
        manager.add(createFileJobAction.getAction());
        manager.add(modifyJobAction.getAction());
        manager.add(deleteJobAction.getAction());
        manager.add(runJobAction.getAction());
        
        //ԡŽդλѲ/ԲĤ
        JobTreeItem select = getSelectJobTreeItem();
        if (select instanceof JobTreeItem) {
            //ԡλѲ/ԲĤ
            if(select.getData().getType() == JobConstant.TYPE_COMPOSITE){
                copyJobAction.setEnabled(false);
            }
            else{
                copyJobAction.setEnabled(true);
            }
            //ŽդλѲ/ԲĤ
            if(m_copyJobTreeItem != null && m_copyJobTreeItem instanceof JobTreeItem){
                pasteJobAction.setEnabled(true);
            }
            else{
                pasteJobAction.setEnabled(false);
            }
        }
    }

    /**
     * ӥ塼򹹿ޤ
     * 
     * @since 1.0.0
     */
    public void update() {
        m_jobTree.update();

        JobTreeItem item = this.getJobTreeComposite().getSelectItem();

        m_jobList.update(item);
        
        m_update = false;
    }

    /**
     * ӥ塼Υͭ/̵
     * 
     * @param type
     * @since 1.0.0
     */
    public void setEnabledAction(int type) {
        //ӥ塼ΥΥ󥹥󥹤
        IToolBarManager toolbar = this.getViewSite().getActionBars()
                .getToolBarManager();
        ActionContributionItem createJobUnitAction = (ActionContributionItem) toolbar
                .find(CreateJobUnitAction.ID);
        ActionContributionItem createJobNetAction = (ActionContributionItem) toolbar
                .find(CreateJobNetAction.ID);
        ActionContributionItem createJobAction = (ActionContributionItem) toolbar
                .find(CreateJobAction.ID);
        ActionContributionItem createFileJobAction = (ActionContributionItem) toolbar
        		.find(CreateFileJobAction.ID);
        ActionContributionItem deleteJobAction = (ActionContributionItem) toolbar
                .find(DeleteJobAction.ID);
        ActionContributionItem modifyJobAction = (ActionContributionItem) toolbar
                .find(ModifyJobAction.ID);
        ActionContributionItem runJobAction = (ActionContributionItem) toolbar
                .find(RunJobAction.ID);

        //ӥ塼λѲ/ԲĤ
        if (type == JobConstant.TYPE_COMPOSITE) {
            createJobUnitAction.getAction().setEnabled(true);
            createJobNetAction.getAction().setEnabled(false);
            createJobAction.getAction().setEnabled(false);
            createFileJobAction.getAction().setEnabled(false);
        } else if (type == JobConstant.TYPE_JOBUNIT) {
            createJobUnitAction.getAction().setEnabled(false);
            createJobNetAction.getAction().setEnabled(true);
            createJobAction.getAction().setEnabled(true);
            createFileJobAction.getAction().setEnabled(true);
        } else if (type == JobConstant.TYPE_JOBNET) {
            createJobUnitAction.getAction().setEnabled(false);
            createJobNetAction.getAction().setEnabled(true);
            createJobAction.getAction().setEnabled(true);
            createFileJobAction.getAction().setEnabled(true);
        } else if (type == JobConstant.TYPE_JOB) {
            createJobUnitAction.getAction().setEnabled(false);
            createJobNetAction.getAction().setEnabled(false);
            createJobAction.getAction().setEnabled(false);
            createFileJobAction.getAction().setEnabled(false);
        } else if (type == JobConstant.TYPE_FILEJOB) {
            createJobUnitAction.getAction().setEnabled(false);
            createJobNetAction.getAction().setEnabled(false);
            createJobAction.getAction().setEnabled(false);
            createFileJobAction.getAction().setEnabled(false);
        }

        if (type == JobConstant.TYPE_COMPOSITE) {
            deleteJobAction.getAction().setEnabled(false);
            modifyJobAction.getAction().setEnabled(false);
            runJobAction.getAction().setEnabled(false);
        } else {
            deleteJobAction.getAction().setEnabled(true);
            modifyJobAction.getAction().setEnabled(true);
            runJobAction.getAction().setEnabled(true);
        }
    }

    /**
     * ֥ĥ꡼ΥݥåȤ֤ޤ
     * 
     * @return ֥ĥ꡼Υݥå
     * @since 1.0.0
     */
    public JobTreeComposite getJobTreeComposite() {
        return m_jobTree;
    }

    /**
     * ְݥåȤ֤ޤ
     * 
     * @return ְΥݥå
     * @since 1.0.0
     */
    public JobListComposite getJobListComposite() {
        return m_jobList;
    }

    /**
     * ֥ĥ꡼ɽ
     * @since 1.0.0
     */
    public void show() {
        m_sash.setMaximizedControl(null);
    }

    /**
     * ֥ĥ꡼ɽˤ
     * @since 1.0.0
     */
    public void hide() {
        m_sash.setMaximizedControl(m_jobList);
    }
    
    /**
     * 򥸥֥ĥ꡼ƥ
     * 
     * @return JobTreeItem 򤵤줿֥ĥ꡼ƥ
     * @since 2.0.0
     */
    public JobTreeItem getSelectJobTreeItem() {
        JobTreeItem select = null;
        if (m_jobTree.getTree().isFocusControl()) {
            select = m_jobTree.getSelectItem();
        } else if (m_jobList.getTable().isFocusControl()) {
            select = m_jobList.getSelectJobTreeItem();
        }
        return select;
    }
    
    /**
     * ԡ֥ĥ꡼ƥ
     * 
     * @return ԡ֥ĥ꡼ƥ
     * @since 2.0.0
     */
    public JobTreeItem getCopyJobTreeItem() {
        return m_copyJobTreeItem;
    }
    
    /**
     * ԡ֥ĥ꡼ƥꤹ
     * 
     * @param copy ԡ֥ĥ꡼ƥ
     * @since 2.0.0
     */
    public void setCopyJobTreeItem(JobTreeItem copy) {
        m_copyJobTreeItem = copy;
    }
    
    /**
     * ֥ĥ꡼ƥιե饰
     * 
     * @return ե饰
     * @since 2.0.0
     */
    public boolean isUpdate() {
        return m_update;
    }
    
    /**
     * ֥ĥ꡼ƥιե饰ꤹ
     * 
     * @param update ե饰
     * @since 2.0.0
     */
    public void setUpdate(boolean update) {
        m_update = update;
    }
}