/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.jobmanagement.view;

import java.util.Calendar;
import java.util.Date;

import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Menu;

import com.clustercontrol.calendar.view.action.CalendarAddAction;
import com.clustercontrol.calendar.view.action.CalendarDeleteAction;
import com.clustercontrol.calendar.view.action.CalendarModifyAction;
import com.clustercontrol.jobmanagement.composite.RunScheduleComposite;
import com.clustercontrol.jobmanagement.composite.RunScheduleListComposite;
import com.clustercontrol.view.CommonViewPart;

/**
 * ͽӥ塼饹
 * 
 * @version 2.0.0
 * @since 2.0.0
 */
public class RunScheduleListView extends CommonViewPart {
    public static final String ID = "com.clustercontrol.jobmanagement.view.RunScheduleListView";

	private SashForm m_sash = null;
	
    private RunScheduleListComposite m_runScheduleList = null;
    
	private RunScheduleComposite m_runSchedule = null;
	
    protected Date m_base = null;
	
    /**
     * 󥹥ȥ饯
     */
    public RunScheduleListView() {
        super();
    }

    /**
     * ViewPartؤΥȥ
     * 
     * @see org.eclipse.ui.IWorkbenchPart#createPartControl(org.eclipse.swt.widgets.Composite)
     */
    public void createPartControl(Composite parent) {
        GridLayout layout = new GridLayout(1, true);
        parent.setLayout(layout);
        layout.marginHeight = 0;
        layout.marginWidth = 0;

		// åեڤ
        m_sash = new SashForm(parent, SWT.HORIZONTAL);
		GridData gridData = new GridData();
		gridData.horizontalAlignment = GridData.FILL;
		gridData.verticalAlignment = GridData.FILL;
		gridData.grabExcessHorizontalSpace = true;
		gridData.grabExcessVerticalSpace = true;
		m_sash.setLayoutData(gridData);
		
        m_runScheduleList = new RunScheduleListComposite(m_sash, SWT.NONE);

        Calendar baseCalendar = Calendar.getInstance();
        baseCalendar.setTime(new Date());
        baseCalendar.add(Calendar.WEEK_OF_MONTH, -1);
        m_base = new Date();
        m_runSchedule = new RunScheduleComposite(m_sash, SWT.NONE, baseCalendar.getTime());
        
		// SashζĴ 50% 50%
//        m_sash.setWeights(new int[] { 50, 50 });

        //ӥ塼򹹿
        this.update();
    }

    /**
     * ӥ塼
     */
    public void update() {
    	m_runScheduleList.update();
    	
    	if(!m_base.equals(m_runSchedule.getBaseDate())){
    		//ScheduleComposite
    		CreateScheduleComposite();
    	}
    	
    	m_runSchedule.update();
    }
    
    /**
     * ScheduleComposite
     */
    public void CreateScheduleComposite() {
		//ScheduleComposite
    	m_runSchedule.dispose();
		
        m_runSchedule = new RunScheduleComposite(m_sash, SWT.NONE, m_base);
	    
	    //SashForm
        m_sash.layout(true, true);
    }
    
	/**
	 * @return
	 */
	public RunScheduleListComposite getListComposite() {
		return m_runScheduleList;
	}
	
	/**
	 * @return
	 */
	public RunScheduleComposite getScheduleComposite() {
		return m_runSchedule;
	}
    
	/**
	 * ɽޤ
	 */
	public void showSchedule() {
		m_sash.setMaximizedControl(null);
	}
	
	/**
	 * ޤ
	 */
	public void hideSchedule() {
		m_sash.setMaximizedControl(m_runScheduleList);
	}
    
	/**
	 * @return
	 */
	public Date getBaseDate() {
		return m_base;
	}
	
	/**
	 * @param base
	 */
	public void setBaseDate(Date base) {
		m_base = base;
	}
}