/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.jobmanagement.view.action;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;

import com.clustercontrol.jobmanagement.view.RunScheduleDetailListView;
import com.clustercontrol.jobmanagement.view.RunScheduleListView;

/**
 * ͽơ֥ɽإ󥯥饹Ǥ
 * 
 * @version 2.0.0
 * @since 2.0.0
 */
public class ScheduleShowAction implements IViewActionDelegate {
	public static final String ID = "com.clustercontrol.jobmanagement.view.action.ScheduleShowAction";
	
    private IViewPart viewPart;

    /**
     * @see org.eclipse.ui.IViewActionDelegate#init(org.eclipse.ui.IViewPart)
     */
    public void init(IViewPart view) {
        viewPart = view;
    }

    /**
     * @see org.eclipse.ui.IActionDelegate#run(org.eclipse.jface.action.IAction)
     */
    public void run(IAction action) {
        if (viewPart instanceof RunScheduleListView) { // ܥ󤬲줿
        	RunScheduleListView view = (RunScheduleListView) viewPart
                    .getAdapter(RunScheduleListView.class);

            if (action.isChecked()) {
                view.showSchedule();
            } else {
                view.hideSchedule();
            }

            view.setFocus();
            
        } else if (viewPart instanceof RunScheduleDetailListView) { // ܥ󤬲줿
        	RunScheduleDetailListView view = (RunScheduleDetailListView) viewPart
                    .getAdapter(RunScheduleDetailListView.class);

            if (action.isChecked()) {
                view.showSchedule();
            } else {
                view.hideSchedule();
            }

            view.setFocus();
        }
    }

    /**
     * @see org.eclipse.ui.IActionDelegate#selectionChanged(org.eclipse.jface.action.IAction,
     *      org.eclipse.jface.viewers.ISelection)
     */
    public void selectionChanged(IAction action, ISelection selection) {
    }
}