/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.jobmanagement.view.action;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.PlatformUI;

import com.clustercontrol.jobmanagement.action.GetJobOperationProperty;
import com.clustercontrol.jobmanagement.action.OperationJob;
import com.clustercontrol.jobmanagement.composite.DetailComposite;
import com.clustercontrol.jobmanagement.composite.HistoryComposite;
import com.clustercontrol.jobmanagement.composite.NodeDetailComposite;
import com.clustercontrol.jobmanagement.dialog.JobOperationDialog;
import com.clustercontrol.jobmanagement.view.JobDetailView;
import com.clustercontrol.jobmanagement.view.JobHistoryView;
import com.clustercontrol.jobmanagement.view.JobNodeDetailView;
import com.clustercontrol.util.Messages;

/**
 * ֳ󥯥饹
 * 
 * @version 1.0.0
 * @since 1.0.0
 */
public class StartJobAction implements IViewActionDelegate {
    public static final String ID = "com.clustercontrol.jobmanagement.view.action.StartJobAction";

    protected IViewPart m_view;

    /*
     * (non-Javadoc)
     * 
     * @see org.eclipse.ui.IViewActionDelegate#init(org.eclipse.ui.IViewPart)
     */
    public void init(IViewPart view) {
        m_view = view;
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.eclipse.ui.IActionDelegate#run(org.eclipse.jface.action.IAction)
     */
    public void run(IAction action) {
        String sessionId = null;
        String jobId = null;
        String facilityId = null;

        if (m_view instanceof JobHistoryView) { // ܥ󤬲줿
            JobHistoryView view = (JobHistoryView) m_view
                    .getAdapter(JobHistoryView.class);
            HistoryComposite historyComposite = view.getComposite();
            //åID
            sessionId = historyComposite.getSessionId();
            //ID
            jobId = historyComposite.getJobId();
        } else if (m_view instanceof JobDetailView) { // ܥ󤬲줿
            JobDetailView view = (JobDetailView) m_view
                    .getAdapter(JobDetailView.class);
            DetailComposite detailComposite = view.getComposite();
            //åID
            sessionId = detailComposite.getSessionId();
            //ID
            jobId = detailComposite.getJobId();
        } else if (m_view instanceof JobNodeDetailView) { // ܥ󤬲줿
            JobNodeDetailView view = (JobNodeDetailView) m_view
                    .getAdapter(JobNodeDetailView.class);
            NodeDetailComposite nodeDetailComposite = view.getComposite();
            //åID
            sessionId = nodeDetailComposite.getSessionId();
            //ID
            jobId = nodeDetailComposite.getJobId();
            //եƥID
            facilityId = nodeDetailComposite.getFacilityId();
            if (facilityId == null) {
                sessionId = null;
                jobId = null;
            }
        }

        if (sessionId != null && sessionId.length() > 0 && jobId != null
                && jobId.length() > 0) {

            JobOperationDialog dialog = new JobOperationDialog(PlatformUI
                    .getWorkbench().getActiveWorkbenchWindow().getShell());

            //ץѥƥ
            dialog.setProperty(new GetJobOperationProperty().getStartProperty(
                    sessionId, jobId, facilityId));
            dialog.setTitleText(Messages.getString("job") + "["
                    + Messages.getString("start") + "]");

            //ɽ
            if (dialog.open() == IDialogConstants.OK_ID) {
                //ֳ
                OperationJob operation = new OperationJob();
                operation.operationJob(dialog.getProperty());
            }
        }
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.eclipse.ui.IActionDelegate#selectionChanged(org.eclipse.jface.action.IAction,
     *      org.eclipse.jface.viewers.ISelection)
     */
    public void selectionChanged(IAction action, ISelection selection) {

    }
}