/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.logagent;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Properties;
import java.util.Timer;
import java.util.TimerTask;

import javax.jms.ExceptionListener;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.ObjectMessage;
import javax.jms.Session;
import javax.jms.Topic;
import javax.jms.TopicConnection;
import javax.jms.TopicConnectionFactory;
import javax.jms.TopicSession;
import javax.jms.TopicSubscriber;
import javax.naming.InitialContext;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.logtransfer.bean.TopicConstant;




/**
 * Topic饹
 * Topicؤ³ȡåμԤ
 * @version $Revision: 1.4 $
 * @since 1.0.0
 * 
 */
public class ReceiveTopic implements MessageListener, ExceptionListener {

	private static long RETRY_INTERVAL = 10000;

	private static final String TOPIC_CON_FACTORY = "ConnectionFactory";
	private static final String TOPIC_USER_NAME = "topic.user.name";
	private static final String TOPIC_USER_PASSWORD = "topic.user.password";

	protected ArrayList m_facilityIdList;
    protected SendQueue m_sendQueue;

	private Properties m_props;

	private TopicConnectionFactory m_factory;

    protected TopicConnection m_con;
    protected Topic m_topic;
    protected TopicSession m_session;
    protected TopicSubscriber m_subscriber;
    
    protected TransferLogManager m_logManager;
	
	private boolean m_errFlg = false;

	/** åӥ³ѥޡ * */
	protected static Timer m_timer = new Timer(true);

	//
	static private Log log = LogFactory.getLog(ReceiveTopic.class);

	
	/**
	 * 󥹥ȥ饯
	 * @param facilityIdList եƥIDΥꥹȡ
	 * @param sendQueueåѥ饹
	 * @param propsץѥƥե
	 */
	@SuppressWarnings("unchecked")
	public ReceiveTopic( Collection facilityIdList, TransferLogManager logManager, SendQueue sendQueue, Properties props) {
		super();
		m_logManager = logManager;
		m_facilityIdList = new ArrayList(facilityIdList);
		m_sendQueue = sendQueue;
		m_props = props;

		//³
        initial();
	}
    
    
    /**
     * եƥIDꥹ.
     * ꤵ줿եƥIDΥꥹȤȰ㤦ϡȥԥåκ³Ԥ
     * @param facilityIdList
     * @since
     */
	@SuppressWarnings("unchecked")
	synchronized public void setFacilityIdList(Collection facilityIdList) {
	
		//ѲƤ뤫ɤǧ
		if(facilityIdList.size() == m_facilityIdList.size()){
			if( m_facilityIdList.containsAll(facilityIdList) ){
				return;
			}
		}

		//ɲʬꥹ
		ArrayList<String> addFacilityList = new ArrayList<String>(facilityIdList);
		addFacilityList.removeAll(m_facilityIdList);
		
		//ʬꥹ
		ArrayList<String> removefacilityList = new ArrayList<String>(m_facilityIdList);
		removefacilityList.removeAll(facilityIdList);
		
		
		//ʬ򥹥å
		for (Iterator iter = removefacilityList.iterator(); iter.hasNext();) {
			String facility = (String) iter.next();
			//åɤ˺
			m_logManager.removeTransferLogInfo(facility);
			
		}
		
		
		//եƥꥹȹ
		m_facilityIdList = new ArrayList(facilityIdList);

		//Topic³
		if( !isErrFlg() ){
		    if( initialTopic() ){

				//ɲʬΥ׵
				for (Iterator iter = m_facilityIdList.iterator(); iter.hasNext();) {
					m_sendQueue.put(iter.next());	
				}
			}
		
		}

		
	}

	
	/* 
     * ȥԥå
     * (non-Javadoc)
     * @see javax.jms.MessageListener#onMessage(javax.jms.Message)
     */
    @SuppressWarnings("unchecked")
	public void onMessage(Message message) {
        
        
        log.debug("onMessage start");
        String facilityId;
        try {
			facilityId = message.getStringProperty("FacilityId");
		} catch (JMSException e1) {
			log.error("å", e1);
			return;
		}
        
        if(message instanceof ObjectMessage){
            ObjectMessage objectMessage = (ObjectMessage)message;
            Object obj;
			try {
				obj = objectMessage.getObject();
			} catch (JMSException e) {
				log.error("å", e);
				return;
			}

			if(obj instanceof ArrayList){
            	log.debug("onMessage get ArrayList");
                
            	ArrayList list = (ArrayList)obj;
				// ž
            	m_logManager.setTransferLogInfo(facilityId, list);
                
            }else{
				log.error("å" + obj.toString());
				return;
            }
        }else{
			log.error("å" + message.getClass());
			return;
        }
        log.debug("onMessage end");
    }
    
    /* ̿顼ϥɥ
     * (non-Javadoc)
     * @see javax.jms.ExceptionListener#onException(javax.jms.JMSException)
     */
    public void onException(JMSException arg0) {

    	log.error(arg0);
    	
        setErrFlg(true);
    }

    /**
	 * @param errFlg
	 *            errFlg ꡣ
	 */
	synchronized private void setErrFlg(boolean errFlg) {
		if (m_errFlg == false && errFlg == true) {

			m_timer.schedule(new ReSetupTask(), RETRY_INTERVAL,
					RETRY_INTERVAL);

		}
		m_errFlg = errFlg;
	}

	/**
	 * @return errFlg ᤷޤ
	 */
	synchronized private boolean isErrFlg() {
		return m_errFlg;
	}
	/**
	 *  
	 */
	synchronized private boolean reInitial() {

		boolean ret = false;

		log.info("³!");

		terminate();

		if (initial()) {

			ret = true;

			log.info("³:!");

			
			//顼ե饰
			setErrFlg(false);


		} else {
			log.info("³:!");
		}

		return ret;
	}
	/**
	 * ³νλ
	 *  
	 */
	public void terminate() {

		terminateSumscriber();

		
        try {
			if (m_session != null)
				m_session.close();
		} catch (JMSException e) {
		}

		try {
			if (m_con != null)
				m_con.close();
		} catch (JMSException e1) {
		}
	}
	/**
	 * ȥԥåνλ 
	 */
	private void terminateSumscriber() {
		try {
			if (m_subscriber != null)
		        m_subscriber.close();
		} catch (JMSException e) {
		}
	}



	/**
	 * 
	 * JMSؤ³ȥԥåԤ
	 * @return
	 */
	private boolean initial() {

		log.info("EJB³");

		InitialContext con = null;

		try {
			//InitialContext
			con = new InitialContext(m_props);

			//ͥեȥ
			m_factory = (TopicConnectionFactory) con.lookup(TOPIC_CON_FACTORY);

			//ͥ
			if (m_props.getProperty(TOPIC_USER_NAME) != null) {
				//桼ǧ
				m_con = m_factory.createTopicConnection(m_props
						.getProperty(TOPIC_USER_NAME), m_props
						.getProperty(TOPIC_USER_PASSWORD));
			} else {
				//桼ǧڤʤ
				m_con = m_factory.createTopicConnection();
			}

			
			//å
			m_session = m_con.createTopicSession(false,
					Session.AUTO_ACKNOWLEDGE);

			//åTopic
			m_topic = (Topic) con.lookup(TopicConstant.TOPIC_NAME_UPDATE);

			
			//顼ϥɤ饻å
	        m_con.setExceptionListener(this);

	        m_con.start();

	        //ȥԥå³
	        initialTopic();

			//եƥIDޥ͡Ρʥå
			for (Iterator iter = m_facilityIdList.iterator(); iter.hasNext();) {
				m_sendQueue.put(iter.next());	
			}


		} catch (Exception e) {
			log.error("Init", e);
			setErrFlg(true);
			return false;
		} finally {
			try {
				if (con != null)
					con.close();
			} catch (Exception e1) {
			}
		}
		return true;

	}

	/**
	 * ȥԥå
	 * @return
	 * @since
	 */
	private boolean initialTopic() {


		//ߤTopicλ
		terminateSumscriber();

		if(isErrFlg()){
			//顼κ³ʤ
			//³Ǥöɤ߹ߥåɤߤ
			m_logManager.stopTransfer();
		}
		
		//եƥIDǥȥԥå
		try {
	        
	        //եƥIDǥå쥯
	        StringBuffer msgSelector = new StringBuffer();
	        for (Iterator iter = m_facilityIdList.iterator(); iter.hasNext();) {
				String facilityId = (String) iter.next();
				msgSelector.append("FacilityId='");
				msgSelector.append(facilityId);
				msgSelector.append("'");
				if( iter.hasNext() ){
					msgSelector.append(" OR ");
				}
			}
	        
	        if(msgSelector.length() != 0){
	        
		        m_subscriber = m_session.createSubscriber(m_topic, msgSelector.toString(), false);
		        
		        //ХåϿ
		        m_subscriber.setMessageListener(this);

		        
	        }else{
	        	log.debug("եƥ󤬤ʤΤǡ⤷ʤ");
	        }
			

		} catch (Exception e) {
			log.error("TopicInit", e);
			setErrFlg(true);
			return false;
		} finally {

		}
		return true;

	}
	/**
	 * EJB³ޡ
	 * ̿顼ȤʤäǸƤФ³Ԥ 
	 */
	protected class ReSetupTask extends TimerTask {

		/**
		 * ͥ󥯥
		 */
		public void run() {
			if (reInitial()) {
				//Υ򥿥ޡ
				cancel();
			}
		}

	}
	
	/**
	 * եƥIDƼޡ
	 * եƥIDǤʤ硢ǤޤǺƼԤ 
	 */
	protected class RreacquisitionTask extends TimerTask {

		/**
		 * Ƽ
		 */
		public void run() {
			if (reInitial()) {
				//Υ򥿥ޡ
				cancel();
			}
		}

	}

}
