/*
 
 Copyright (C) 2006 NTT DATA Corporation
 
 This program is free software; you can redistribute it and/or
 Modify it under the terms of the GNU General Public License 
 as published by the Free Software Foundation, version 2.
 
 This program is distributed in the hope that it will be
 useful, but WITHOUT ANY WARRANTY; without even the implied 
 warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
 PURPOSE.  See the GNU General Public License for more details.
 
 */

package com.clustercontrol.logagent;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import java.util.Properties;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.bean.PriorityConstant;
import com.clustercontrol.bean.YesNoConstant;
import com.clustercontrol.logagent.util.LoggerSyslog;
import com.clustercontrol.util.Messages;

/**
 * žåɥ饹
 *
 * @version 2.1.0
 * @since 2.1.0
 */
public class TransferLogThread extends Thread {
	
	private final static String UNCHANGED_STATS_PERIOD = "unchanged.stats.period";
	private final static String FILE_MAX_SIZE = "file.max.size";
	
	public static final String MESSAGE_ID_INFO = "001";
	public static final String MESSAGE_ID_WARNING = "002";
	public static final String MESSAGE_ID_CRITICAL = "003";
	public static final String MESSAGE_ID_UNKNOWN = "004";
	
	public static final String HINEMOS_LOG_AGENT = "hinemos_log_agent";
	
	protected TransferLogManager m_transferLogManager;
	
	/** ե̾ */
	protected String m_filePath;
	
	/** ưֳ֡á */
	protected int m_runInterval;
	
	/** ǽ˥եå */
	protected int m_existenceFlg = YesNoConstant.TYPE_NO;
	
	/** եѹåá */
	protected int m_unchangedStatsPeriod = 0;
	
	/** ¥ե륵byte */
	protected long m_fileMaxSize = 0L;
	
	/** žߥե饰 */
	protected boolean m_stopFlg = false;
	
	// Syslogžѥ
	protected LoggerSyslog m_syslog = null;
	
	// 
	static Log log = LogFactory.getLog(TransferLogThread.class);
	
	
	/**
	 * 󥹥ȥ饯
	 * 
	 * @param queue
	 * @param props
	 * @param path žоݥե
	 * @param interval ưֳ֡á
	 * @param flg ǽ˥եå
	 */
	public TransferLogThread(TransferLogManager transferLogManager, Properties props, String path, int interval, int flg) {

		m_transferLogManager = transferLogManager;
		m_filePath = path;
		m_runInterval = interval * 1000;
		m_existenceFlg = flg;

		// եѹå֡á
		String sleepInterval = props.getProperty(UNCHANGED_STATS_PERIOD, "5");
		try {
			this.m_unchangedStatsPeriod = Integer.parseInt(sleepInterval) * 1000;
		} catch (NumberFormatException e) {
			log.error("TransferLogManager() : " + UNCHANGED_STATS_PERIOD, e);
		}
		
		// ¥ե륵byte
		String fileMaxSize = props.getProperty(FILE_MAX_SIZE, "2147483648");
		try {
			this.m_fileMaxSize = Long.parseLong(fileMaxSize);
		} catch (NumberFormatException e) {
			log.error("TransferLogManager() : " + FILE_MAX_SIZE, e);
		}
		
		m_syslog = new LoggerSyslog(props);
	}

	
	/* ( Javadoc)
	 * @see java.lang.Thread#run()
	 */
	@Override
	public void run() {

		long filesize = 0;
		long tmp_filesize = 0;
		long n_unchanged_stats=0;	// եåˡեѹʤä
		String carryOver="";
		byte[] cbuf = new byte[1024];

		
		File name = new File(this.m_filePath); // ƻоݥե

		//ե륪ץ
		RandomAccessFile fr = openFile(name, true, false);
		if(fr == null){
			return;
		}
		
		String logPrefix = HINEMOS_LOG_AGENT + "(" + this.m_filePath + "):";

		while(true){
			
			// ꡼
			try {
				Thread.sleep(this.m_runInterval);
			} catch (InterruptedException e) {
			}
			
			if(this.m_stopFlg){
				closeFile(fr);
				return;
			}
			
			try {
				tmp_filesize = fr.length();

				
				if(filesize == tmp_filesize){
					
					// ե륵m_unchangedStatsPeriodôְʾѤʤä顢եڤؤå
					if ((++n_unchanged_stats * this.m_runInterval) >= this.m_unchangedStatsPeriod){
						
						if( tmp_filesize != name.length() ){
							System.out.println("եؤޤ");
							closeFile(fr);
							
							//ե륪ץ
							fr = openFile(name, false, false);
							if(fr == null){
								return;
							}

							filesize=0;
							carryOver = "";

						}
						n_unchanged_stats = 0;
					}
					continue;
				}
				
				n_unchanged_stats = 0;
				
				if(filesize < tmp_filesize){
					
					// ʬɤ߹
					int read;
					StringBuffer sb = new StringBuffer(carryOver);			
					while((read = fr.read(cbuf)) != -1 ){
						try {
							sb.append(new String(cbuf,0,read,System.getProperty("file.encoding")));
						} catch (UnsupportedEncodingException e) {
							log.error("run() : " + e.getMessage());
						}
					}
					String tmpString = sb.toString();
					String[] result = tmpString.split("\\n");
					for (int x=0; x < (result.length-1) ; x++){
						m_syslog.log(logPrefix + result[x]);
					} 
					//Ԥǽʤη	
					if( tmpString.endsWith("\n") ){
						m_syslog.log(logPrefix + result[result.length-1]);
						carryOver = "";
					}else{
						carryOver = result[result.length-1];
					}
					 
					filesize = tmp_filesize;
					
				}else if (filesize > tmp_filesize){
					//ڵ
					log.info(this.m_filePath + ":ڵͤޤ");
					fr.seek(tmp_filesize);
					filesize = tmp_filesize;
					carryOver = "";

				}
				
			} catch (IOException e) {
				log.error("run() : " + e.getMessage());
				Object[] args = { this.m_filePath };
				sendMessage(PriorityConstant.TYPE_WARNING, 
						    Messages.getString("message.log.agent.4"), 
						    MESSAGE_ID_WARNING, 
						    Messages.getString("message.log.agent.4"), 
						    Messages.getString("message.log.agent.1", args) + "\n" + e.getMessage());
				
				//顼ȯΤǥե륯ƥץ
				
				closeFile(fr);
				
				//ե륪ץ
				fr = openFile(name, false, true);
				if(fr == null){
					return;
				}

				filesize=0;
				carryOver = "";
				
				
			}
		}
	}
	
	/**
	 * ž׵.
	 *  
	 */
	public void requestStop() {
		this.m_stopFlg = true;
		this.interrupt();
	}
	
	
	/**
	 * ƻ
	 * 
	 * @param priority 
	 * @param app ץꥱ
	 * @param msgId åID
	 * @param msg å
	 * @param msgOrg ꥸʥå
	 */
	private void sendMessage(int priority, String app, String msgId, String msg, String msgOrg) {
		
		m_transferLogManager.sendMessage(m_filePath, priority, app, msgId, msg, msgOrg);
	
	}
	
	/**
	 * žоݥե륯
	 * 
	 */
	private void closeFile(RandomAccessFile fr) {
		
		if(fr != null){
			try {
				fr.close();
			} catch (IOException e) {
				log.debug("run() : " + e.getMessage());
			}
		}
	}
	
	/**
	 * žоݥե륪ץ
	 * 
	 */
	private RandomAccessFile openFile( File name, boolean init, boolean isOnErr) {
		
		boolean err = isOnErr;
		RandomAccessFile fr = null;
		// ե륪ץ
		while(true){
			
			try{
				
				fr = new RandomAccessFile(name,"r");
				
				long filesize = fr.length();
				if(filesize > this.m_fileMaxSize){
					// ե륵礭硢ƻ
					Object[] args1 = { this.m_filePath };
					Object[] args2 = { filesize };
					sendMessage(PriorityConstant.TYPE_INFO, 
								Messages.getString("message.log.agent.3"), 
								MESSAGE_ID_INFO, 
								Messages.getString("message.log.agent.3"), 
								Messages.getString("message.log.agent.1", args1) + ", " + Messages.getString("message.log.agent.5", args2));
				}
				
				// եݥ󥿤
				if(init){
					fr.seek(filesize);
				}
				
				return fr;
				
			}
			catch(FileNotFoundException e){
				if(init && !err){
					if(this.m_existenceFlg == YesNoConstant.TYPE_YES){
						// ǽ˥եå硢ƻ
						Object[] args = { this.m_filePath };
						sendMessage(PriorityConstant.TYPE_INFO, Messages.getString("message.log.agent.2"), MESSAGE_ID_INFO, Messages.getString("message.log.agent.2"), Messages.getString("message.log.agent.1", args));
					}
					err = true;
				}
				
			}
			catch(SecurityException e){
				if(!err){
					// ƻ
					Object[] args = { this.m_filePath };
					sendMessage(PriorityConstant.TYPE_WARNING, 
								Messages.getString("message.log.agent.4"), 
								MESSAGE_ID_WARNING, 
								Messages.getString("message.log.agent.4"), 
								Messages.getString("message.log.agent.1", args) + "\n" + e.getMessage());
					err = true;
				}
			} catch (IOException e) {
				if(!err){
					// ƻ
					Object[] args = { this.m_filePath };
					sendMessage(PriorityConstant.TYPE_INFO, 
								Messages.getString("message.log.agent.4"), 
								MESSAGE_ID_INFO, 
								Messages.getString("message.log.agent.4"), Messages.getString("message.log.agent.1", args));
					err = true;
				}

				closeFile(fr);				
			}

			//ϽΤߤȤ
			//󥪡ץ˼Ը塢ե򥪡ץ󤹤ȡեΥ꡼ɥݥ󥿤
			//եΥץꤵƤޤ
			init = false;
			
			// ꡼
			try {
				Thread.sleep(this.m_runInterval);
			} catch (InterruptedException ie) {
			}

			if(this.m_stopFlg){
				return null;
			}
			
		}
		
		
	}

	
	public void setCondition(int chkExistence, int interval) {
		m_existenceFlg = chkExistence;
		m_runInterval = interval * 1000;
	}

	public static void main(String[] args) {

	}
	
}