/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.logagent.util;

import java.util.Properties;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jnp.interfaces.NamingContext;

import com.clustercontrol.repository.ejb.session.RepositoryController;
import com.clustercontrol.repository.ejb.session.RepositoryControllerHome;


/**
 * EJBȤΥͥ륯饹
 * RepositoryControllerEJBƤӽФΥإ
 * @version $Revision: 1.1 $
 * @since 1.0.0
 */
public class EjbConnectionManager {
    
	private Properties m_props = null;

	private NamingContext m_con = null;

	//
	static private Log log = LogFactory.getLog(EjbConnectionManager.class);

	/**
	 * 󥹥ȥ饯
	 * @param propץѥƥե
	 */
	public EjbConnectionManager(Properties prop) {
		m_props = prop;
	}
	
	/**
	 * RepositoryCollectorޤ
	 * @returnRepositoryCollector
	 */
	public synchronized RepositoryController getRepositoryController() throws Exception {

		try {
			if(m_con != null)
				LoginManager.getContextManager(m_props).logout();
			m_con = LoginManager.getContextManager(m_props).getNamingContext();
			
			RepositoryControllerHome home = (RepositoryControllerHome) m_con
		    	.lookup(RepositoryControllerHome.JNDI_NAME);
			return home.create();
		} catch (Exception e) {
			log.error(e);
			LoginManager.getContextManager(m_props).logout();
			m_con = null;
			throw e;
		}
	}
}
