/*
 
 Copyright (C) 2006 NTT DATA Corporation
 
 This program is free software; you can redistribute it and/or
 Modify it under the terms of the GNU General Public License 
 as published by the Free Software Foundation, version 2.
 
 This program is distributed in the hope that it will be
 useful, but WITHOUT ANY WARRANTY; without even the implied 
 warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
 PURPOSE.  See the GNU General Public License for more details.
 
 */

package com.clustercontrol.logagent.util;

import java.io.FileInputStream;
import java.util.Properties;

import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

/**
 * syslogؤΥž饹
 * 
 * @version 2.1.0
 * @since 2.1.0
 */
public class LoggerSyslog {
	
	/** Log4J */
	static Logger log = Logger.getLogger("hinemos.syslog.transfer"); 
	
	/** åν */
	private int m_priority = Priority.INFO_INT;
	
	/**
	 * 󥹥ȥ饯
	 * 
	 * @param props žȥץѥƥ
	 */
	public LoggerSyslog(Properties props) {
		
		// åν
		String priorityText = props.getProperty("syslog.message.priority");
		
		Priority priority = Priority.toPriority(priorityText, Priority.INFO);
		m_priority =  priority.toInt();
	}
	
	/**
	 * ž
	 * 
	 * @param message the message object to log. 
	 */
	public void log(Object message) {
		
		switch (m_priority) {
		case Priority.DEBUG_INT:
			log.debug(message);
			break;
		case Priority.INFO_INT:
			log.info(message);
			break;
		case Priority.WARN_INT:
			log.warn(message);
			break;
		case Priority.ERROR_INT:
			log.error(message);
			break;
		case Priority.FATAL_INT:
			log.fatal(message);
			break;
			
		default:
			break;
		}
	}
	
	public static void main(String[] args) {
		
		Properties props = new Properties();
		try {
			props.load(new FileInputStream(args[0]));
			
			LoggerSyslog sys = new LoggerSyslog(props);
			sys.log("test");
			
		} catch (Exception e) {
			e.printStackTrace();
		}
	}
}