/*
 
 Copyright (C) 2006 NTT DATA Corporation
 
 This program is free software; you can redistribute it and/or
 Modify it under the terms of the GNU General Public License 
 as published by the Free Software Foundation, version 2.
 
 This program is distributed in the hope that it will be
 useful, but WITHOUT ANY WARRANTY; without even the implied 
 warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
 PURPOSE.  See the GNU General Public License for more details.
 
 */

package com.clustercontrol.logtransfer.ejb.mdb;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;

import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.ejb.FinderException;
import javax.jms.JMSException;
import javax.jms.ObjectMessage;
import javax.jms.TextMessage;
import javax.naming.NamingException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.bean.ValidConstant;
import com.clustercontrol.logtransfer.bean.LogTransferFileInfo;
import com.clustercontrol.logtransfer.bean.LogTransferInfo;
import com.clustercontrol.logtransfer.bean.TopicConstant;
import com.clustercontrol.logtransfer.factory.SelectLogTransfer;
import com.clustercontrol.logtransfer.message.DeleteLogTransferInfo;
import com.clustercontrol.logtransfer.util.SendTopic;
import com.clustercontrol.repository.ejb.session.RepositoryControllerBean;
import com.clustercontrol.repository.ejb.session.RepositoryControllerLocal;
import com.clustercontrol.repository.ejb.session.RepositoryControllerUtil;
import com.clustercontrol.repository.message.UpdateRepositoryInfo;

/**
 *
 * <!-- begin-user-doc --> You can insert your documentation for '<em><b>ManageLogTransferFileBean</b></em>'. <!-- end-user-doc --> *
 *
 * <!-- begin-xdoclet-definition -->
 * @ejb.bean name="ManageLogTransferFileBean"
 *     acknowledge-mode="Auto-acknowledge"
 *     destination-type="javax.jms.Queue"
 *     
 *     transaction-type="Container"
 *     destination-jndi-name="queue/clustercontrol/Logtransfer/LogTransferFileManage"
 * 
 * @jboss.depends name="jboss.j2ee:service=EJB,jndiName=AccessController"
 * @jboss.depends name="jboss.j2ee:service=EJB,jndiName=RepositoryController"
 * @jboss.depends name="jboss.j2ee:service=EJB,jndiName=LogTransferController"
 * @jboss.depends name="jboss.j2ee:service=EJB,jndiName=LogTransferInfo"
 * @jboss.depends name="jboss.j2ee:service=EJB,jndiName=LogTransferFileInfo"
 * 
 * @jboss.container-configuration
 *  name="Singleton Message Driven Bean"
 * 
 *--
 * Server Runtime Specific Tags
 * If you are not using a specific runtime, you can safely remove the tags below.
 * @jonas.message-driven-destination jndi-name="queue/clustercontrol/Logtransfer/LogTransferFileManage"
 * @jboss.destination-jndi-name name="queue/clustercontrol/Logtransfer/LogTransferFileManage"
 *
 *--
 * <!-- end-xdoclet-definition -->
 * @generated
 **/
public class ManageLogTransferFileBean implements javax.ejb.MessageDrivenBean, javax.jms.MessageListener {
	
	protected static Log m_log = LogFactory.getLog( ManageLogTransferFileBean.class );
	
	/** եƥID󥭥å */
	private static HashMap<String, ArrayList<String>> m_facilityIdsMap = null;
	
	/** žоݥե󥭥å */
	private static HashMap<String, ArrayList<LogTransferFileInfo>> m_fileInfoMap = null;
	
	/** 
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * The context for the message-driven bean, set by the EJB container. 
	 * @generated
	 */
	private javax.ejb.MessageDrivenContext messageContext = null;
	
	/** 
	 * Required method for container to set context.
	 * @generated 
	 */
	public void setMessageDrivenContext(
			javax.ejb.MessageDrivenContext messageContext)
	throws javax.ejb.EJBException {
		this.messageContext = messageContext;
	}
	
	/** 
	 * Required creation method for message-driven beans. 
	 *
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * <!-- begin-xdoclet-definition -->
	 * @ejb.create-method 
	 * <!-- end-xdoclet-definition -->
	 * @generated
	 */
	public void ejbCreate() {
		
		// å
		refreshCache();
	}
	
	/** 
	 * Required removal method for message-driven beans. 
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void ejbRemove() {
		messageContext = null;
	}
	
	/** 
	 * This method implements the business logic for the EJB. 
	 * 
	 * <p>Make sure that the business logic accounts for asynchronous message processing. 
	 * For example, it cannot be assumed that the EJB receives messages in the order they were 
	 * sent by the client. Instance pooling within the container means that messages are not 
	 * received or processed in a sequential order, although individual onMessage() calls to 
	 * a given message-driven bean instance are serialized. 
	 * 
	 * <p>The <code>onMessage()</code> method is required, and must take a single parameter 
	 * of type javax.jms.Message. The throws clause (if used) must not include an application 
	 * exception. Must not be declared as final or static. 
	 *
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
	public void onMessage(javax.jms.Message message) {
		
		m_log.debug("Message Driven Bean got message " + message);
		
		try{
			if(message instanceof ObjectMessage){
				ObjectMessage objectMessage = (ObjectMessage)message;
				
				Object obj = objectMessage.getObject();
				
				if(obj instanceof LogTransferInfo){
					// ž ɲá
					LogTransferInfo info = (LogTransferInfo)obj;
					merge(info);
				}
				else if(obj instanceof DeleteLogTransferInfo){
					// ž 
					DeleteLogTransferInfo info = (DeleteLogTransferInfo)obj;
					merge(info);
				}
				else if(obj instanceof UpdateRepositoryInfo){
					// ݥȥ깹
					UpdateRepositoryInfo info = (UpdateRepositoryInfo)obj;
					mergeRepositoryInfo(info);
				}
				else{
					m_log.debug("onMessage(): ObjectMessage is not an expected instance. " + obj.toString());
				}
				
			}
			else if(message instanceof TextMessage){
				// Ȥ³
				TextMessage textMessage = (TextMessage)message;
				
				String facilityId = textMessage.getText();
				notify(facilityId);
			}
		}
		catch(JMSException e){
			m_log.error("onMessage():" + e.getMessage());
		}
		catch(EJBException e){
			m_log.error("onMessage():" + e.getMessage());
		}
		catch(Exception e){
			m_log.error("onMessage():" + e.getMessage());
		}
	}
	
	/**
	 * žޡ
	 * ɲá
	 * 
	 * @param info ž
	 */
	@SuppressWarnings("unchecked")
	public void merge(LogTransferInfo info) {
		
		if(info == null){
			return;
		}
		
		String transferId = info.getTransferId();
		String facilityId = info.getFacilityId();
		ArrayList<LogTransferFileInfo> fileInfoList = info.getFileInfo();
		
		ArrayList<LogTransferFileInfo> fileInfoListCache = m_fileInfoMap.get(transferId);
		ArrayList<String> facilityIdListCache = m_facilityIdsMap.get(transferId);
		
		try{
			// եƥID۲ƤΥեƥID
			ArrayList facilityIdList = null;
			RepositoryControllerLocal repository = RepositoryControllerUtil.getLocalHome().create();
			if(repository.isNode(facilityId)){
				// Ρɤξ
				facilityIdList = new ArrayList<String>();
				facilityIdList.add(facilityId);
			}
			else{
				// פξ
				facilityIdList = repository.getNodeFacilityIdList(facilityId, RepositoryControllerBean.ALL);
			}
			
			
			// ʬΥեƥIDСʥåˤäơˤʤ
			
			// ʬΥեƥID
			ArrayList<String> delFacilityIdList = new ArrayList<String>();
			if(facilityIdListCache != null){
				delFacilityIdList.addAll(facilityIdListCache);
				delFacilityIdList.removeAll(facilityIdList);
			}
			
			
			// եʬСʥåˤäơˤʤ
			// žоݥե̵
			ArrayList<LogTransferFileInfo> updateFileInfoList = new ArrayList<LogTransferFileInfo>();
			
			if(fileInfoListCache != null){
				boolean targetFlg = false;
				for (Iterator iter = fileInfoListCache.iterator(); iter.hasNext();) {
					LogTransferFileInfo logFileInfoCache = (LogTransferFileInfo) iter.next();
					String filePath = logFileInfoCache.getFilePath();
					
					for (Iterator iterator = fileInfoList.iterator(); iterator
					.hasNext();) {
						LogTransferFileInfo fileInfo = (LogTransferFileInfo) iterator.next();
						
						if( filePath.equals(fileInfo.getFilePath()) ){
							targetFlg = true;
							break;
						}
					}
					
					if(!targetFlg){
						// åξ󤬿ꤵ줿ˤʤк
						updateFileInfoList.add(logFileInfoCache);
					}
					targetFlg = false;
				}
				
				if(updateFileInfoList.size() != 0){
					// ̵ˤ
					updateFileInfoList = setValid(updateFileInfoList, ValidConstant.TYPE_INVALID);
				}
			}
			
			
			// žоݥե
			// Τ
			if(fileInfoListCache != null){
				// 1. եƥ
				// ʬΥեƥIDƤˡåΥե̵ꤷ
				// ž(LogTransferInfo)̵ä硢ե̵
				if(info.getValid() == ValidConstant.TYPE_INVALID){
					
					//եƥꥹȤɲ
					delFacilityIdList.addAll(facilityIdList);
					
				}
				// 
				if(delFacilityIdList.size() != 0){
					// žоݥե̵
					ArrayList<LogTransferFileInfo> delFileInfoListByFacility = setValid(fileInfoListCache, ValidConstant.TYPE_INVALID);
					
					// ž
					sendTopic(delFacilityIdList, delFileInfoListByFacility);
				}
			}
			
			// 2. եɲáѹ
			// žоݤΥեƥIDФ
			// ʬܹžоݥե
			if(info.getValid() == ValidConstant.TYPE_VALID){
				
				updateFileInfoList.addAll(fileInfoList);
				
				// ž
				sendTopic(facilityIdList, updateFileInfoList);
			}
			
			
			// å幹
			
			// եƥID󥭥å
			m_facilityIdsMap.put(transferId, facilityIdList);
			// žоݥե󥭥å
			m_fileInfoMap.put(transferId, fileInfoList);
			
		}
		catch(Exception e){
			m_log.error("onMessage(): žǧ˥顼ȯޤ" + e.getMessage());
		}
	}
	
	/**
	 * žޡ
	 * 
	 * 
	 * @param info ž
	 */
	public void merge(DeleteLogTransferInfo info) {
		
		if(info == null){
			return;
		}
		
		// žID
		String transferId = info.getTransferId();
		
		// åꡢեƥ
		ArrayList<String> facilityIdList = m_facilityIdsMap.get(transferId);
		
		// åꡢžоݥե
		ArrayList<LogTransferFileInfo> fileInfoList = m_fileInfoMap.get(transferId);
		
		// 
		delete(transferId, facilityIdList, fileInfoList);
		
		
	}
	
	/**
	 * ݥȥ󹹿б
	 * 
	 * @param info ݥȥ깹
	 */
	public void mergeRepositoryInfo(UpdateRepositoryInfo info) {
		
		if(info == null){
			return;
		}
		
		HashMap<String, ArrayList<String>> facilityIdsMap = null; 
		try{
			// žΥեƥIDƼ
			facilityIdsMap = new SelectLogTransfer().getFacilityIdsMap();
		} catch (CreateException e) {
			m_log.error("onMessage() : " + e.getMessage());
		} catch (FinderException e) {
			m_log.error("onMessage() : " + e.getMessage());
		} catch (NamingException e) {
			m_log.error("onMessage() : " + e.getMessage());
		}
		
		if(facilityIdsMap == null){
			return;
		}
		
		Set keySet = facilityIdsMap.keySet();
		for (Iterator iter = keySet.iterator(); iter.hasNext();) {
			String transferId = (String) iter.next();
			
			// ǿեƥID
			ArrayList<String> facilityIdList = facilityIdsMap.get(transferId);
			
			// åΥեƥID
			ArrayList<String> facilityIdListCache = m_facilityIdsMap.get(transferId);
			
			//
			// ѹʬΥեƥID
			//
			
			//ʬ
			ArrayList<String> delFacilityIdList = new ArrayList<String>(facilityIdListCache);
			delFacilityIdList.removeAll(facilityIdList);
			
			//ɲʬ
			ArrayList<String> addFacilityIdList = new ArrayList<String>(facilityIdList);
			addFacilityIdList.removeAll(facilityIdListCache);
			
			
			//
			// ž
			//
			
			// 
			if(delFacilityIdList.size() != 0){
				// žоݥե̵
				ArrayList<LogTransferFileInfo> fileInfoList = setValid(m_fileInfoMap.get(transferId), ValidConstant.TYPE_INVALID);
				
				// ž
				sendTopic(delFacilityIdList, fileInfoList);
				
			}				
			
			// ɲ
			if(addFacilityIdList.size() != 0){
				sendTopic(addFacilityIdList , m_fileInfoMap.get(transferId));
			}
			
		}
		
		
		//åι
		m_facilityIdsMap = facilityIdsMap;
		
	}
	
	/**
	 * 
	 * ꤵ줿եƥIDžоݥե
	 * 
	 * @param facilityId եƥID
	 */
	public void notify(String facilityId) {
		
		if(facilityId == null || "".equals(facilityId)){
			return;
		}
		
		//žѥޡ
		ArrayList<LogTransferFileInfo> fileInfoList = new ArrayList<LogTransferFileInfo>();
		
		// å󤫤顢եƥIDžоݥե
		
		Set keySet = m_facilityIdsMap.keySet();
		for (Iterator iter = keySet.iterator(); iter.hasNext();) {
			
			String transferId = (String) iter.next();
			ArrayList<String> facilityIdList = m_facilityIdsMap.get(transferId);
			if( facilityIdList.contains(facilityId) ){
				
				fileInfoList.addAll( m_fileInfoMap.get(transferId) );
				
			}
			
		}
		
		// ž
		
		if( fileInfoList.size() != 0){
			
			ArrayList<String> facilityIdList = new ArrayList<String>();
			facilityIdList.add(facilityId);
			
			sendTopic(facilityIdList , fileInfoList);
		}
	}
	
	/**
	 * žоݥե
	 * 
	 * @param transferId žID
	 * @param facilityIdList եƥIDꥹ
	 * @param fileInfoList žоݥեꥹ
	 */
	public void delete(String transferId, ArrayList<String> facilityIdList, ArrayList<LogTransferFileInfo> fileInfoList) {
		
		// žоݥե̵
		ArrayList<LogTransferFileInfo> delFileInfoList = setValid(fileInfoList, ValidConstant.TYPE_INVALID);
		
		// ž
		sendTopic(facilityIdList, delFileInfoList);
		
		// å
		m_facilityIdsMap.remove(transferId);
		m_fileInfoMap.remove(transferId);
	}
	
	/**
	 * žоݥե빹Topic
	 * եƥID
	 * 
	 * @param context ž
	 * @param facilityIdList TopicեƥID
	 */
	public void sendTopic(ArrayList<String> facilityIdList, ArrayList<LogTransferFileInfo> fileInfoList) {
		
		if(facilityIdList == null || facilityIdList.size() <= 0
				|| fileInfoList == null || fileInfoList.size() <= 0){
			return;
		}
		
		SendTopic send = null;
		String facilityId = null;
		try {
			send = new SendTopic(TopicConstant.TOPIC_NAME_UPDATE);
			
			for (int index = 0; index < facilityIdList.size(); index++) {
				facilityId = (String)facilityIdList.get(index);
				
				if(facilityId != null && !"".equals(facilityId)){
					
					// Topic
					m_log.debug("onMessage() : ž : facilityId=" + facilityId);
					send.put(facilityId, fileInfoList);
				}
			}
			
		} catch (Exception e) {
			m_log.error("onMessage() : ž顼 : facilityId=" + facilityId + ", " + e.getMessage());
		}
		finally{
			if(send != null){
				try {
					send.terminate();
				} catch (Exception e) {
				}
			}
		}
	}
	
	/**
	 * å򹹿
	 * 
	 * @return 硢true
	 */
	public boolean refreshCache() {
		try{
			SelectLogTransfer select = new SelectLogTransfer();
			
			// եƥID󥭥å
			m_facilityIdsMap = select.getFacilityIdsMap();
			// žоݥե󥭥å
			m_fileInfoMap = select.getLogTransferFileInfoMap();
			
			return true;
			
		} catch (Exception e) {
			m_log.error("refreshCache(): å˥顼ȯޤ " + e.getMessage());
			return false;
		}
	}
	
	/**
	 * žоݥե̵ͭ
	 * 
	 * @param fileInfoList žоݥեꥹ
	 */
	public ArrayList<LogTransferFileInfo> setValid(ArrayList<LogTransferFileInfo> fileInfoList, int valid) {
		ArrayList<LogTransferFileInfo> retFileInfoList = new ArrayList<LogTransferFileInfo>();
		for (int index = 0; index < fileInfoList.size(); index++) {
			
			LogTransferFileInfo oldInfo = fileInfoList.get(index);
			
			retFileInfoList.add(new LogTransferFileInfo(oldInfo.getTransferId(),oldInfo.getFilePath(),oldInfo.getRunInterval(),oldInfo.getExistenceFlg(),valid));
		}
		return  retFileInfoList;
	}
	
}