/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.logtransfer.ejb.session;

import java.rmi.RemoteException;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Locale;

import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.ejb.FinderException;
import javax.ejb.RemoveException;
import javax.ejb.SessionContext;
import javax.jms.JMSException;
import javax.naming.NamingException;

import org.eclipse.swt.SWT;

import com.clustercontrol.bean.TableColumnInfo;
import com.clustercontrol.logtransfer.bean.LogTransferFileTabelDefine;
import com.clustercontrol.logtransfer.bean.LogTransferInfo;
import com.clustercontrol.logtransfer.bean.LogTransferTabelDefine;
import com.clustercontrol.logtransfer.factory.AddLogTransfer;
import com.clustercontrol.logtransfer.factory.DeleteLogTransfer;
import com.clustercontrol.logtransfer.factory.ModifyLogTransfer;
import com.clustercontrol.logtransfer.factory.SelectLogTransfer;
import com.clustercontrol.util.Messages;

/**
 *
 * <!-- begin-xdoclet-definition --> 
 * @ejb.bean name="LogTransferController"	
 *           jndi-name="LogTransferController"
 *           type="Stateless"
 *           transaction-type="Container"
 *           
 * @jboss.depends name="jboss.j2ee:service=EJB,jndiName=AccessController"
 * @jboss.depends name="jboss.j2ee:service=EJB,jndiName=RepositoryController"
 * @jboss.depends name="jboss.j2ee:service=EJB,jndiName=SyslogNGController"
 *           
 * @ejb.permission
 *     unchecked="true"
 *     method-intf="Home"
 *     
 * @ejb.permission
 *     unchecked="true"
 *     method-intf="LocalHome"
 *     
 * @ejb.permission
 *     unchecked="true"
 *     method-intf="Local"
 *            
 * <!-- end-xdoclet-definition --> 
 * @generated
*/
public abstract class LogTransferControllerBean implements javax.ejb.SessionBean {

	@SuppressWarnings("unused")
	private SessionContext m_context;
	
	public void setSessionContext(SessionContext ctx) throws EJBException, RemoteException {
		m_context = ctx;
	}
	
	/**
	 * žϿޤ
	 * 
	 * @ejb.interface-method
	 * 
	 * @ejb.permission
     *     role-name="LogTransferWrite"
     *     method-intf="Remote"
	 * 
	 * @param info ž
	 * @return Ͽ硢true
	 * @throws CreateException
	 * @throws NamingException
	 * @throws JMSException
	 */
	public boolean addLogTransfer(LogTransferInfo info) throws CreateException, NamingException, JMSException {
		
		Principal pri = m_context.getCallerPrincipal();

		// žϿ
		AddLogTransfer logTransfer = new AddLogTransfer();
		return  logTransfer.add(info, pri.getName());
	}
	
	/**
	 * ž򹹿ޤ
	 * 
	 * @ejb.interface-method
	 * 
	 * @ejb.permission
     *     role-name="LogTransferWrite"
     *     method-intf="Remote"
	 * 
	 * @param info ž
	 * @return ѹ硢true
	 * @throws CreateException
	 * @throws FinderException
	 * @throws RemoveException
	 * @throws NamingException
	 * @throws JMSException
	 */
	public boolean modifyLogTransfer(LogTransferInfo info) throws CreateException, FinderException, RemoveException, NamingException, JMSException {
		
		Principal pri = m_context.getCallerPrincipal();

		// ž򹹿
		ModifyLogTransfer logTransfer = new ModifyLogTransfer();
		return  logTransfer.modify(info, pri.getName());
	}
	
	/**
	 * žޤ
	 * 
	 * @ejb.interface-method
	 * 
	 * @ejb.permission
     *     role-name="LogTransferWrite"
     *     method-intf="Remote"
	 * 
	 * @param transferId žID
	 * @return 硢true
	 * @throws FinderException
	 * @throws RemoveException
	 * @throws NamingException
	 * @throws JMSException
	 */
	public boolean deleteLogTransfer(String transferId) throws FinderException, RemoveException, NamingException, JMSException {

		// ž
		DeleteLogTransfer logTransfer = new DeleteLogTransfer();
		return  logTransfer.delete(transferId);
	}
	
	/**
	 * ž֤ޤ
	 * 
	 * @ejb.interface-method
	 * 
	 * @ejb.permission
     *     role-name="LogTransferRead"
     *     method-intf="Remote"
	 * 
	 * @jboss.method-attributes
	 *     read-only="true"
	 * 
	 * @param transferId žID
	 * @return ž
	 * @throws CreateException
	 * @throws FinderException
	 * @throws NamingException
	 */
	public LogTransferInfo getLogTransfer(String transferId) throws CreateException, FinderException, NamingException {

		// ž
		SelectLogTransfer logTransfer = new SelectLogTransfer();
		LogTransferInfo info = logTransfer.getLogTransfer(transferId);

		return info;
	}
	
	/**
	 * žꥹȤ֤ޤ
	 * 
	 * @ejb.interface-method
	 * 
	 * @ejb.permission
     *     role-name="LogTransferRead"
     *     method-intf="Remote"
	 * 
	 * @jboss.method-attributes
	 *     read-only="true"
	 * 
	 * @return Object2
	 * @throws CreateException
	 * @throws FinderException
	 * @throws NamingException
	 */
	public ArrayList getLogTransferList() throws CreateException, FinderException, NamingException {

		// ž
		SelectLogTransfer logTransfer = new SelectLogTransfer();
		ArrayList list = logTransfer.getLogTransferList();

		return list;
	}
	
	/**
	 * žΥơ֥֤ޤ
	 * 
	 * @ejb.interface-method
	 * 
	 * @ejb.permission
     *     unchecked="true"
     *     method-intf="Remote"
	 * 
	 * @param locale 
	 * @return TableColumnInfo
	 */
	@SuppressWarnings("unchecked")
	public ArrayList getLogTransferListTableDefine(Locale locale) {
		
		/** ơ֥ */
		ArrayList tableDefine = new ArrayList();

		tableDefine.add(LogTransferTabelDefine.TRANSFER_ID, 
				new TableColumnInfo(Messages.getString("logtransfer.id", locale), TableColumnInfo.NONE, 100, SWT.LEFT));
		tableDefine.add(LogTransferTabelDefine.DESCRIPTION, 
				new TableColumnInfo(Messages.getString("description", locale), TableColumnInfo.NONE, 200, SWT.LEFT));
		tableDefine.add(LogTransferTabelDefine.FACILITY_ID, 
				new TableColumnInfo(Messages.getString("scope", locale), TableColumnInfo.FACILITY, 200, SWT.LEFT));
		tableDefine.add(LogTransferTabelDefine.VALID_FLG, 
				new TableColumnInfo(Messages.getString("valid", locale) + "/" + Messages.getString("invalid", locale), TableColumnInfo.VALID, 80, SWT.LEFT));
		tableDefine.add(LogTransferTabelDefine.CREATE_USER, 
				new TableColumnInfo(Messages.getString("creator.name", locale), TableColumnInfo.NONE, 80, SWT.LEFT));
		tableDefine.add(LogTransferTabelDefine.CREATE_TIME, 
				new TableColumnInfo(Messages.getString("create.time", locale), TableColumnInfo.NONE, 130, SWT.LEFT));
		tableDefine.add(LogTransferTabelDefine.UPDATE_USER, 
				new TableColumnInfo(Messages.getString("modifier.name", locale), TableColumnInfo.NONE, 80, SWT.LEFT));
		tableDefine.add(LogTransferTabelDefine.UPDATE_TIME, 
				new TableColumnInfo(Messages.getString("update.time", locale), TableColumnInfo.NONE, 130, SWT.LEFT));

		return tableDefine;
	}
	
	/**
	 * žоݥեΥơ֥֤ޤ
	 * 
	 * @ejb.interface-method
	 * 
	 * @ejb.permission
     *     unchecked="true"
     *     method-intf="Remote"
	 * 
	 * @param locale 
	 * @return TableColumnInfo
	 */
	@SuppressWarnings("unchecked")
	public ArrayList getLogTransferFileListTableDefine(Locale locale) {
		
		/** ơ֥ */
		ArrayList tableDefine = new ArrayList();

		tableDefine.add(LogTransferFileTabelDefine.FILE_PATH, 
				new TableColumnInfo(Messages.getString("file.path", locale), TableColumnInfo.NONE, 300, SWT.LEFT));
		tableDefine.add(LogTransferFileTabelDefine.RUN_INTERVAL, 
				new TableColumnInfo(Messages.getString("semantics.interval.sec", locale), TableColumnInfo.NONE, 100, SWT.LEFT));
		tableDefine.add(LogTransferFileTabelDefine.FILE_EXISTENCE_CHECK, 
				new TableColumnInfo(Messages.getString("file.first.existence.check", locale), TableColumnInfo.CHECKBOX, 170, SWT.LEFT));
		tableDefine.add(LogTransferFileTabelDefine.VALID_FLG, 
				new TableColumnInfo(Messages.getString("valid", locale) + "/" + Messages.getString("invalid", locale), TableColumnInfo.VALID, 80, SWT.LEFT));
		
		return tableDefine;
	}
}
