/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.monitor.action;

import java.rmi.AccessException;
import java.rmi.RemoteException;
import java.sql.SQLException;
import java.util.List;

import javax.ejb.CreateException;
import javax.ejb.FinderException;
import javax.naming.NamingException;

import org.eclipse.jface.dialogs.MessageDialog;

import com.clustercontrol.bean.ConfirmConstant;
import com.clustercontrol.bean.Property;
import com.clustercontrol.monitor.ejb.session.MonitorController;
import com.clustercontrol.monitor.util.EjbConnectionManager;
import com.clustercontrol.util.Messages;
import com.clustercontrol.util.PropertyUtil;

/**
 * ٥ȴƻγǧԤ饹Ǥ
 * 
 * @version 1.0.0
 * @since 1.0.0
 */
public class ConfirmEvent {

    // ----- 󥹥ȥ饯 ----- //

    // ----- instance ᥽å ----- //

    /**
     * ꤷפΥ٥ȳǧ̵ֳͭǧѡפˤޤ
     * 
     * @param facilityId
     *            եƥID
     */
    public boolean confirm(List list) {

        if (list != null && list.size()>0) {
        	
            MonitorController monitor = EjbConnectionManager
                    .getConnectionManager().getMonitorController();

            try {
                monitor.modifyConfirm(list, ConfirmConstant.TYPE_CONFIRMED);
                return true;
            } catch (RemoteException e) {
    			if(e instanceof AccessException){
    				// ʤξ硢顼ɽ
    	            MessageDialog.openInformation(null, Messages.getString("message"),
    	                    Messages.getString("message.accesscontrol.16"));
    			}
            } catch (CreateException e) {
            } catch (FinderException e) {
            } catch (NamingException e) {
            }
        }
        return false;
    }

    /**
     * ꤷפΥ٥ȳǧ̵̤ͭǧפˤޤ
     * 
     * @param facilityId
     *            եƥID
     */
    public boolean unconfirm(List list) {

        if (list != null && list.size()>0) {
        	
            MonitorController monitor = EjbConnectionManager
                    .getConnectionManager().getMonitorController();

            try {
                monitor.modifyConfirm(list, ConfirmConstant.TYPE_UNCONFIRMED);
                return true;
            } catch (RemoteException e) {
    			if(e instanceof AccessException){
    				// ʤξ硢顼ɽ
    	            MessageDialog.openInformation(null, Messages.getString("message"),
    	                    Messages.getString("message.accesscontrol.16"));
    			}
            } catch (CreateException e) {
            } catch (FinderException e) {
            } catch (NamingException e) {
            }
        }
        return false;
    }

    /**
     * ˥ޥå٥ȴƻΥ٥ȳǧ̵ͭơֳǧѡפޤϡ̤ǧפ˰繹ޤ
     * 
     * @param confirmType
     *            ǧ/̤ǧ
     * @param facilityId
     *            եƥID
     * @param condition
     *            
     * @return 
     */
    public boolean confirmBatch(int confirmType, String facilityId,
            Property condition) {

        PropertyUtil.deletePropertyDefine(condition);

        MonitorController monitor = EjbConnectionManager.getConnectionManager()
                .getMonitorController();

        try {
            monitor.modifyBatchConfirm(confirmType, facilityId, condition);
            return true;
        } catch (RemoteException e) {
			if(e instanceof AccessException){
				// ʤξ硢顼ɽ
	            MessageDialog.openInformation(null, Messages.getString("message"),
	                    Messages.getString("message.accesscontrol.16"));
			}
        } catch (CreateException e) {
        } catch (FinderException e) {
        } catch (NamingException e) {
		} catch (SQLException e) {
		}
        return false;
    }
}