/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.monitor.action;

import java.rmi.AccessException;
import java.rmi.RemoteException;
import java.util.Date;
import java.util.List;
import java.util.Locale;

import javax.ejb.FinderException;
import javax.naming.NamingException;

import org.eclipse.jface.dialogs.MessageDialog;

import com.clustercontrol.bean.Property;
import com.clustercontrol.monitor.bean.EventTabelDefine;
import com.clustercontrol.monitor.ejb.session.MonitorController;
import com.clustercontrol.monitor.util.EjbConnectionManager;
import com.clustercontrol.util.Messages;

/**
 * ٥Ⱦܺ٤륯饹Ǥ
 * 
 * @version 2.0.0
 * @since 2.0.0
 */
public class GetEventInfoProperty {

    // ----- instance ᥽å ----- //

    /**
     * ٥Ⱦܺ٤֤ޤ
     * 
     * @return ٥Ⱦܺ
     */
    public Property getProperty(List list) {

        Property property = null;
        if (list != null) {
            String monitorId = (String) list.get(EventTabelDefine.MONITOR_ID);
            String pluginId = (String) list.get(EventTabelDefine.PLUGIN_ID);
            String facilityId = (String) list.get(EventTabelDefine.FACILITY_ID);
            Date receiveTime = (Date) list.get(EventTabelDefine.RECEIVE_TIME);

            MonitorController monitor = EjbConnectionManager.getConnectionManager().getMonitorController();

            try {
            	property = monitor.getEventInfoProperty(monitorId, pluginId, facilityId, receiveTime, Locale.getDefault());
            } catch (RemoteException e) {
    			if(e instanceof AccessException){
    				// ʤξ硢顼ɽ
    	            MessageDialog.openInformation(null, Messages.getString("message"),
    	                    Messages.getString("message.accesscontrol.16"));
    			}
	        } catch (FinderException e) {
	        } catch (NamingException e) {
	        }
	    }
        return property;
   }
}