/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.monitor.action;

import java.rmi.AccessException;
import java.rmi.RemoteException;
import java.sql.SQLException;

import javax.ejb.CreateException;
import javax.ejb.FinderException;
import javax.naming.NamingException;

import com.clustercontrol.bean.Property;
import com.clustercontrol.monitor.bean.EventListInfo;
import com.clustercontrol.monitor.ejb.session.MonitorController;
import com.clustercontrol.monitor.util.EjbConnectionManager;
import com.clustercontrol.util.PropertyUtil;

/**
 * ٥ȴƻ륯饹Ǥ
 * 
 * @version 1.0.0
 * @since 1.0.0
 */
public class GetFilterEvent {

    // ----- 󥹥ȥ饯 ----- //

    // ----- instance ᥽å ----- //

    /**
     * facilityId˴Ϣ륤٥ȴƻ֤ޤ
     * 
     * @param facilityId եƥID
     * @return ٥ȴƻ
     * @throws AccessException
     */
    public EventListInfo getFilterInfo(String facilityId)
            throws AccessException {

        MonitorController monitor = EjbConnectionManager.getConnectionManager()
                .getMonitorController();

        EventListInfo records = null;
        try {
            records = monitor.getEventList(facilityId);
        } catch (RemoteException e) {
			if(e instanceof AccessException){
				// ʤξ
				throw (AccessException) e;
			}
        } catch (CreateException e) {
        } catch (FinderException e) {
        } catch (NamingException e) {
        } catch (SQLException e) {
		}
        return records;
    }

    /**
     * ˥ޥå٥ȴƻ֤ޤ
     * 
     * @param facilityId եƥID
     * @param condition 
     * @return ٥ȴƻ
     * @throws AccessException
     */
    public EventListInfo getFilterInfo(String facilityId, Property condition)
            throws AccessException {

        PropertyUtil.deletePropertyDefine(condition);

        MonitorController monitor = EjbConnectionManager.getConnectionManager()
                .getMonitorController();

        EventListInfo records = null;
        try {
            records = monitor.getEventList(facilityId, condition);
        } catch (RemoteException e) {
			if(e instanceof AccessException){
				// ʤξ
				throw (AccessException) e;
			}
        } catch (CreateException e) {
        } catch (FinderException e) {
        } catch (NamingException e) {
        } catch (SQLException e) {
		}
        return records;
    }
}