/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.monitor.ejb.mdb;

import java.sql.Timestamp;
import java.util.Date;
import java.util.HashMap;

import javax.ejb.EJBException;
import javax.jms.JMSException;
import javax.jms.ObjectMessage;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.monitor.bean.QueueConstant;
import com.clustercontrol.monitor.factory.CreateLogOutputInfo;
import com.clustercontrol.monitor.factory.OutputEventLog;
import com.clustercontrol.monitor.factory.OutputStatusInfo;
import com.clustercontrol.monitor.message.LogOutputInfo;
import com.clustercontrol.monitor.message.LogOutputNotifyInfo;
import com.clustercontrol.monitor.message.ParallelLogOutputInfo;
import com.clustercontrol.monitor.util.SendMail;
import com.clustercontrol.monitor.util.SendQueue;
import com.clustercontrol.notify.bean.NotifyInfo;
import com.clustercontrol.notify.bean.NotifyInfoContext;
import com.clustercontrol.notify.factory.SelectNotify;

/**
 *
 * <!-- begin-user-doc --> You can insert your documentation for '<em><b>LogOutputBean</b></em>'. <!-- end-user-doc --> *
 *
 * <!-- begin-xdoclet-definition -->
 * @ejb.bean name="LogOutputBean" 
 *     acknowledge-mode="Auto-acknowledge"
 *     destination-type="javax.jms.Queue"
 *     
 *     transaction-type="Container"
 *     destination-jndi-name="queue/clustercontrol/Monitor/EventLog"
 * 
 * @jboss.depends name="jboss.j2ee:service=EJB,jndiName=AccessController"
 * @jboss.depends name="jboss.j2ee:service=EJB,jndiName=RepositoryController"
 * @jboss.depends name="jboss.j2ee:service=EJB,jndiName=NotifyController"
 * @jboss.depends name="jboss.j2ee:service=EJB,jndiName=NotifyInfo"
 * @jboss.depends name="jboss.j2ee:service=EJB,jndiName=EventLog"
 * @jboss.depends name="jboss.j2ee:service=EJB,jndiName=QuartzManager"
 * 
 * @jboss.container-configuration
 *  name="Singleton Message Driven Bean"
 * 
 *--
 * Server Runtime Specific Tags
 * If you are not using a specific runtime, you can safely remove the tags below.
 * @jonas.message-driven-destination jndi-name="queue/clustercontrol/Monitor/EventLog"
 * @jboss.destination-jndi-name name="queue/clustercontrol/Monitor/EventLog"
 *
 *--
 * <!-- end-xdoclet-definition -->
 * @generated
 **/
public class LogOutputBean implements javax.ejb.MessageDrivenBean, javax.jms.MessageListener {
	
	protected static Log m_log = LogFactory.getLog( LogOutputBean.class );
	private static SendMail m_sender = new SendMail();
	
	/** ξ󥭥å */
	private static HashMap<String, NotifyInfo> m_notifyMap = null;
	
	/** 
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * The context for the message-driven bean, set by the EJB container. 
	 * @generated
	 */
	private javax.ejb.MessageDrivenContext messageContext = null;
	
	/** 
	 * Required method for container to set context.
	 * @generated 
	 */
	public void setMessageDrivenContext(
			javax.ejb.MessageDrivenContext messageContext)
	throws javax.ejb.EJBException {
		this.messageContext = messageContext;
	}
	
	/** 
	 * Required creation method for message-driven beans. 
	 *
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * <!-- begin-xdoclet-definition -->
	 * @ejb.create-method 
	 * <!-- end-xdoclet-definition -->
	 * @generated
	 */
	public void ejbCreate() {
		//no specific action required for message-driven beans 
	}
	
	/** 
	 * Required removal method for message-driven beans. 
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void ejbRemove() {
		messageContext = null;
	}
	
	/** 
	 * This method implements the business logic for the EJB. 
	 * 
	 * <p>Make sure that the business logic accounts for asynchronous message processing. 
	 * For example, it cannot be assumed that the EJB receives messages in the order they were 
	 * sent by the client. Instance pooling within the container means that messages are not 
	 * received or processed in a sequential order, although individual onMessage() calls to 
	 * a given message-driven bean instance are serialized. 
	 * 
	 * <p>The <code>onMessage()</code> method is required, and must take a single parameter 
	 * of type javax.jms.Message. The throws clause (if used) must not include an application 
	 * exception. Must not be declared as final or static. 
	 *
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
	public void onMessage(javax.jms.Message message) {
		if(m_log.isDebugEnabled()){
			m_log.debug("onMessage start : Message Driven Bean got message " + message);
		}
		
		// ξ󥭥å
		if(m_notifyMap == null){
			try{
				m_notifyMap = new SelectNotify().getNotifyMap();
				
			} catch (Exception e) {
				m_log.error("onMessage(): ξ󥭥å˥顼ȯޤ " + e.getMessage());
			}
		}
		
		if(message instanceof ObjectMessage)
		{
			ObjectMessage msg = (ObjectMessage)message;
			
			try
			{
				Object objMsg = msg.getObject();
				// 
				if(objMsg instanceof LogOutputInfo)
				{
					LogOutputInfo info = (LogOutputInfo)objMsg;
					outputLog(info);
				}
				// IDȤ˥
				else if(objMsg instanceof LogOutputNotifyInfo){
					LogOutputNotifyInfo basicInfo = (LogOutputNotifyInfo)objMsg;
					
					if(basicInfo != null){
						String notifyId = basicInfo.getNotifyId();
						if(notifyId != null && !"".equals(notifyId.trim())){
							
							// åξ
							NotifyInfo notifyInfo = m_notifyMap.get(notifyId);
							if(notifyInfo != null){
								LogOutputInfo info = new CreateLogOutputInfo().get(notifyInfo, basicInfo);
								outputLog(info);
							}
						}
					}
				}
				// ξ󥭥å幹
				else if(objMsg instanceof NotifyInfoContext){
					
					try{
						NotifyInfoContext notifyInfoContext = (NotifyInfoContext)objMsg;
						
						// ξϿ ޤ  
						if(NotifyInfoContext.TYPE_ADD == notifyInfoContext.getType() || 
								NotifyInfoContext.TYPE_UPDATE == notifyInfoContext.getType()){
							
							m_notifyMap.put(notifyInfoContext.getNotifyId(), notifyInfoContext.getNotifyInfo());
						}
						// ξ
						else if(NotifyInfoContext.TYPE_DELETE == notifyInfoContext.getType()){
							m_notifyMap.remove(notifyInfoContext.getNotifyId());
						}
					}
					catch(Exception e){
						m_log.error("onMessage(): ξ󥭥å幹˥顼ȯޤ" + e.getMessage());
					}
				}
				else
				{
					m_log.debug("onMessage(): ObjectMessage is not an expected instance. " + objMsg.toString());
				}
			}
			catch(JMSException e){
				m_log.error("onMessage():" + e.getMessage());
			}
			catch(EJBException e){
				m_log.error("onMessage():" + e.getMessage());
			}
			catch(Exception e){
				m_log.error("onMessage():" + e.getMessage());
			}	
		}
		
		if(m_log.isDebugEnabled()){
			m_log.debug("onMessage end   : Message Driven Bean got message " + message);
		}
	}
	
	public void outputLog(LogOutputInfo logOutput) {
		
		if(!(logOutput instanceof LogOutputInfo))
			return;
		
//		//å
//		AccessLock.lock(AccessLock.MONITOR);
		
		Date now = new Date();
		Timestamp outputDate = new Timestamp(now.getTime());
		boolean result = false;
		
		// 
		OutputEventLog eventLog = new OutputEventLog();
		result = eventLog.outputEventLog(logOutput, outputDate);
		
		// ơ
		OutputStatusInfo statusInfo = new OutputStatusInfo();
		result = statusInfo.outputStatusInfo(logOutput, eventLog.getOutputDate());
		
		// ᡼
		if(eventLog.isInsertFlg()){
			
			String[] address = logOutput.getAddress();
			
			if(address == null || address.length <= 0) {
				// ᡼륢ɥ쥹ꤵƤʤϲ⤷ʤ
			} else {	
				SendQueue queue = null;
				try {
					//Queue
					queue = new SendQueue(QueueConstant.QUEUE_NAME_SENDMAIL);
					ParallelLogOutputInfo info = new ParallelLogOutputInfo();
					info.setLogOutputInfo(logOutput);
					info.setOutputDate(eventLog.getOutputDate());
					queue.put(info);
				}
				catch (Exception e) {
					m_log.debug("outputEventLog() : ᡼å顼 : " + e.getMessage());
				}
				finally{
					if(queue != null){
						try {
							queue.terminate();
						} catch (JMSException e) {
						}	
					}
				}
			}
		}
	}
}