/*
 
 Copyright (C) 2006 NTT DATA Corporation
 
 This program is free software; you can redistribute it and/or
 Modify it under the terms of the GNU General Public License 
 as published by the Free Software Foundation, version 2.
 
 This program is distributed in the hope that it will be
 useful, but WITHOUT ANY WARRANTY; without even the implied 
 warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
 PURPOSE.  See the GNU General Public License for more details.
 
 */

package com.clustercontrol.monitor.ejb.mdb;

import java.sql.Timestamp;
import java.util.Date;

import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.jms.JMSException;
import javax.jms.ObjectMessage;
import javax.naming.NamingException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.bean.YesNoConstant;
import com.clustercontrol.monitor.factory.OutputEventLog;
import com.clustercontrol.monitor.message.LogOutputInfo;
import com.clustercontrol.monitor.message.LogOutputJobRunInfo;
import com.clustercontrol.monitor.util.RunJob;
import com.clustercontrol.util.Messages;

/**
 *
 * <!-- begin-user-doc --> You can insert your documentation for '<em><b>RunJobBean</b></em>'. <!-- end-user-doc --> *
 *
 * <!-- begin-xdoclet-definition -->
 * @ejb.bean name="RunJobBean" 
 *     acknowledge-mode="Auto-acknowledge"
 *     destination-type="javax.jms.Queue"
 *     
 *     transaction-type="Container"
 *     destination-jndi-name="queue/clustercontrol/Monitor/RunJob"
 * 
 * @jboss.depends name="jboss.j2ee:service=EJB,jndiName=AccessController"
 * @jboss.depends name="jboss.j2ee:service=EJB,jndiName=RepositoryController"
 * @jboss.depends name="jboss.j2ee:service=EJB,jndiName=NotifyController"
 * @jboss.depends name="jboss.j2ee:service=EJB,jndiName=QuartzManager"
 * 
 * @jboss.container-configuration
 *  name="Singleton Message Driven Bean"
 * 
 *--
 * Server Runtime Specific Tags
 * If you are not using a specific runtime, you can safely remove the tags below.
 * @jonas.message-driven-destination jndi-name="queue/clustercontrol/Monitor/RunJob"
 * @jboss.destination-jndi-name name="queue/clustercontrol/Monitor/RunJob"
 *
 *--
 * <!-- end-xdoclet-definition -->
 * @generated
 **/
public class RunJobBean implements javax.ejb.MessageDrivenBean, javax.jms.MessageListener {
	protected static Log m_log = LogFactory.getLog( RunJobBean.class );
	
	/** 
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * The context for the message-driven bean, set by the EJB container. 
	 * @generated
	 */
	private javax.ejb.MessageDrivenContext messageContext = null;
	
	/** 
	 * Required method for container to set context.
	 * @generated 
	 */
	public void setMessageDrivenContext(
			javax.ejb.MessageDrivenContext messageContext)
	throws javax.ejb.EJBException {
		this.messageContext = messageContext;
	}
	
	/** 
	 * Required creation method for message-driven beans. 
	 *
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * <!-- begin-xdoclet-definition -->
	 * @ejb.create-method 
	 * <!-- end-xdoclet-definition -->
	 * @generated
	 */
	public void ejbCreate() {
		//no specific action required for message-driven beans 
	}
	
	/** 
	 * Required removal method for message-driven beans. 
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void ejbRemove() {
		messageContext = null;
	}
	
	/** 
	 * This method implements the business logic for the EJB. 
	 * 
	 * <p>Make sure that the business logic accounts for asynchronous message processing. 
	 * For example, it cannot be assumed that the EJB receives messages in the order they were 
	 * sent by the client. Instance pooling within the container means that messages are not 
	 * received or processed in a sequential order, although individual onMessage() calls to 
	 * a given message-driven bean instance are serialized. 
	 * 
	 * <p>The <code>onMessage()</code> method is required, and must take a single parameter 
	 * of type javax.jms.Message. The throws clause (if used) must not include an application 
	 * exception. Must not be declared as final or static. 
	 *
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
	public void onMessage(javax.jms.Message message) {
		m_log.debug("Message Driven Bean got message " + message);

		if(message instanceof ObjectMessage) {
			ObjectMessage msg = (ObjectMessage)message;
			
			try {
				Object objMsg = msg.getObject();
				if(objMsg instanceof LogOutputInfo) {
					try {
						RunJob job = new RunJob((LogOutputInfo)objMsg);
						job.run();
					} catch (Throwable e) {
						//ָƽмԻ
						LogOutputInfo info = (LogOutputInfo)objMsg;
						LogOutputJobRunInfo jobRunInfo = info.getJobRun();
						//ּԻν٤
						info.setPriority(jobRunInfo.getJobFailurePriority());
						info.setMessageId("");
			            String[] args1 = { jobRunInfo.getJobId() };
			            info.setMessage(Messages.getString("message.monitor.41", args1));
						info.setMessageOrg("");
						OutputEventLog eventLog = new OutputEventLog();
						Date now = new Date();
						eventLog.setOutputDate(new Timestamp(now.getTime()));
						try {
							eventLog.insertEventLog(info, YesNoConstant.TYPE_NO);
						} catch (NamingException e1) {
						} catch (CreateException e1) {
						}
					}
				}
				else {
					m_log.debug("onMessage(): ObjectMessage is not an expected instance. " + objMsg.toString());
				}
			}
			catch(JMSException e) {
				m_log.error("onMessage():" + e.getMessage());
			}
			catch(EJBException e) {
				m_log.error("onMessage():" + e.getMessage());
			}
			catch(Exception e) {
				m_log.error("onMessage():" + e.getMessage());
			}	
		}
	}
}