/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.monitor.factory;

import java.sql.Timestamp;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;

import javax.ejb.EJBException;
import javax.ejb.FinderException;
import javax.ejb.RemoveException;
import javax.naming.NamingException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.bean.StatusExpirationConstant;
import com.clustercontrol.monitor.ejb.entity.StatusInfoLocal;
import com.clustercontrol.monitor.ejb.entity.StatusInfoUtil;
import com.clustercontrol.util.Messages;

/**
 * ơ饹
 *
 * @version 2.1.0
 * @since 2.0.0
 */
public class ManageStatus {
	
	protected static Log m_log = LogFactory.getLog( ManageStatus.class );

	/**
	 * ڤΥơ/ޤ
	 * 
	 * @throws RemoveException
	 * @throws FinderException
	 * @throws NamingException
	 */
	public void execute(){
		
		Collection ct = null;
		try 
		{
			// ͭڤΥơ
			ct = StatusInfoUtil.getLocalHome().findExpirationStatus(new Timestamp(new Date().getTime()));
			
		} catch (FinderException e) {
            m_log.error("execute():" + e.getMessage());
		} catch (NamingException e) {
            m_log.error("execute():" + e.getMessage());
		}
		
		if(ct != null){
			Timestamp now = new Timestamp(new Date().getTime());
			
			Iterator itr = ct.iterator();
			StatusInfoLocal status = null;
			while(itr.hasNext())
			{
				try{
					status = (StatusInfoLocal)itr.next();
					if(status.getExpirationFlg() != null){
						int flg = status.getExpirationFlg().intValue();
						
						// 
						if(StatusExpirationConstant.TYPE_DELETE == flg){
							status.remove();
						}
						// ƤʤݤΥåִ
						else if(StatusExpirationConstant.TYPE_CRITICAL == flg || 
								StatusExpirationConstant.TYPE_WARNING == flg ||
								StatusExpirationConstant.TYPE_INFO == flg ||
								StatusExpirationConstant.TYPE_UNKNOWN == flg){
							// åIDˤ
							status.setMessageId("");
							// ٤
							status.setPriority(new Integer(flg));
							// å˹ƤʤݤΥå
							status.setMessage(Messages.getString("monitor.status.no.update"));
							// ͭڤե饰ͭڤ
							status.setExpirationFlg(StatusExpirationConstant.TYPE_EXPIRATION);
							// 
							status.setOutputDate(now);
						}
					}
				} catch (RemoveException e) {
					m_log.error("execute():" + status == null ? "":(status.getFacilityId() + "," + status.getMonitorId() + "," + status.getPluginId() + ",") + e.getMessage());
				} catch (EJBException e) {
					m_log.error("execute():" + status == null ? "":(status.getFacilityId() + "," + status.getMonitorId() + "," + status.getPluginId() + ",") + e.getMessage());
				}
			}
		}
	}
}