/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.monitor.factory;

import java.io.IOException;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import javax.ejb.CreateException;
import javax.ejb.FinderException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.jmx.adaptor.rmi.RMIAdaptor;

import com.clustercontrol.bean.ConfirmConstant;
import com.clustercontrol.bean.FacilityTargetConstant;
import com.clustercontrol.bean.PriorityConstant;
import com.clustercontrol.bean.Property;
import com.clustercontrol.monitor.bean.EventTabelDefine;
import com.clustercontrol.monitor.ejb.entity.EventLogLocal;
import com.clustercontrol.monitor.ejb.entity.EventLogPK;
import com.clustercontrol.monitor.ejb.entity.EventLogUtil;
import com.clustercontrol.repository.ejb.session.RepositoryControllerBean;
import com.clustercontrol.repository.ejb.session.RepositoryControllerUtil;
import com.clustercontrol.util.PropertyUtil;
import com.clustercontrol.util.apllog.AplLogger;


/**
 * ٥ȳǧ򹹿륯饹Ǥ
 *
 * @version 1.0.0
 * @since 1.0.0
 */
public class ModifyEventConfirm {
	
	/** ϤΥ󥹥 */
	protected static Log m_log = LogFactory.getLog( ModifyEventConfirm.class );
	
	public static final String LOOKUP_NAME = "jmx/invoker/RMIAdaptor";
	public static final String OBJECT_NAME = "jboss.j2ee:jndiName=EventLog,service=EJB";
	public static final String OPERATION_NAME = "flushCache";
	
	/**
	 * ꤷפΥ٥ȳǧ򹹿ޤ
	 * 
	 * @param list оݤΥꥹ
	 * @param confirmType ٥ȳǧ̡ʳǧѡ̤ǧ
	 * @throws NamingException
	 * @throws FinderException
	 */
	public void modifyConfirm(List list,
			int confirmType
			) throws NamingException, FinderException  {
		
		if (list != null && list.size()>0) {
			
			// ǧѤ
			Date confirmDate = null;
			if(confirmType == ConfirmConstant.TYPE_CONFIRMED){
				confirmDate = new Date();
			}
			
			ArrayList info = null;
			for(int index=0; index<list.size(); index++){
				
				info = (ArrayList)list.get(index);
				if (info != null && info.size()>0) {
					this.modifyConfirm((String) info.get(EventTabelDefine.MONITOR_ID),
							(String) info.get(EventTabelDefine.PLUGIN_ID),
							(String) info.get(EventTabelDefine.FACILITY_ID),
							(Date) info.get(EventTabelDefine.RECEIVE_TIME),
							confirmDate,
							confirmType
							);
				}
			}
		}
	}
	
	/**
	 * ꤷפΥ٥ȳǧ򹹿ޤ
	 * 
	 * @param monitorId оݤΥ٥ID
	 * @param pluginId оݤΥץ饰ID
	 * @param facilityId оݤΥեƥID
	 * @param outputDate оݤμ
	 * @param confirmDate оݤγǧѤ
	 * @param confirmType ٥ȳǧ̡ʳǧѡ̤ǧ
	 * @throws NamingException
	 * @throws FinderException
	 */
	public void modifyConfirm(String monitorId,
			String pluginId,
			String facilityId,
			Date outputDate,
			Date confirmDate,
			int confirmType
			) throws NamingException, FinderException  {
		 
		try
		{
			// ٥ȥ
			EventLogPK pk = new EventLogPK(monitorId,
					pluginId,
					facilityId,
					new Timestamp(outputDate.getTime()));
			EventLogLocal event = EventLogUtil.getLocalHome().findByPrimaryKey(pk);
			
			// ǧ̵ͭѹ
			event.setConfirmFlg(new Integer(confirmType));
			
			if(confirmType == ConfirmConstant.TYPE_CONFIRMED){
				
				if(confirmDate == null){
					confirmDate = new Date();
				}
				event.setConfirmDate(new Timestamp(confirmDate.getTime()));	
			}
			
		} catch (FinderException e) {
            AplLogger apllog = new AplLogger("MON", "mon");
            String[] args = {facilityId, monitorId, pluginId, ConfirmConstant.typeToString(confirmType)};
            apllog.put("SYS", "004", args);
			m_log.debug("modifyConfirm():" + e.getMessage());
			throw e;
		} catch (NamingException e) {
            AplLogger apllog = new AplLogger("MON", "mon");
            String[] args = {facilityId, monitorId, pluginId, ConfirmConstant.typeToString(confirmType)};
            apllog.put("SYS", "004", args);
			m_log.debug("modifyConfirm():" + e.getMessage());
			throw e;
		}
	}
	
	/**
	 * ꤷפΥ٥ȳǧ繹ޤ
	 * 
	 * @param confirmType ٥ȳǧ̡ʳǧѡ̤ǧ
	 * @param facilityId  оݤΥեƥID
	 * @param property 
	 * @throws CreateException
	 * @throws NamingException
	 * @throws FinderException
	 * @throws NotSupportedException
	 * @throws RollbackException
	 * @throws HeuristicMixedException
	 * @throws HeuristicRollbackException
	 * @throws SystemException
	 */
	public void modifyBatchConfirm(int confirmType, String facilityId, Property property)
	throws CreateException, NamingException, FinderException, SQLException  {
		
		ArrayList values = null;
		
		Integer priority = null;
		Timestamp outputFromDate = null;
		Timestamp outputToDate = null;
		Timestamp generationFromDate = null;
		Timestamp generationToDate = null;
		String facilityType = null;
		String application = null;
		String message = null;
		
		try 
		{
			//ټ
			values = PropertyUtil.getPropertyValue(property, StatusFilterProperty.PRIORITY);
			if(!"".equals((String)values.get(0))){
				int priorityType = PriorityConstant.stringToType((String)values.get(0));
				if(priorityType != -1){
					priority = new Integer(priorityType);
				}
			}
			
			//ʼ˼			
			values = PropertyUtil.getPropertyValue(property, EventFilterProperty.OUTPUT_FROM_DATE);
			if(values.get(0) instanceof Date){
				outputFromDate = new Timestamp(((Date)values.get(0)).getTime());
				outputFromDate.setNanos(0);
			}
			
			//ʻ˼			
			values = PropertyUtil.getPropertyValue(property, EventFilterProperty.OUTPUT_TO_DATE);
			if(values.get(0) instanceof Date){
				outputToDate = new Timestamp(((Date)values.get(0)).getTime());
				outputToDate.setNanos(999999999);
			}
			
			//ʼ˼
			values = PropertyUtil.getPropertyValue(property, EventFilterProperty.GENERATION_FROM_DATE);
			if(values.get(0) instanceof Date){
				generationFromDate = new Timestamp(((Date)values.get(0)).getTime());
				generationFromDate.setNanos(0);
			}
			
			//ʻ˼
			values = PropertyUtil.getPropertyValue(property, EventFilterProperty.GENERATION_TO_DATE);
			if(values.get(0) instanceof Date){
				generationToDate = new Timestamp(((Date)values.get(0)).getTime());
				generationToDate.setNanos(999999999);
			}
			
			//оݥեƥ̼
			values = PropertyUtil.getPropertyValue(property, StatusFilterProperty.FACILITY_TYPE);
			if(!"".equals((String)values.get(0))){
				facilityType = (String)values.get(0);
			}
			
			//ץꥱ
			values = PropertyUtil.getPropertyValue(property, StatusFilterProperty.APPLICATION);
			if(!"".equals((String)values.get(0))){
				application = (String)values.get(0);
			}
			
			//å
			values = PropertyUtil.getPropertyValue(property, StatusFilterProperty.MESSAGE);
			if(!"".equals((String)values.get(0))){
				message = (String)values.get(0);
			}
			
			// оݥեƥΥեƥID
			// եƥꤵʤʺǾ̡˾ϡեƥIDꤻ˸Ԥ
			String[] facilityIds = null;
			if(facilityId != null && !"".equals(facilityId)){
				
				int level = RepositoryControllerBean.ALL;
				if(FacilityTargetConstant.STRING_BENEATH.equals(facilityType)){
					level = RepositoryControllerBean.ONE_LEVEL;
				}
	
				ArrayList facilityIdList = RepositoryControllerUtil.getLocalHome().create().getFacilityIdList(facilityId, level);
				
				// פξ
				if(facilityIdList != null && facilityIdList.size() > 0){
					facilityIds = new String[facilityIdList.size()];
					facilityIdList.toArray(facilityIds);
				}
				// Ρɤξ
				else{
					facilityIds = new String[1];
					facilityIds[0] = facilityId;
				}
			}
			
			// ȿФγǧ֤
			Integer selectConfirmFlg = null;
			if(confirmType == ConfirmConstant.TYPE_CONFIRMED){
				selectConfirmFlg = new Integer(ConfirmConstant.TYPE_UNCONFIRMED);
			}
			else if(confirmType == ConfirmConstant.TYPE_UNCONFIRMED){
				selectConfirmFlg = new Integer(ConfirmConstant.TYPE_CONFIRMED);
			}

    	    // åץǡȤե饰
			Integer confirmFlg = new Integer(confirmType);
			
   			EventLogUtil.getLocalHome().batchConfirm(
   					facilityIds,
   					priority,
   					outputFromDate,
   					outputToDate,
   					generationFromDate,
   					generationToDate,
   					application,
   					message,
   					selectConfirmFlg,
   					confirmFlg
   			);
		} catch (CreateException e) {
			this.setAplLogForBatchConfirmFailure(facilityId, priority, outputFromDate, outputToDate, generationFromDate, generationToDate, facilityType, application, message, confirmType);
			m_log.debug("modifyBatchConfirm():" + e.getMessage());
			throw e;
		} catch (FinderException e) {
			this.setAplLogForBatchConfirmFailure(facilityId, priority, outputFromDate, outputToDate, generationFromDate, generationToDate, facilityType, application, message, confirmType);
			m_log.debug("modifyBatchConfirm():" + e.getMessage());
			throw e;
		} catch (NamingException e) {
			this.setAplLogForBatchConfirmFailure(facilityId, priority, outputFromDate, outputToDate, generationFromDate, generationToDate, facilityType, application, message, confirmType);
			m_log.debug("modifyBatchConfirm():" + e.getMessage());
			throw e;
		}
		
		//Flush Entity Cache
		try{
	        InitialContext ic = new InitialContext();
	        
	        //RMIAdaptor
	        RMIAdaptor server = (RMIAdaptor) ic.lookup(LOOKUP_NAME);

	        //ObjectName
	        ObjectName name = new ObjectName(OBJECT_NAME);
	        
	        //ObjectNameOperationNameΥ᥽åɤ¹
	        server.invoke(name, OPERATION_NAME, null, null);

		} catch (NamingException e) {
			m_log.debug("modifyBatchConfirm() : " + e.getMessage());
		} catch (MalformedObjectNameException e) {
			m_log.debug("modifyBatchConfirm() : " + e.getMessage());
		} catch (NullPointerException e) {
			m_log.debug("modifyBatchConfirm() : " + e.getMessage());
		} catch (InstanceNotFoundException e) {
			m_log.debug("modifyBatchConfirm() : " + e.getMessage());
		} catch (MBeanException e) {
			m_log.debug("modifyBatchConfirm() : " + e.getMessage());
		} catch (ReflectionException e) {
			m_log.debug("modifyBatchConfirm() : " + e.getMessage());
		} catch (IOException e) {
			m_log.debug("modifyBatchConfirm() : " + e.getMessage());
		}
	}
	
	/**
	 * ץꥱˡ繹˼ԤݤΥϤޤ
	 * 
	 * @param facilityId
	 * @param priority
	 * @param outputFromDate
	 * @param outputToDate
	 * @param generationFromDate
	 * @param generationToDate
	 * @param facilityType
	 * @param application
	 * @param message
	 * @param confirmType
	 */
	private void setAplLogForBatchConfirmFailure(String facilityId, 
										Integer priority, 
										Timestamp outputFromDate, 
										Timestamp outputToDate, 
										Timestamp generationFromDate, 
										Timestamp generationToDate,
										String facilityType,
										String application,
										String message,
										int confirmType) {
		
		int priorityInt = -1;
		String outputFromDateString = null;
		String outputToDateString = null;
		String generationFromDateString = null;
		String generationToDateString = null;
		
		if(priority != null)
			priorityInt = priority.intValue();
		if(outputFromDate != null)
			outputFromDateString = outputFromDate.toString();
		if(outputToDate != null)
			outputToDateString = outputToDate.toString();
		if(generationFromDate != null)
			generationFromDateString = generationFromDate.toString();
		if(generationToDate != null)
			generationToDateString = generationToDate.toString();
		
        AplLogger apllog = new AplLogger("MON", "mon");
        String[] args = {facilityId,PriorityConstant.typeToString(priorityInt),outputFromDateString,outputToDateString,generationFromDateString,generationToDateString,facilityType,application,message,ConfirmConstant.typeToString(confirmType)};
        apllog.put("SYS", "005", args);
	}
}

