/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.monitor.factory;

import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;

import javax.ejb.CreateException;
import javax.ejb.FinderException;
import javax.naming.InitialContext;
import javax.naming.NamingException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.bean.ConfirmConstant;
import com.clustercontrol.bean.FacilityTargetConstant;
import com.clustercontrol.bean.PriorityConstant;
import com.clustercontrol.bean.Property;
import com.clustercontrol.monitor.bean.EventListInfo;
import com.clustercontrol.monitor.bean.ReportEventInfo;
import com.clustercontrol.monitor.ejb.entity.EventLogLocal;
import com.clustercontrol.monitor.ejb.entity.EventLogUtil;
import com.clustercontrol.monitor.ejb.session.MonitorControllerBean;
import com.clustercontrol.repository.ejb.session.RepositoryControllerBean;
import com.clustercontrol.repository.ejb.session.RepositoryControllerUtil;
import com.clustercontrol.util.PropertyUtil;
import com.clustercontrol.util.apllog.AplLogger;

/**
 * 󸡺饹
 * 
 * @version 2.1.0
 * @since 1.0.0
 */
public class SelectEvent {
	
	protected static Log m_log = LogFactory.getLog( SelectEvent.class );
	
	private int m_eventMaxDisplayNumber = -1;
	
	public SelectEvent(){
		try
		{
			InitialContext initialContext = new InitialContext();
			if(initialContext.lookup("java:comp/env/EventMaxDisplayNumber") instanceof Integer){
				m_eventMaxDisplayNumber = ((Integer)initialContext.lookup("java:comp/env/EventMaxDisplayNumber")).intValue();
			}
		}
		catch(NamingException e){
			m_log.error("SelectEvent():" + e.getMessage());
		}
	}
	
	/**
	 * ٥ȥ
	 * 
	 * @param facilityId
	 * @param level
	 * @return
	 * @throws CreateException
	 * @throws FinderException
	 * @throws NamingException
	 * @throws SQLException
	 */
	public EventListInfo getEventList(String facilityId, int level)
			throws CreateException, FinderException, NamingException, SQLException {

		EventListInfo list = new EventListInfo();
		try {
			String[] facilityIds = null;

			// եƥꤵʤʺǾ̡˾ϡեƥIDꤻ˸Ԥ
			if (facilityId != null && !"".equals(facilityId)) {

				if (level == MonitorControllerBean.ONLY) {
					if (facilityId != null && !"".equals(facilityId)) {
						facilityIds = new String[1];
						facilityIds[0] = facilityId;
					} else {
						return null;
					}
				} else {
					// ľ ޤ ۲٤ƤΥեƥID
					ArrayList facilityIdList = 
						RepositoryControllerUtil.getLocalHome().create().getFacilityIdList(
									facilityId, level);

					if (facilityIdList != null && facilityIdList.size() > 0) {
						// פξ
						facilityIds = new String[facilityIdList.size()];
						facilityIdList.toArray(facilityIds);
					} else {
						if(facilityId != null){
							// Ρɤξ
							facilityIds = new String[1];
							facilityIds[0] = facilityId;
						}
						else{
							// ݥȥ꤬1ϿƤʤ
							return null;
						}
					}
				}
			}
			
			Integer limit = null;
			if(m_eventMaxDisplayNumber != -1){
				limit = new Integer(m_eventMaxDisplayNumber + 1);
			}

			// ٥ȥ
			Collection ct = EventLogUtil.getLocalHome().findEvent(
					facilityIds, 
					null, 
					null, 
					null, 
					null, 
					null, 
					null, 
					null, 
					new Integer(ConfirmConstant.TYPE_UNCONFIRMED),
					false,
					limit);

			//̥٥ȿ򥫥
			if(m_eventMaxDisplayNumber == -1 || 
					ct.size() > m_eventMaxDisplayNumber){
				//ɽ礭
				int critical = EventLogUtil.getLocalHome().countEvent(
						facilityIds, 
						PriorityConstant.TYPE_CRITICAL, 
						null, 
						null, 
						null, 
						null, 
						null, 
						null, 
						new Integer(ConfirmConstant.TYPE_UNCONFIRMED));
				
				int warning = EventLogUtil.getLocalHome().countEvent(
						facilityIds, 
						PriorityConstant.TYPE_WARNING, 
						null, 
						null, 
						null, 
						null, 
						null, 
						null, 
						new Integer(ConfirmConstant.TYPE_UNCONFIRMED));
				
				int info = EventLogUtil.getLocalHome().countEvent(
						facilityIds, 
						PriorityConstant.TYPE_INFO, 
						null, 
						null, 
						null, 
						null, 
						null, 
						null, 
						new Integer(ConfirmConstant.TYPE_UNCONFIRMED));
				
				int unKnown = EventLogUtil.getLocalHome().countEvent(
						facilityIds, 
						PriorityConstant.TYPE_UNKNOWN, 
						null, 
						null, 
						null, 
						null, 
						null, 
						null, 
						new Integer(ConfirmConstant.TYPE_UNCONFIRMED));
				
				int total = critical + warning + info + unKnown;
				
				list.setCritical(critical);
				list.setWarning(warning);
				list.setInfo(info);
				list.setUnKnown(unKnown);
				list.setTotal(total);
			}
			
			// 2Ѵ
			this.collectionToEventList(ct, list);

		} catch (CreateException e) {
			outputLog(e, "getEventList()", facilityId, null, null, null, null, null, null, null, null, null);
			throw e;
		} catch (FinderException e) {
			outputLog(e, "getEventList()", facilityId, null, null, null, null, null, null, null, null, null);
			throw e;
		} catch (NamingException e) {
			outputLog(e, "getEventList()", facilityId, null, null, null, null, null, null, null, null, null);
			throw e;
		}
		
		return list;
	}

	/**
	 * ٥ȥ
	 * 
	 * @param facilityId
	 * @param property
	 * @return
	 * @throws CreateException
	 * @throws FinderException
	 * @throws NamingException
	 * @throws SQLException
	 */
	public EventListInfo getEventList(String facilityId, Property property)
			throws CreateException, FinderException, NamingException, SQLException {

		EventListInfo list = new EventListInfo();
		
		Integer priority = null;
		Timestamp outputFromDate = null;
		Timestamp outputToDate = null;
		Timestamp generationFromDate = null;
		Timestamp generationToDate = null;
		String facilityType = null;
		String application = null;
		String message = null;
		Integer confirmFlg = null;
		
		try {
			ArrayList values = null;

			//ټ
			values = PropertyUtil.getPropertyValue(property,
					StatusFilterProperty.PRIORITY);
			if (!"".equals((String) values.get(0))) {
				int priorityType = PriorityConstant
						.stringToType((String) values.get(0));
				if (priorityType != -1) {
					priority = new Integer(priorityType);
				}
			}

			//ʼ˼
			values = PropertyUtil.getPropertyValue(property,
					EventFilterProperty.OUTPUT_FROM_DATE);
			if (values.get(0) instanceof Date) {
				outputFromDate = new Timestamp(((Date) values.get(0)).getTime());
				outputFromDate.setNanos(0);
			}

			//ʻ˼
			values = PropertyUtil.getPropertyValue(property,
					EventFilterProperty.OUTPUT_TO_DATE);
			if (values.get(0) instanceof Date) {
				outputToDate = new Timestamp(((Date) values.get(0)).getTime());
				outputToDate.setNanos(999999999);
			}

			//ʼ˼
			values = PropertyUtil.getPropertyValue(property,
					EventFilterProperty.GENERATION_FROM_DATE);
			if (values.get(0) instanceof Date) {
				generationFromDate = new Timestamp(((Date) values.get(0))
						.getTime());
				generationFromDate.setNanos(0);
			}

			//ʻ˼
			values = PropertyUtil.getPropertyValue(property,
					EventFilterProperty.GENERATION_TO_DATE);
			if (values.get(0) instanceof Date) {
				generationToDate = new Timestamp(((Date) values.get(0))
						.getTime());
				generationToDate.setNanos(999999999);
			}

			//оݥեƥ̼
			values = PropertyUtil.getPropertyValue(property,
					StatusFilterProperty.FACILITY_TYPE);
			if (!"".equals((String) values.get(0))) {
				facilityType = (String) values.get(0);
			}

			//ץꥱ
			values = PropertyUtil.getPropertyValue(property,
					StatusFilterProperty.APPLICATION);
			if (!"".equals((String) values.get(0))) {
				application = (String) values.get(0);
			}

			//å
			values = PropertyUtil.getPropertyValue(property,
					StatusFilterProperty.MESSAGE);
			if (!"".equals((String) values.get(0))) {
				message = (String) values.get(0);
			}

			// ǧ̵ͭ
			values = PropertyUtil.getPropertyValue(property,
					EventFilterProperty.CONFIRMED);
			int confirmFlgType = ConfirmConstant.stringToType((String) values
					.get(0));
			if (confirmFlgType != -1) {
				confirmFlg = new Integer(confirmFlgType);
			}

			// оݥեƥΥեƥID
			// եƥꤵʤʺǾ̡˾ϡեƥIDꤻ˸Ԥ
			String[] facilityIds = null;
			if (facilityId != null && !"".equals(facilityId)) {

				int level = RepositoryControllerBean.ALL;
				if (FacilityTargetConstant.STRING_BENEATH.equals(facilityType)) {
					level = RepositoryControllerBean.ONE_LEVEL;
				}

				ArrayList facilityIdList = RepositoryControllerUtil
						.getLocalHome().create().getFacilityIdList(facilityId,
								level);

				if (facilityIdList != null && facilityIdList.size() > 0) {
					// פξ
					facilityIds = new String[facilityIdList.size()];
					facilityIdList.toArray(facilityIds);
				}
				else {
					if(facilityId != null){
						// Ρɤξ
						facilityIds = new String[1];
						facilityIds[0] = facilityId;
					}
					else{
						// ݥȥ꤬1ϿƤʤ
						return null;
					}
				}
			}

			Integer limit = null;
			if(m_eventMaxDisplayNumber != -1){
				limit = new Integer(m_eventMaxDisplayNumber + 1);
			}
			
			// ٥ȥ
			Collection ct = EventLogUtil.getLocalHome().findEvent(facilityIds, 
					priority, 
					outputFromDate, 
					outputToDate,
					generationFromDate, 
					generationToDate, 
					application, 
					message,
					confirmFlg,
					false,
					limit);
			
			//̥٥ȿ򥫥
			if(m_eventMaxDisplayNumber == -1 || 
					ct.size() > m_eventMaxDisplayNumber){
				//ɽ礭
				int critical = EventLogUtil.getLocalHome().countEvent(
						facilityIds, 
						PriorityConstant.TYPE_CRITICAL, 
						outputFromDate, 
						outputToDate,
						generationFromDate, 
						generationToDate, 
						application, 
						message,
						confirmFlg);
				
				int warning = EventLogUtil.getLocalHome().countEvent(
						facilityIds, 
						PriorityConstant.TYPE_WARNING, 
						outputFromDate, 
						outputToDate,
						generationFromDate, 
						generationToDate, 
						application, 
						message,
						confirmFlg);
				
				int info = EventLogUtil.getLocalHome().countEvent(
						facilityIds, 
						PriorityConstant.TYPE_INFO, 
						outputFromDate, 
						outputToDate,
						generationFromDate, 
						generationToDate, 
						application, 
						message,
						confirmFlg);
				
				int unKnown = EventLogUtil.getLocalHome().countEvent(
						facilityIds, 
						PriorityConstant.TYPE_UNKNOWN, 
						outputFromDate, 
						outputToDate,
						generationFromDate, 
						generationToDate, 
						application, 
						message,
						confirmFlg);
				
				int total = critical + warning + info + unKnown;
				
				list.setCritical(critical);
				list.setWarning(warning);
				list.setInfo(info);
				list.setUnKnown(unKnown);
				list.setTotal(total);
			}

			// 2Ѵ
			this.collectionToEventList(ct, list);

		} catch (CreateException e) {
			outputLog(e, "getEventList()", facilityId, priority, outputFromDate, outputToDate, generationFromDate, generationToDate, facilityType, application, message, confirmFlg);
			throw e;
		} catch (FinderException e) {
			outputLog(e, "getEventList()", facilityId, priority, outputFromDate, outputToDate, generationFromDate, generationToDate, facilityType, application, message, confirmFlg);
			throw e;
		} catch (NamingException e) {
			outputLog(e, "getEventList()", facilityId, priority, outputFromDate, outputToDate, generationFromDate, generationToDate, facilityType, application, message, confirmFlg);
			throw e;
		}
		
		return list;
	}

	/**
	 * ٥ȥ
	 * 
	 * @param facilityId
	 * @return EventLog
	 * @throws CreateException
	 * @throws FinderException
	 * @throws NamingException
	 */
	public EventLogLocal getHighPriorityEvent(String facilityId, int level)
			throws CreateException, FinderException, NamingException {

		EventLogLocal event = null;
		try {
			String[] facilityIds = null;
			if (level == MonitorControllerBean.ONLY) {
				if (facilityId != null && !"".equals(facilityId)) {
					facilityIds = new String[1];
					facilityIds[0] = facilityId;
				} else {
					return null;
				}
			} else {
				// ľ ޤ ۲٤ƤΥեƥID
				ArrayList facilityIdList = RepositoryControllerUtil
						.getLocalHome().create().getFacilityIdList(facilityId,
								level);

				if (facilityIdList != null && facilityIdList.size() > 0) {
					// פξ
					facilityIds = new String[facilityIdList.size()];
					facilityIdList.toArray(facilityIds);
				} else {
					if(facilityId != null){
						// Ρɤξ
						facilityIds = new String[1];
						facilityIds[0] = facilityId;
					}
					else{
						// ݥȥ꤬1ϿƤʤ
						return null;
					}
				}
			}

			// ٥ȥ
			Collection ct = EventLogUtil.getLocalHome().findHighPriorityEvent(facilityIds, 
					null, 
					null, 
					null, 
					null, 
					null, 
					null, 
					null, 
					new Integer(ConfirmConstant.TYPE_UNCONFIRMED));

			Iterator itr = ct.iterator();
			if (itr.hasNext()) {
				event = (EventLogLocal) itr.next();
			}

		} catch (CreateException e) {
			m_log.debug("getHighPriorityEvent():" + e.getMessage());
			throw e;
		} catch (FinderException e) {
			m_log.debug("getHighPriorityEvent():" + e.getMessage());
			throw e;
		} catch (NamingException e) {
			m_log.debug("getHighPriorityEvent():" + e.getMessage());
			throw e;
		}
		return event;
	}
	
	/**
	 * Ģɼѥ٥ȥ
	 * 
	 * @param facilityId
	 * @return Object2
	 * @throws CreateException
	 * @throws FinderException
	 * @throws NamingException
	 * 
	 * @version 2.1.0
	 * @since 2.1.0
	 */
	public ArrayList getEventListForReport(String facilityId, Property property)
			throws CreateException, FinderException, NamingException, IndexOutOfBoundsException {

		ArrayList list = null;
		
		Integer priority = null;
		Timestamp outputFromDate = null;
		Timestamp outputToDate = null;
		Timestamp generationFromDate = null;
		Timestamp generationToDate = null;
		String facilityType = null;
		String application = null;
		String message = null;
		Integer confirmFlg = null;
		
		try {
			ArrayList values = null;

			//ټ
			values = PropertyUtil.getPropertyValue(property,
					StatusFilterProperty.PRIORITY);
			if (!"".equals((String) values.get(0))) {
				int priorityType = PriorityConstant
						.stringToType((String) values.get(0));
				if (priorityType != -1) {
					priority = new Integer(priorityType);
				}
			}

			//ʼ˼
			values = PropertyUtil.getPropertyValue(property,
					EventFilterProperty.OUTPUT_FROM_DATE);
			if (values.get(0) instanceof Date) {
				outputFromDate = new Timestamp(((Date) values.get(0)).getTime());
				outputFromDate.setNanos(0);
			}

			//ʻ˼
			values = PropertyUtil.getPropertyValue(property,
					EventFilterProperty.OUTPUT_TO_DATE);
			if (values.get(0) instanceof Date) {
				outputToDate = new Timestamp(((Date) values.get(0)).getTime());
				outputToDate.setNanos(999999999);
			}

			//ʼ˼
			values = PropertyUtil.getPropertyValue(property,
					EventFilterProperty.GENERATION_FROM_DATE);
			if (values.get(0) instanceof Date) {
				generationFromDate = new Timestamp(((Date) values.get(0))
						.getTime());
				generationFromDate.setNanos(0);
			}

			//ʻ˼
			values = PropertyUtil.getPropertyValue(property,
					EventFilterProperty.GENERATION_TO_DATE);
			if (values.get(0) instanceof Date) {
				generationToDate = new Timestamp(((Date) values.get(0))
						.getTime());
				generationToDate.setNanos(999999999);
			}

			//оݥեƥ̼
			values = PropertyUtil.getPropertyValue(property,
					StatusFilterProperty.FACILITY_TYPE);
			if (!"".equals((String) values.get(0))) {
				facilityType = (String) values.get(0);
			}

			//ץꥱ
			values = PropertyUtil.getPropertyValue(property,
					StatusFilterProperty.APPLICATION);
			if (!"".equals((String) values.get(0))) {
				application = (String) values.get(0);
			}

			//å
			values = PropertyUtil.getPropertyValue(property,
					StatusFilterProperty.MESSAGE);
			if (!"".equals((String) values.get(0))) {
				message = (String) values.get(0);
			}

			// ǧ̵ͭ
			values = PropertyUtil.getPropertyValue(property,
					EventFilterProperty.CONFIRMED);
			int confirmFlgType = ConfirmConstant.stringToType((String) values
					.get(0));
			if (confirmFlgType != -1) {
				confirmFlg = new Integer(confirmFlgType);
			}

			// оݥեƥΥեƥID
			// եƥꤵʤʺǾ̡˾ϡեƥIDꤻ˸Ԥ
			String[] facilityIds = null;
			if (facilityId != null && !"".equals(facilityId)) {

				int level = RepositoryControllerBean.ALL;
				if (FacilityTargetConstant.STRING_BENEATH.equals(facilityType)) {
					level = RepositoryControllerBean.ONE_LEVEL;
				}

				ArrayList facilityIdList = RepositoryControllerUtil
						.getLocalHome().create().getFacilityIdList(facilityId,
								level);

				if (facilityIdList != null && facilityIdList.size() > 0) {
					// פξ
					facilityIds = new String[facilityIdList.size()];
					facilityIdList.toArray(facilityIds);
				}
				else {
					if(facilityId != null){
						// Ρɤξ
						facilityIds = new String[1];
						facilityIds[0] = facilityId;
					}
					else{
						// ݥȥ꤬1ϿƤʤ
						return null;
					}
				}
			}

			// ٥ȥ
			Collection ct = EventLogUtil.getLocalHome().findEvent(facilityIds, 
					priority, 
					outputFromDate, 
					outputToDate,
					generationFromDate, 
					generationToDate, 
					application, 
					message,
					confirmFlg,
					true,
					null);
			
//			// ٥Ȥɽ礭硢顼ȯ
//			if(m_eventMaxDisplayNumber != -1 && ct.size() > m_eventMaxDisplayNumber){
//				throw new java.lang.IndexOutOfBoundsException();
//			}

			// ĢɼѤѴ
			list = this.collectionToArrayForReportd(ct);

		} catch (CreateException e) {
			outputLog(e, "getEventListForReport()", facilityId, priority, outputFromDate, outputToDate, generationFromDate, generationToDate, facilityType, application, message, confirmFlg);
			throw e;
		} catch (FinderException e) {
			outputLog(e, "getEventListForReport()", facilityId, priority, outputFromDate, outputToDate, generationFromDate, generationToDate, facilityType, application, message, confirmFlg);
			throw e;
		} catch (NamingException e) {
			outputLog(e, "getEventListForReport()", facilityId, priority, outputFromDate, outputToDate, generationFromDate, generationToDate, facilityType, application, message, confirmFlg);
			throw e;
		}
		return list;
	}

	/**
	 * ٥ȥObject2˳Ǽ
	 * ٥Ȱ󥯥饹˳Ǽ
	 * 
	 * @param ct
	 * @return Object2
	 */
	@SuppressWarnings("unchecked")
	private void collectionToEventList(Collection ct, EventListInfo eventList) {
		int critical = 0;
	    int warning = 0;
	    int info = 0;
	    int unKnown = 0;
	    int total = ct.size();
		
		ArrayList list = new ArrayList();
		Iterator itr = ct.iterator();
		while (itr.hasNext()) {
			EventLogLocal event = (EventLogLocal) itr.next();

			ArrayList eventInfo = new ArrayList();
			eventInfo.add(event.getPriority());
			eventInfo.add(new Date(event.getOutputDate().getTime()));
			eventInfo.add(new Date(event.getGenerationDate().getTime()));
			eventInfo.add(event.getPluginId());
			eventInfo.add(event.getMonitorId());
			eventInfo.add(event.getFacilityId());
			eventInfo.add(event.getScopeText());
			eventInfo.add(event.getApplication());
			eventInfo.add(event.getMessageId());
			eventInfo.add(event.getMessage());
			eventInfo.add(event.getConfirmFlg());
			list.add(eventInfo);

			if(m_eventMaxDisplayNumber != -1){
				//̥٥ȿ򥫥
				if(ct.size() <= m_eventMaxDisplayNumber){
					//ɽʲξ

					if(event.getPriority().intValue() == PriorityConstant.TYPE_CRITICAL)
						critical++;
					else if(event.getPriority().intValue() == PriorityConstant.TYPE_WARNING)
						warning++;
					else if(event.getPriority().intValue() == PriorityConstant.TYPE_INFO)
						info++;
					else if(event.getPriority().intValue() == PriorityConstant.TYPE_UNKNOWN)
						unKnown++;
				}
				
				//٥ȤɽޤǳǼ齪λ
				if(list.size() >= m_eventMaxDisplayNumber)
					break;
			}
		}
		
		//٥ȿ
		if(m_eventMaxDisplayNumber != -1){
			if(ct.size() <= m_eventMaxDisplayNumber){
				eventList.setCritical(critical);
				eventList.setWarning(warning);
				eventList.setInfo(info);
				eventList.setUnKnown(unKnown);
				eventList.setTotal(total);
			}
		}
		eventList.setEventList(list);
	}
	
	/**
	 * Ģɼѥ٥ȥ˳Ǽ
	 * 
	 * @param ct
	 * @return Ģɼѥ٥ȥ
	 * 
	 * @version 2.1.0
	 * @since 2.1.0
	 */
	private ArrayList<ReportEventInfo> collectionToArrayForReportd(Collection ct) {

		ArrayList<ReportEventInfo> list = new ArrayList<ReportEventInfo>();
		Iterator itr = ct.iterator();
		while (itr.hasNext()) {
			EventLogLocal event = (EventLogLocal) itr.next();

			ReportEventInfo info = new ReportEventInfo();
			
			info.setApplication(event.getApplication());
			info.setConfirmFlg(event.getConfirmFlg().intValue());
			info.setFacilityId(event.getFacilityId());
			info.setGenerationDate(new Date(event.getGenerationDate().getTime()));
			info.setMessage(event.getMessage());
			info.setMessageId(event.getMessageId());
			info.setMessageOrg(event.getMessageOrg());
			info.setMonitorId(event.getMonitorId());
			info.setOutputDate(new Date(event.getOutputDate().getTime()));
			info.setPluginId(event.getPluginId());
			info.setPriority(event.getPriority().intValue());
			info.setScopeText(event.getScopeText());
			
			list.add(info);
		}
		return list;
	}
	
	/**
     * ץꥱ˥
     * 
     * @param e 㳰
     */
	private void outputLog(
			Exception e, 
			String method,
			String facilityId,
			Integer priority,
			Timestamp outputFromDate,
			Timestamp outputToDate,
			Timestamp generationFromDate,
			Timestamp generationToDate,
			String facilityType,
			String application,
			String message,
			Integer confirmFlg){
		
		int priorityInt = -1;
		String outputFromDateString = null;
		String outputToDateString = null;
		String generationFromDateString = null;
		String generationToDateString = null;
		int confirmFlgInt = -1;
		
		if(priority != null)
			priorityInt = priority.intValue();
		if(outputFromDate != null)
			outputFromDateString = outputFromDate.toString();
		if(outputToDate != null)
			outputToDateString = outputToDate.toString();
		if(generationFromDate != null)
			generationFromDateString = generationFromDate.toString();
		if(generationToDate != null)
			generationToDateString = generationToDate.toString();
		if(confirmFlg != null)
			confirmFlgInt = confirmFlg.intValue();
		
        AplLogger apllog = new AplLogger("MON", "mon");
        String[] args = {facilityId,PriorityConstant.typeToString(priorityInt),outputFromDateString,outputToDateString,generationFromDateString,generationToDateString,facilityType,application,message,ConfirmConstant.typeToString(confirmFlgInt)};
        apllog.put("SYS", "003", args);
		m_log.debug(method + ":" + e.getMessage());
	}
}
