/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.monitor.factory;

import java.util.ArrayList;
import java.util.Date;

import javax.ejb.CreateException;
import javax.ejb.FinderException;
import javax.naming.NamingException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.bean.PriorityConstant;
import com.clustercontrol.monitor.ejb.entity.EventLogLocal;
import com.clustercontrol.monitor.ejb.entity.StatusInfoLocal;
import com.clustercontrol.monitor.ejb.session.MonitorControllerBean;
import com.clustercontrol.repository.ejb.session.RepositoryControllerLocal;
import com.clustercontrol.repository.ejb.session.RepositoryControllerUtil;
import com.clustercontrol.util.apllog.AplLogger;

/**
 * 󸡺饹
 *
 * @version 1.0.0
 * @since 1.0.0
 */
public class SelectScope {
	
	public static final int PRIORITY = 0;
	public static final int FACILITY_ID = 1;
	public static final int FACILITY_PATH = 2;
	public static final int OUTPUT_DATE = 3;
	
	protected static Log m_log = LogFactory.getLog( SelectScope.class );
	
	/**
	 * װ
	 * 
	 * @param facilityId
	 * @return Object2
	 * @throws CreateException
	 * @throws FinderException
	 * @throws NamingException
	 */
	public ArrayList getScopeList(String facilityId) throws CreateException, FinderException, NamingException {

		ArrayList list = new ArrayList();
		
		SelectStatus selectStatus = new SelectStatus();
		SelectEvent selectEvent = new SelectEvent();
		
		int parentPriority = PriorityConstant.TYPE_NONE;
		String parentFacilityId = null;
		String parentFacilityPath = null;
		Date parentOutputDate = null;

		try 
		{
			RepositoryControllerLocal repository = RepositoryControllerUtil.getLocalHome().create();
			
			// ꤷեƥν٤ֹ⤤
			if(facilityId != null && !"".equals(facilityId)){
				// ٤ֹ⤤ơ
				StatusInfoLocal status = selectStatus.getHighPriorityStatus(facilityId, MonitorControllerBean.ONLY);
				// ٤ֹ⤤٥ȥ
				EventLogLocal event = selectEvent.getHighPriorityEvent(facilityId, MonitorControllerBean.ONLY);
				
				// ٤ֹ⤤ꤹ
				ArrayList info = this.getHighPriorityScope(status, event, repository, facilityId, facilityId);
				
				if(info != null){
					parentPriority = ((Integer)info.get(PRIORITY)).intValue();
					parentFacilityId = (String)info.get(FACILITY_ID);
					parentFacilityPath = (String)info.get(FACILITY_PATH);
					parentOutputDate = (Date)info.get(OUTPUT_DATE);
				}
			}
			
			// ľΥեƥID
			ArrayList facilityIdList = repository.getFacilityIdList(facilityId, MonitorControllerBean.ONE_LEVEL);
			
			String[] facilityIds = null;
			if(facilityIdList != null && facilityIdList.size() > 0){
				// פξ
				facilityIds = new String[facilityIdList.size()];
				facilityIdList.toArray(facilityIds);
			}
			else{
				if(facilityId != null){
					// Ρɤξ
					facilityIds = new String[1];
					facilityIds[0] = facilityId;
				}
				else{
					// ݥȥ꤬1ϿƤʤ
					return null;
				}
			}
			
			// ľΥեƥID°۲ƤΥեƥIDꡢơ٤ֹ⤤
			boolean statusInfoFlg = false;
			boolean eventLogFlg = false;
			boolean highPriorityFlg = false;
			for(int index=0; ((facilityIds!=null) && (index<facilityIds.length)); index++){
				
				// ľΥեƥξ
				if(!facilityIds[index].equals(facilityId)){
					
					// ٤ֹ⤤ơ
					StatusInfoLocal status = selectStatus.getHighPriorityStatus(facilityIds[index], MonitorControllerBean.ALL);
					// ٤ֹ⤤٥ȥ
					EventLogLocal event = selectEvent.getHighPriorityEvent(facilityIds[index], MonitorControllerBean.ALL);
					
					// ٤ֹ⤤ꤹ
					ArrayList info = this.getHighPriorityScope(status, event, repository, facilityIds[index], facilityId);
					if(info != null){
						
						list.add(info);
						
						// Ǿ̤Υեƥξꤹ
						if(parentPriority > ((Integer)info.get(PRIORITY)).intValue()){
							highPriorityFlg = true;
						}
						else if(parentPriority == ((Integer)info.get(PRIORITY)).intValue()){
							if(parentOutputDate != null){
								if(parentOutputDate.before((Date)info.get(OUTPUT_DATE))){
									highPriorityFlg = true;
								}
							}
							else{
								highPriorityFlg = true;
							}
						}
						
						if(highPriorityFlg){
							parentPriority = ((Integer)info.get(PRIORITY)).intValue();
							parentOutputDate = (Date)info.get(OUTPUT_DATE);
							
							if(parentFacilityId == null){
								if(facilityId != null && !"".equals(facilityId)){
									parentFacilityId = facilityId;
									parentFacilityPath = repository.getFacilityPath(facilityId, facilityId);	
								}
							}
						}
					}
				}
				statusInfoFlg = false;
				eventLogFlg = false;
				highPriorityFlg = false;
			}
			
			if(parentFacilityId != null){
				// Ǿ̤Υեƥξꤹ
				ArrayList info = new ArrayList();
				info.add(new Integer(parentPriority));
				info.add(parentFacilityId);
				info.add(parentFacilityPath);
				info.add(parentOutputDate);
				list.add(info);
			}
			
		} catch (CreateException e) {
            AplLogger apllog = new AplLogger("MON", "mon");
            String[] args = {facilityId};
            apllog.put("SYS", "001", args);
			m_log.debug("getScopeList():" + e.getMessage());
			throw e;
		} catch (FinderException e) {
            AplLogger apllog = new AplLogger("MON", "mon");
            String[] args = {facilityId};
            apllog.put("SYS", "001", args);
			m_log.debug("getScopeList():" + e.getMessage());
			throw e;
		} catch (NamingException e) {
            AplLogger apllog = new AplLogger("MON", "mon");
            String[] args = {facilityId};
            apllog.put("SYS", "001", args);
			m_log.debug("getScopeList():" + e.getMessage());
			throw e;
		}
		return list;
	}
	
	/**
	 * ơObject2˳Ǽ
	 * 
	 * @param status
	 * @param event
	 * @param repository
	 * @param parentFacilityId
	 * @return Object1
	 */
	private ArrayList getHighPriorityScope(StatusInfoLocal status, 
			EventLogLocal event, 
			RepositoryControllerLocal repository,
			String facilityId,
			String parentFacilityId) throws CreateException, FinderException, NamingException{
		
		ArrayList info = new ArrayList();
		
		boolean statusInfoFlg = false;
		boolean eventLogFlg = false;
		
		// ٤ֹ⤤ꤹ
		if(status == null && event == null){
			return null;
		}
		else if(status != null && event == null){
			statusInfoFlg = true;
		}
		else if(status == null && event != null){
			eventLogFlg = true;
		}
		else if(status != null && event != null){
			if((status.getPriority()).intValue() < (event.getPriority()).intValue()){
				statusInfoFlg = true;
			}
			else if((status.getPriority()).intValue() > (event.getPriority()).intValue()){
				eventLogFlg = true;
			}
			else if((status.getPriority()).intValue() == (event.getPriority()).intValue()){
				
				// ٤硢Ϻǿξꤹ
				if((status.getOutputDate()).after(event.getOutputDate())){
					statusInfoFlg = true;
				}
				else{
					eventLogFlg = true;
				}
			}
		}
		
		String facilityPath = repository.getFacilityPath(facilityId, parentFacilityId);
		if(statusInfoFlg){
			info.add(status.getPriority());
			info.add(facilityId);
			info.add(facilityPath);
			info.add(new Date(status.getOutputDate().getTime()));
		}
		else if(eventLogFlg){
			info.add(event.getPriority());
			info.add(facilityId);
			info.add(facilityPath);
			info.add(new Date(event.getOutputDate().getTime()));
		}
		return info;
	}
}
