/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.monitor.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.UnsupportedEncodingException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.Properties;
import java.util.Vector;

import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeUtility;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;

import com.clustercontrol.bean.PriorityConstant;
import com.clustercontrol.monitor.message.LogOutputInfo;
import com.clustercontrol.util.Messages;

/**
 * ᡼륯饹Ǥ
 *
 * @version 1.0.0
 * @since 1.0.0
 */
public class SendMail {
	
	 private static final String SUBJECT_DATE_FORMAT = "MM/dd HH:mm";
	
	 static private String FROM_ADDRESS = null;
	 static private String FROM_PERSONAL_NAME = null;
	 static private String REPLY_TO_ADDRESS = null;
	 static private String REPLY_TO_PERSONAL_NAME = null;
	 static private String ERRORS_TO_ADDRESS = null;
	 
	 private Locale m_local =Locale.getDefault();
	
	 static{
	     
	 
	 	/**
	 	 * ³ץѥƥե뤫
	 	 * 
	 	 */
 	    Properties properties = new Properties();
 		
 		try {
 			String homedir = System.getProperty("jboss.server.home.dir");
 			String propertyFile = homedir + File.separator + "conf" + File.separator + "mail.properties";
 			
 			// ץѥƥե뤫饭ͤΥꥹȤɤ߹ߤޤ
 			properties.load(new FileInputStream(propertyFile));
 			
 			FROM_ADDRESS = properties.getProperty("from.address");
 			FROM_PERSONAL_NAME = properties.getProperty("from.personal.name");
 			REPLY_TO_ADDRESS = properties.getProperty("reply.to.address");
 			REPLY_TO_PERSONAL_NAME = properties.getProperty("reply.personal.name");
 			ERRORS_TO_ADDRESS = properties.getProperty("errors.to.address");
 			
 		} catch (Exception e) {
 		}
 
	 
	 }
	 
	/**
	 * ᡼
	 * 
	 * @return
	 */
	public boolean sendMail(String[] address, LogOutputInfo source, Date timeStamp){
		
		if(address == null || address.length<=0)
		{
			return false;
		}
		
		Context initialContext = null;
		
		try
		{
			initialContext = new InitialContext();

			// JavaMail Session꥽
			Session session=(Session)initialContext.lookup("java:/Mail");
			
			Message mes = new MimeMessage(session);
			
			
            // ᡼륢ɥ쥹̾
            if(FROM_ADDRESS != null && FROM_PERSONAL_NAME != null){
                mes.setFrom(new InternetAddress(FROM_ADDRESS, FROM_PERSONAL_NAME,"iso-2022-jp"));
            }else if(FROM_ADDRESS != null && FROM_PERSONAL_NAME == null){
                mes.setFrom(new InternetAddress(FROM_ADDRESS));
            }
            // REPLY-TO
            if(REPLY_TO_ADDRESS != null && REPLY_TO_PERSONAL_NAME != null){
		        InternetAddress reply[] = {new InternetAddress(REPLY_TO_ADDRESS,REPLY_TO_PERSONAL_NAME,"iso-2022-jp")};
		        mes.setReplyTo(reply);
		        mes.reply(true);
            }else if(REPLY_TO_ADDRESS != null && REPLY_TO_PERSONAL_NAME == null){
		        InternetAddress reply[] = {new InternetAddress(REPLY_TO_ADDRESS)};
		        mes.setReplyTo(reply);
		        mes.reply(true);
            }


            // ERRORS-TO
            if(ERRORS_TO_ADDRESS != null ){
                mes.setHeader("Errors-To", ERRORS_TO_ADDRESS);
            }

			// ᡼륢ɥ쥹
            InternetAddress[] toAddress = this.getAddress(address);
            if(toAddress == null || toAddress.length<=0)
            {
            	return false;
            }
			mes.setRecipients(javax.mail.Message.RecipientType.TO, toAddress);
			
			// ᡼η̾
			mes.setSubject(MimeUtility.encodeText(this.getSubject(source),"iso-2022-jp","B"));
			
			// ᡼Ƥ
			mes.setContent(this.getText(source), "text/plain; charset=iso-2022-jp");
			
			// դ
			mes.setSentDate(this.getSentDate(timeStamp));
			
			// ᡼
			Transport.send(mes);
			return true;
		}
		catch (NamingException ne)
		{
		}
		catch(MessagingException me)
		{
		}
		catch(UnsupportedEncodingException uee)
		{
		}
		return false;
	}
	
	  
	
	/**
	 * @return ᡼륢ɥ쥹ᤷޤ
	 */
	private InternetAddress[] getAddress(String[] address) {
		
		InternetAddress toAddress[] = null;
		Vector list = new Vector();
		
		if(address != null)
		{
			
            for (int index=0; index<address.length; index++) 
            {
            	try
				{
            		list.add(new InternetAddress(address[index]));
				}
            	catch(AddressException ae)
				{
				}
            }
            
            if(list.size() > 0)
            {
            	toAddress = new InternetAddress[list.size()];
                list.copyInto(toAddress);	
            }
		}
		return toAddress;
	}
	
	/**
	 * @return ᡼̾ᤷޤ
	 */
	private String getSubject(LogOutputInfo source) {
		
		String subject = null;
		
		if(source instanceof LogOutputInfo)
		{
			subject = Messages.getString("mail.subject", m_local) + "(" + PriorityConstant.typeToString(((LogOutputInfo)source).getPriority()) + ")";
		}
		return subject;
	}
	
	/**
	 * @return ᡼ʸᤷޤ
	 */
	private String getText(LogOutputInfo source) {
		
		StringBuffer buf = new StringBuffer();
		SimpleDateFormat sdf = new SimpleDateFormat(SUBJECT_DATE_FORMAT);
		
		LogOutputInfo message = (LogOutputInfo)source;
		buf.append(Messages.getString("generation.time",m_local) + " : " +  sdf.format(message.getGenerationDate()) + "\n");
		buf.append(Messages.getString("application",m_local) + " : " +  message.getApplication() + "\n");
		buf.append(Messages.getString("priority",m_local) + " : " +  PriorityConstant.typeToString(message.getPriority()) + "\n");
		buf.append(Messages.getString("message",m_local) + " : " +  message.getMessage() + "\n");
		buf.append(Messages.getString("scope",m_local) + " : " +  message.getScopeText() + "\n");
		return buf.toString();
	}
	
	/**
	 * @return դᤷޤ
	 */
	private Date getSentDate(Date timeStamp) {
		
		if(timeStamp == null)
		{
			timeStamp = new Date();	
		}
		return timeStamp;
	}
	
	
}
