/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.monitor.util;

import java.io.Serializable;
import java.util.Properties;

import javax.jms.JMSException;
import javax.jms.ObjectMessage;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.QueueSender;
import javax.jms.QueueSession;
import javax.jms.Session;
import javax.naming.InitialContext;
import javax.naming.NamingException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/**
 * Queue饹
 *
 * @version 2.1.0
 * @since 1.0.0
 */
public class SendQueue {
	
	protected static Log m_log = LogFactory.getLog( SendQueue.class );
	
    protected String m_queueName;
    protected QueueConnectionFactory m_connectionFactory;
    protected QueueConnection m_connection;
    protected Queue m_queue;
    protected QueueSession m_session;
    
    /**
     * 󥹥ȥ饯
     * 
     * @param queueName
     * @throws NamingException
     * @throws JMSException
     */
    public SendQueue(String queueName) throws NamingException, JMSException{
        m_queueName = queueName;
        this.initial();
    }
    
    /**
     * å
     * 
     * @param orgMessage
     * @throws JMSException
     */
    public void put(Serializable orgMessage) throws JMSException{
    	
    	QueueSender sender = null;
		try {
	    	// 塼
	        sender = m_session.createSender(m_queue);
	        
	        // å
	        ObjectMessage message = m_session.createObjectMessage(orgMessage);
	        
	        // å
	        sender.send(message);
		}
		catch (JMSException e) {
    		m_log.error("put:" + e.getMessage());
    		
    		this.terminate();
			throw e;
		}
		finally{
			try {
				if(sender != null)
					sender.close();
			}
			catch (JMSException e) {
			}
		}
    }
    
    /**
     * å
     * 
     * @throws JMSException
     * @throws NamingException
     */
    public void initial() throws NamingException, JMSException {
    	
    	try{
            //Queueν
    		InitialContext context = null;
    		String serverName = System.getProperty("jboss.server.name");
    		if(serverName.equals("all")){
    			Properties properties = new Properties(); 
    			properties.put(InitialContext.INITIAL_CONTEXT_FACTORY,"org.jnp.interfaces.NamingContextFactory");
    			properties.put(InitialContext.URL_PKG_PREFIXES,"org.jboss.naming:org.jnp.interfaces");
    			properties.put(InitialContext.PROVIDER_URL,"jnp://localhost:1100");
    			
    			context = new InitialContext(properties);
    		}
    		else{
    			context = new InitialContext();
    		}
            m_connectionFactory = (QueueConnectionFactory)context.lookup("ConnectionFactory");
            m_connection = m_connectionFactory.createQueueConnection();
            m_session = m_connection.createQueueSession( false, Session.AUTO_ACKNOWLEDGE );
            m_connection.start();
            m_queue = (Queue)context.lookup(m_queueName);
            
            context.close();
    	}
    	catch(NamingException e){
    		m_log.error("initial:" + e.getMessage());
    		this.terminate();
			throw e;
    	}
    	catch(JMSException e){
    		m_log.error("initial:" + e.getMessage());
    		this.terminate();
			throw e;
    	}
    }
    
    /**
     * å
     * 
     * @throws JMSException
     */
    public void terminate() throws JMSException{
    	
		try {
			if (m_session != null){
				m_session.close();
				m_session = null;
			}
		}
		catch (JMSException e) {
			m_log.debug("terminate:" + e.getMessage());
		}

		try {
			if (m_connection != null){
				m_connection.close();
				m_connection = null;
			}
		}
		catch (JMSException e){
			m_log.debug("terminate:" + e.getMessage());
		}
    }
}

