/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.monitor.run.ejb.entity;

import java.sql.Timestamp;
import java.util.Collection;

import javax.ejb.EntityBean;

/**
 * @ejb.bean name="MonitorInfo"
 *           jndi-name="MonitorInfo"
 *           type="CMP"
 *           schema="MonitorInfo" 
 *           cmp-version="2.x"
 *           data-source="java:/HinemosDS"
 *           primkey-field="monitorTypeId","monitorId"
 * 
 * @jboss.depends name="jboss.jca:service=DataSourceBinding,name=HinemosDS"
 * 
 * @ejb.permission
 *     unchecked="true"
 *        
 * @ejb.persistence 
 *   table-name="cc_monitor_info" 
 *    
 * @ejb.finder
 *    query=""
 *    signature="java.util.Collection findAll(java.lang.String monitorTypeId)"
 * @jboss.query
 *    query="SELECT OBJECT(a) FROM MonitorInfo as a WHERE a.monitorTypeId = ?1"
 *    signature="java.util.Collection findAll(java.lang.String monitorTypeId)"
 *
 * @ejb.pk class="com.clustercontrol.monitor.run.ejb.entity.MonitorInfoPK" 
 *           
 */
public abstract class MonitorInfoBean implements EntityBean {
	
	/**
	*
	* <!-- begin-user-doc -->
	* The  ejbCreate method.
	* <!-- end-user-doc -->
	*
	* <!-- begin-xdoclet-definition --> 
	* @ejb.create-method 
	* <!-- end-xdoclet-definition --> 
	* @generated
	*/
	public MonitorInfoPK ejbCreate(
			String monitorTypeId, 
			String monitorId, 
			Integer monitorType, 
			String description, 
			String facilityId, 
			Integer runInterval, 
			Integer timeout,
			String calendarId, 
			Integer monitorBlock, 
			String determinationId, 
			Integer failurePriority,
			String notifyId, 
			String application, 
			Integer jobRun, 
			String failureMessageId, 
			String failureMessage,
			Integer failureJobRun,
			String failureJobId,
			Integer failureJobInhibitionFlg,
			Integer failureJobFailurePriority,
			Timestamp regDate,  
			Timestamp updateDate, 
			String regUser, 
			String updateUser
			) throws javax.ejb.CreateException {

		this.setMonitorTypeId(monitorTypeId);
		this.setMonitorId(monitorId);
		this.setMonitorType(monitorType);
		this.setDescription(description);
		this.setFacilityId(facilityId);
		this.setRunInterval(runInterval);
		this.setTimeout(timeout);
		this.setCalendarId(calendarId);
		this.setMonitorBlock(monitorBlock);
		this.setDeterminationId(determinationId);
		this.setFailurePriority(failurePriority);
		this.setNotifyId(notifyId);
		this.setApplication(application);
		this.setJobRun(jobRun);
		this.setFailureMessageId(failureMessageId);
		this.setFailureMessage(failureMessage);
		this.setFailureJobRun(failureJobRun);
		this.setFailureJobId(failureJobId);
		this.setFailureJobInhibitionFlg(failureJobInhibitionFlg);
		this.setFailureJobFailurePriority(failureJobFailurePriority);
		this.setRegDate(regDate);
		this.setUpdateDate(updateDate);
		this.setRegUser(regUser);
		this.setUpdateUser(updateUser);
		
		return null;
	}

	/**
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="application"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="VARCHAR(64)"
	 *     read-only="false"
	 *
	 * @ejb.interface-method
	 * 
	 * @return Returns the application.
	 */
	public abstract String getApplication();

	/**
	 * @ejb.interface-method
	 * 
	 * @param application The application to set.
	 */
	public abstract void setApplication(String application);

	/**
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="calendar_id"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="VARCHAR(64)"
	 *     read-only="false"
	 *
	 * @ejb.interface-method
	 * 
	 * @return Returns the calendarId.
	 */
	public abstract String getCalendarId();

	/**
	 * @ejb.interface-method
	 * 
	 * @param calendarId The calendarId to set.
	 */
	public abstract void setCalendarId(String calendarId);

	/**
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="description"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="VARCHAR(256)"
	 *     read-only="false"
	 *
	 * @ejb.interface-method
	 * 
	 * @return Returns the description.
	 */
	public abstract String getDescription();

	/**
	 * @ejb.interface-method
	 * 
	 * @param description The description to set.
	 */
	public abstract void setDescription(String description);

	/**
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="determination_id"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="VARCHAR(64)"
	 *     read-only="false"
	 *
	 * @ejb.interface-method
	 * 
	 * @return Returns the determinationId.
	 */
	public abstract String getDeterminationId();

	/**
	 * @ejb.interface-method
	 * 
	 * @param determinationId The determinationId to set.
	 */
	public abstract void setDeterminationId(String determinationId);

	/**
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="facility_id"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="VARCHAR(64)"
	 *     read-only="false"
	 *
	 * @ejb.interface-method
	 * 
	 * @return Returns the facilityId.
	 */
	public abstract String getFacilityId();

	/**
	 * @ejb.interface-method
	 * 
	 * @param facilityId The facilityId to set.
	 */
	public abstract void setFacilityId(String facilityId);
	
	/**
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="failure_job_failure_priority"
	 *     jdbc-type="SMALLINT"
	 *     sql-type="smallint"
	 *     read-only="false"
	 *  
	 * @ejb.interface-method
	 * 
	 * @return Returns the failureJobFailurePriority.
	 */
	public abstract Integer getFailureJobFailurePriority();

	/**
	 * @ejb.interface-method
	 * 
	 * @param failureJobFailurePriority The failureJobFailurePriority to set.
	 */
	public abstract void setFailureJobFailurePriority(Integer failureJobFailurePriority);
	
	/**
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="failure_job_id"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="VARCHAR(64)"
	 *     read-only="false"
	 *
	 * @ejb.interface-method
	 * 
	 * @return Returns the failureJobId.
	 */
	public abstract String getFailureJobId();

	/**
	 * @ejb.interface-method
	 * 
	 * @param failureJobId The failureJobId to set.
	 */
	public abstract void setFailureJobId(String failureJobId);
	
	/**
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="failure_job_inhibition_flg"
	 *     jdbc-type="SMALLINT"
	 *     sql-type="smallint"
	 *     read-only="false"
	 *  
	 * @ejb.interface-method
	 * 
	 * @return Returns the failureJobInhibitionFlg.
	 */
	public abstract Integer getFailureJobInhibitionFlg();

	/**
	 * @ejb.interface-method
	 * 
	 * @param failureJobInhibitionFlg The failureJobInhibitionFlg to set.
	 */
	public abstract void setFailureJobInhibitionFlg(Integer failureJobInhibitionFlg);
	
	/**
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="failure_job_run"
	 *     jdbc-type="SMALLINT"
	 *     sql-type="smallint"
	 *     read-only="false"
	 *  
	 * @ejb.interface-method
	 * 
	 * @return Returns the failureJobRun.
	 */
	public abstract Integer getFailureJobRun();

	/**
	 * @ejb.interface-method
	 * 
	 * @param failureJobRun The failureJobRun to set.
	 */
	public abstract void setFailureJobRun(Integer failureJobRun);
	
	/**
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="failure_message"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="VARCHAR(256)"
	 *     read-only="false"
	 *
	 * @ejb.interface-method
	 * 
	 * @return Returns the failureMessage.
	 */
	public abstract String getFailureMessage();

	/**
	 * @ejb.interface-method
	 * 
	 * @param failureMessage The failureMessage to set.
	 */
	public abstract void setFailureMessage(String failureMessage);

	/**
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="failure_message_id"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="VARCHAR(64)"
	 *     read-only="false"
	 *
	 * @ejb.interface-method
	 * 
	 * @return Returns the failureMessageId.
	 */
	public abstract String getFailureMessageId();

	/**
	 * @ejb.interface-method
	 * 
	 * @param failureMessageId The failureMessageId to set.
	 */
	public abstract void setFailureMessageId(String failureMessageId);
	
	/**
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="failure_priority"
	 *     jdbc-type="SMALLINT"
	 *     sql-type="smallint"
	 *     read-only="false"
	 *
	 * @ejb.interface-method
	 * 
	 * @return Returns the failurePriority.
	 */
	public abstract Integer getFailurePriority();

	/**
	 * @ejb.interface-method
	 * 
	 * @param failurePriority The failurePriority to set.
	 */
	public abstract void setFailurePriority(Integer failurePriority);
	
	/**
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="job_run"
	 *     jdbc-type="SMALLINT"
	 *     sql-type="smallint"
	 *     read-only="false"
	 *  
	 * @ejb.interface-method
	 * 
	 * @return Returns the jobRun.
	 */
	public abstract Integer getJobRun();

	/**
	 * @ejb.interface-method
	 * 
	 * @param jobRun The jobRun to set.
	 */
	public abstract void setJobRun(Integer jobRun);
	

	/**
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="monitor_block"
	 *     jdbc-type="SMALLINT"
	 *     sql-type="smallint"
	 *     read-only="false"
	 *
	 * @ejb.interface-method
	 * 
	 * @return Returns the monitorBlock.
	 */
	public abstract Integer getMonitorBlock();

	/**
	 * @ejb.interface-method
	 * 
	 * @param monitorBlock The monitorBlock to set.
	 */
	public abstract void setMonitorBlock(Integer monitorBlock);

	/**
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="monitor_id"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="VARCHAR(64)"
	 *     read-only="false"
	 * @ejb.pk-field 
	 *
	 * @ejb.interface-method
	 * 
	 * @return Returns the monitorId.
	 */
	public abstract String getMonitorId();

	/**
	 * @ejb.interface-method
	 * 
	 * @param monitorId The monitorId to set.
	 */
	public abstract void setMonitorId(String monitorId);
	
	/**
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="monitor_type"
	 *     jdbc-type="SMALLINT"
	 *     sql-type="smallint"
	 *     read-only="false"
	 *  
	 * @ejb.interface-method
	 * 
	 * @return monitorType The monitorType to set.
	 */
	public abstract Integer getMonitorType();

	/**
	 * @ejb.interface-method
	 * 
	 * @param monitorType The runInterval to set.
	 */
	public abstract void setMonitorType(Integer monitorType);
	
	/**
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="monitor_type_id"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="VARCHAR(64)"
	 *     read-only="false"
	 * @ejb.pk-field 
	 *
	 * @ejb.interface-method
	 * 
	 * @return Returns the monitorTypeId.
	 */
	public abstract String getMonitorTypeId();

	/**
	 * @ejb.interface-method
	 * 
	 * @param monitorTypeId The monitorTypeId to set.
	 */
	public abstract void setMonitorTypeId(String monitorTypeId);

	/**
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="notify_id"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="VARCHAR(64)"
	 *     read-only="false"
	 *
	 * @ejb.interface-method
	 * 
	 * @return Returns the notifyId.
	 */
	public abstract String getNotifyId();

	/**
	 * @ejb.interface-method
	 * 
	 * @param notifyId The notifyId to set.
	 */
	public abstract void setNotifyId(String notifyId);

	/**
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="reg_date"
	 *     jdbc-type="TIMESTAMP"
	 *     sql-type="TIMESTAMP"
	 *     read-only="false"
	 *  
	 * @ejb.interface-method
	 * 
	 * @return regDate The regDate to set.
	 */
	public abstract Timestamp getRegDate();

	/**
	 * @ejb.interface-method
	 * 
	 * @param regDate The regDate to set.
	 */
	public abstract void setRegDate(Timestamp regDate);
	
	/**
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="reg_user"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="VARCHAR"
	 *     read-only="false"
	 *
	 * @ejb.interface-method
	 * 
	 * @return the regUser
	 */
	public abstract java.lang.String getRegUser();
	   
	/**
	 * @ejb.interface-method
	 * 
	 * @param java.lang.String the new regUser value
	 */
	public abstract void setRegUser(java.lang.String regUser);	

	/**
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="run_interval"
	 *     jdbc-type="SMALLINT"
	 *     sql-type="smallint"
	 *     read-only="false"
	 *  
	 * @ejb.interface-method
	 * 
	 * @return statusFlg The statusFlg to set.
	 */
	public abstract Integer getRunInterval();

	/**
	 * @ejb.interface-method
	 * 
	 * @param runInterval The runInterval to set.
	 */
	public abstract void setRunInterval(Integer runInterval);
	
	/**
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="timeout"
	 *     jdbc-type="SMALLINT"
	 *     sql-type="smallint"
	 *     read-only="false"
	 * 
	 * @ejb.interface-method
	 * 
	 * @return Returns the timeout.
	 */
	public abstract Integer getTimeout();

	/**
	 * @ejb.interface-method
	 * 
	 * @param timeout The timeout to set.
	 */
	public abstract void setTimeout(Integer timeout);

	/**
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="update_date"
	 *     jdbc-type="TIMESTAMP"
	 *     sql-type="TIMESTAMP"
	 *     read-only="false"
	 *  
	 * @ejb.interface-method
	 * 
	 * @return updateDate The updateDate to set.
	 */
	public abstract Timestamp getUpdateDate();

	/**
	 * @ejb.interface-method
	 * 
	 * @param updateDate The updateDate to set.
	 */
	public abstract void setUpdateDate(Timestamp updateDate);
	
	/**
	 * 
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="update_user"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="VARCHAR"
	 *     read-only="false"
	 *
	 * @ejb.interface-method
	 * 
	 * @return the updateUser
	 */
	public abstract java.lang.String getUpdateUser();
	   
	/**
	 * @ejb.interface-method
	 * 
	 * @param java.lang.String the new update_user value
	 */
	public abstract void setUpdateUser(java.lang.String updateUser);
	
	//	==========================================
	//	 CMR fields
	//	==========================================
	
	/**
	 * @ejb.interface-method view-type="local"
	 * 
	 * @ejb.relation 
	 * name="MonitorInfo-MonitorTruthValueInfo"
	 * role-name="MonitorInfo-MonitorTruthValueInfo(single)"
	 *  
	 * @return Returns the collection.
	 */
	public abstract Collection getMonitorTruthValueInfo();
	
	/**
	 * @ejb.interface-method view-type="local"
	 * 
	 * @param collection The collection to set.
	 */
	public abstract void setMonitorTruthValueInfo(Collection collection);
	
	/**
	 * @ejb.interface-method view-type="local"
	 * 
	 * @ejb.relation 
	 * name="MonitorInfo-MonitorNumericValueInfo"
	 * role-name="MonitorInfo-MonitorNumericValueInfo(single)"
	 *  
	 * @return Returns the collection.
	 * 
	 */
	public abstract Collection getMonitorNumericValueInfo();
	
	/**
	 * @ejb.interface-method view-type="local"
	 * 
	 * @param collection The collection to set.
	 */
	public abstract void setMonitorNumericValueInfo(Collection collection);
	
	/**
	 * @ejb.interface-method view-type="local"
	 * 
	 * @ejb.relation 
	 * name="MonitorInfo-MonitorStringValueInfo"
	 * role-name="MonitorInfo-MonitorStringValueInfo(single)"
	 *  
	 * @return Returns the collection.
	 * 
	 */
	public abstract Collection getMonitorStringValueInfo();
	
	/**
	 * @ejb.interface-method view-type="local"
	 * 
	 * @param collection The collection to set.
	 */
	public abstract void setMonitorStringValueInfo(Collection collection);
	
}
