/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.monitor.run.factory;

import java.util.ArrayList;
import java.util.Collection;

import javax.ejb.CreateException;
import javax.naming.NamingException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.monitor.run.bean.MonitorNumericValueInfo;
import com.clustercontrol.monitor.run.ejb.entity.MonitorNumericValueInfoLocal;
import com.clustercontrol.monitor.run.ejb.entity.MonitorNumericValueInfoUtil;

/**
 * ʹƻȽϿ饹
 *
 * @version 2.1.0
 * @since 2.0.0
 */
abstract public class AddMonitorNumericValueType extends AddMonitor{
	
	protected static Log m_log = LogFactory.getLog( AddMonitorNumericValueType.class );
	
	/* ( Javadoc)
	 *  ʹƻȽ
	 * @see com.clustercontrol.monitor.run.factory.AddMonitor#addJudgementInfo()
	 */
	@Override
	@SuppressWarnings("unchecked")
	public boolean addJudgementInfo() throws CreateException, NamingException {
		
		Collection ct = m_monitor.getMonitorNumericValueInfo();
		
		ArrayList valueList = m_monitorInfo.getJudgementInfo();
		ArrayList<MonitorNumericValueInfoLocal> valueLocalList = new ArrayList<MonitorNumericValueInfoLocal>();
		
		// ʹƻȽ
		MonitorNumericValueInfo value = null;
		for(int index=0; index<valueList.size(); index++){
			value = (MonitorNumericValueInfo)valueList.get(index);
			if(value != null){
				MonitorNumericValueInfoLocal local = MonitorNumericValueInfoUtil.getLocalHome().create(
						m_monitorInfo.getMonitorTypeId(),
						m_monitorInfo.getMonitorId(),
						Integer.valueOf(value.getPriority()),
						Float.valueOf(value.getThresholdUpperLimit()),
						Float.valueOf(value.getThresholdLowerLimit()),
						value.getMessageId(),
						value.getMessage(),
						Integer.valueOf(value.getJobRun()),
						value.getJobId(),
						Integer.valueOf(value.getJobInhibitionFlg()),
						Integer.valueOf(value.getJobFailurePriority()));
				valueLocalList.add(local);
			}
		}
		ct.addAll(valueLocalList);
		m_monitor.setMonitorNumericValueInfo(ct);
		
		return true;
	}
}
