/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.monitor.run.factory;

import java.util.ArrayList;
import java.util.Collection;

import javax.ejb.CreateException;
import javax.naming.NamingException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.bean.ValidConstant;
import com.clustercontrol.monitor.run.bean.MonitorStringValueInfo;
import com.clustercontrol.monitor.run.ejb.entity.MonitorStringValueInfoLocal;
import com.clustercontrol.monitor.run.ejb.entity.MonitorStringValueInfoUtil;

/**
 * ʸƻȽϿ饹
 *
 * @version 2.1.0
 * @since 2.1.0
 */
abstract public class AddMonitorStringValueType extends AddMonitor{
	
	protected static Log m_log = LogFactory.getLog( AddMonitorStringValueType.class );
	
	/* ( Javadoc)
	 *  ʸƻȽ
	 * @see com.clustercontrol.monitor.run.factory.AddMonitor#addJudgementInfo()
	 */
	@Override
	@SuppressWarnings("unchecked")
	public boolean addJudgementInfo() throws CreateException, NamingException {
		
		Collection ct = m_monitor.getMonitorStringValueInfo();
		
		ArrayList valueList = m_monitorInfo.getJudgementInfo();
		ArrayList<MonitorStringValueInfoLocal> valueLocalList = new ArrayList<MonitorStringValueInfoLocal>();
		
		// ʸƻȽ
		MonitorStringValueInfo value = null;
		for(int index=0; index<valueList.size(); index++){
			value = (MonitorStringValueInfo)valueList.get(index);
			if(value != null){
				MonitorStringValueInfoLocal local = MonitorStringValueInfoUtil.getLocalHome().create(
						m_monitorInfo.getMonitorTypeId(),
						m_monitorInfo.getMonitorId(),
						Integer.valueOf(value.getOrderNo()),
						value.getDescription(),
						Integer.valueOf(value.getProcessType()),
						value.getPattern(),
						Integer.valueOf(value.getPriority()),
						value.getMessageId(),
						value.getMessage(),
						value.getNotifyId(),
						Integer.valueOf(value.getJobRun()),
						value.getJobId(),
						Integer.valueOf(value.getJobInhibitionFlg()),
						Integer.valueOf(value.getJobFailurePriority()),
						ValidConstant.booleanToType(value.isValidFlg())
						);
				valueLocalList.add(local);
			}
		}
		ct.addAll(valueLocalList);
		m_monitor.setMonitorStringValueInfo(ct);
		
		return true;
	}
}
