/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.monitor.run.factory;

import javax.ejb.FinderException;
import javax.ejb.RemoveException;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.InvalidTransactionException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.quartz.SchedulerException;

import com.clustercontrol.accesscontrol.factory.AccessLock;
import com.clustercontrol.monitor.run.ejb.entity.MonitorInfoLocal;
import com.clustercontrol.monitor.run.ejb.entity.MonitorInfoPK;
import com.clustercontrol.monitor.run.ejb.entity.MonitorInfoUtil;
import com.clustercontrol.util.apllog.AplLogger;

/**
 * ƻ饹
 *
 * @version 2.0.0
 * @since 2.0.0
 */
abstract public class DeleteMonitor {
	
	protected static Log m_log = LogFactory.getLog( DeleteMonitor.class );
	
	/** ƻ󥳥ݡͥ */
	protected MonitorInfoLocal m_monitor;
	
	/** ƻоID */
	protected String m_monitorTypeId;
	
	/** ƻID */
	protected String m_monitorId;
	
	/**
	 * ƻ
	 * 
	 * @param monitorTypeId ƻоID
     * @param monitorId ƻID
	 * @return 硢true
	 * @throws FinderException
	 * @throws RemoveException
	 * @throws SchedulerException
	 * @throws NamingException
	 * @throws NotSupportedException
	 * @throws HeuristicMixedException
	 * @throws HeuristicRollbackException
	 * @throws RollbackException
	 * @throws InvalidTransactionException
	 * @throws IllegalStateException
	 * @throws SystemException
	 */
	public boolean delete(String monitorTypeId, String monitorId) throws FinderException, RemoveException, SchedulerException, NamingException, NotSupportedException, HeuristicMixedException, HeuristicRollbackException, RollbackException, InvalidTransactionException, IllegalStateException, SystemException{
    	
		//å
    	AccessLock.lock(AccessLock.MONITOR);
    	
		m_monitorTypeId = monitorTypeId;
		m_monitorId = monitorId;

		TransactionManager tm = null;
		Transaction tx = null;
		Transaction oldTx = null;
		boolean result = false;
		
		try 
		{
			// TransactionManager
			InitialContext context = new InitialContext();
			tm = (TransactionManager)context.lookup("java:/TransactionManager");
			
			// ¹Υåɤȥ󥶥˴ϢդƤϡȥ󥶥 
			if(tm.getTransaction() != null){
				oldTx = tm.suspend();
			}
			
			try{
				// ȥ󥶥󳫻
				if(tm.getTransaction() == null){
					tm.begin();	
					tx = tm.getTransaction();
				}
				
				// ƻϿ
				result = deleteMonitorInfo();
				if(result){
					// ߥå
					tx.commit();
				}
			
			} catch(NotSupportedException e){
				outputLog(e, "delete()");
				throw e;
			} catch (RollbackException e) {
				outputLog(e, "delete()");
				throw e;
			} catch (HeuristicMixedException e) {
				outputLog(e, "delete()");
				throw e;
			} catch(HeuristicRollbackException e){
				outputLog(e, "delete()");
				throw e;
			} catch(SystemException e){
				outputLog(e, "delete()");
				throw e;
			}
			finally{
				// ȥ󥶥Ϣ㳰ȯϡХå
				if(tx != null){
					if(!result){
						tx.rollback();
					}
					tx = null;
				}
			}
		}
		finally{
			
			// ߤƤȥ󥶥Ƴ
			if(oldTx != null){
				try{
					tm.resume(oldTx);
					
				} catch(InvalidTransactionException e){
					outputLog(e, "delete()");
					throw e;
				} catch(IllegalStateException e){
					outputLog(e, "delete()");
					throw e;
				} catch(SystemException e){
					outputLog(e, "delete()");
					throw e;
				}
			}
		}
		return result;
	}
	
	/**
	 * Ƚ
	 * <p> 
	 * 
	 * Ƚ꥿̤ȽƲ
	 * 
	 * @return 硢true
	 * @throws RemoveException
	 * @throws NamingException
	 */
	public abstract boolean deleteJudgementInfo() throws RemoveException, NamingException;
	
	/**
	 * ƻå
	 * <p> 
	 * 
	 * ƴƻΥåƲ
	 * 
	 * @return 硢true
	 * @throws FinderException
	 * @throws RemoveException
	 * @throws NamingException
	 */
	public abstract boolean deleteCheckInfo() throws FinderException, RemoveException, NamingException;
	
	/**
	 * ƻ
	 * 
	 * @param monitorTypeId ƻоID
     * @param monitorId ƻID
	 * @return 硢true
	 * @throws FinderException
	 * @throws RemoveException
	 * @throws SchedulerException
	 * @throws NamingException
	 */
	public boolean deleteMonitorInfo() throws FinderException, RemoveException, SchedulerException, NamingException {
		
		try 
		{
			// ƻ
			MonitorInfoPK pk = new MonitorInfoPK(m_monitorId, m_monitorTypeId);
			m_monitor = MonitorInfoUtil.getLocalHome().findByPrimaryKey(pk);

			// ƻå
			if(deleteCheckInfo()){
			
				// Ƚ
				if(deleteJudgementInfo()){
					
					// ƻ
					m_monitor.remove();
					
					// Quartz
					ModifySchedule quartz = new ModifySchedule();
					quartz.deleteSchedule(m_monitorTypeId, m_monitorId);
					
					return true;
				}
			}
			return false;

		} catch (FinderException e) {
			outputLog(e, "deleteMonitorInfo()");
			throw e;
		} catch (RemoveException e) {
			outputLog(e, "deleteMonitorInfo()");
			throw e;
		} catch (SchedulerException e) {
			outputLog(e, "deleteMonitorInfo()");
			throw e;
		} catch (NamingException e) {
			outputLog(e, "deleteMonitorInfo()");
			throw e;
		}
	}
	
	/**
     * ץꥱ˥
     * 
     * @param e 㳰
     */
	private void outputLog(Exception e, String method) {
		AplLogger apllog = new AplLogger("MON", "mon");
		String[] args = {m_monitorTypeId, m_monitorId };
        apllog.put("SYS", "009", args);
        m_log.debug(method + ":" + e.getMessage());
	}
}
