/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.monitor.run.factory;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Locale;

import javax.ejb.CreateException;
import javax.ejb.FinderException;
import javax.naming.NamingException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.swt.SWT;
import org.quartz.SchedulerException;

import com.clustercontrol.bean.TableColumnInfo;
import com.clustercontrol.bean.ValidConstant;
import com.clustercontrol.monitor.run.bean.MonitorStringValueInfo;
import com.clustercontrol.monitor.run.bean.StringValueListTabelDefine;
import com.clustercontrol.monitor.run.ejb.entity.MonitorStringValueInfoLocal;
import com.clustercontrol.util.Messages;

/**
 * ʸƻȽ󸡺饹
 *
 * @version 2.1.0
 * @since 2.1.0
 */
abstract public class SelectMonitorStringValueType extends SelectMonitor{
	
	protected static Log m_log = LogFactory.getLog( SelectMonitorStringValueType.class );

	/* ( Javadoc)
	 * @see com.clustercontrol.monitor.run.factory.SelectMonitor#getJudgementInfo()
	 */
	@Override
	public ArrayList getJudgementInfo() throws FinderException, NamingException {
		
		// ʸƻȽ
		Collection ct = m_monitor.getMonitorStringValueInfo();
        Iterator itr = ct.iterator();
		
		ArrayList<MonitorStringValueInfo> valueList = new ArrayList<MonitorStringValueInfo>();
		
		MonitorStringValueInfoLocal local = null;
        while(itr.hasNext()){
            local = (MonitorStringValueInfoLocal)itr.next();
            MonitorStringValueInfo value = new MonitorStringValueInfo(
            		local.getMonitorTypeId(),
            		local.getMonitorId(),
            		local.getOrderNo().intValue(),
            		local.getDescription(),
            		local.getProcessType().intValue(),
            		local.getPattern(),
            		local.getPriority().intValue(),
            		local.getMessageId(),
            		local.getMessage(),
            		local.getNotifyId(),
            		local.getJobRun().intValue(),
            		local.getJobId(),
            		local.getJobInhibitionFlg().intValue(),
            		local.getJobFailurePriority().intValue(),
            		ValidConstant.typeToBoolean(local.getValidFlg().intValue()));
            valueList.add(value);
        }
		return valueList;
	}
	
	/**
	 * ʸƻȽΥơ֥֤ޤ
	 * 
	 * @param locale 
	 * @return TableColumnInfo
	 * @throws CreateException
	 * @throws FinderException
	 * @throws SchedulerException
	 * @throws NamingException
	 */
	@SuppressWarnings("unchecked")
	public ArrayList getStringValueListTableDefine(Locale locale) {

		/** ơ֥ */
		ArrayList tableDefine = new ArrayList();

		tableDefine.add(StringValueListTabelDefine.ORDER_NO, 
				new TableColumnInfo(Messages.getString("order", locale), TableColumnInfo.NONE, 40, SWT.RIGHT));
		tableDefine.add(StringValueListTabelDefine.PROCESS_TYPE, 
				new TableColumnInfo(Messages.getString("process", locale), TableColumnInfo.PROCESS, 50, SWT.LEFT));
		tableDefine.add(StringValueListTabelDefine.DESCRIPTION, 
				new TableColumnInfo(Messages.getString("description", locale), TableColumnInfo.NONE, 180, SWT.LEFT));
		tableDefine.add(StringValueListTabelDefine.NOTIFY_ID, 
				new TableColumnInfo(Messages.getString("notify.id", locale), TableColumnInfo.NONE, 80, SWT.LEFT));
		tableDefine.add(StringValueListTabelDefine.MESSAGE_ID, 
				new TableColumnInfo(Messages.getString("message.id", locale), TableColumnInfo.NONE, 90, SWT.LEFT));

		return tableDefine;
	}
}
