/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.monitor.composite;

import java.rmi.AccessException;
import java.util.ArrayList;
import java.util.List;

import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;

import com.clustercontrol.bean.Property;
import com.clustercontrol.composite.CommonTableViewer;
import com.clustercontrol.monitor.action.GetEventListTableDefine;
import com.clustercontrol.monitor.action.GetFilterEvent;
import com.clustercontrol.monitor.bean.EventListInfo;
import com.clustercontrol.monitor.bean.EventTabelDefine;
import com.clustercontrol.monitor.dialog.EventInfoDialog;
import com.clustercontrol.monitor.preference.MonitorPreferencePage;
import com.clustercontrol.monitor.ui.MonitorUIPlugin;
import com.clustercontrol.util.Messages;

/**
 * ٥ȴƻݥåȥ饹Ǥ
 * 
 * @version 2.0.0
 * @since 1.0.0
 */
public class EventListComposite extends Composite {
    // ----- instance ե ----- //

    /** ơ֥ӥ塼 */
    private CommonTableViewer tableViewer = null;

    /** ٥ */
    private Label criticalLabel = null;

    /** ٹ٥ */
    private Label warningLabel = null;

    /** Υ٥ */
    private Label infoLabel = null;

    /** ٥ */
    private Label unknownLabel = null;

    /** ץ٥ */
    private Label totalLabel = null;
    
    private Shell m_shell = null;
    
    private boolean openAccessInformation = false;
    private boolean openInformation = false;

    // ----- 󥹥ȥ饯 ----- //

    /**
     * 󥹥󥹤֤ޤ
     * 
     * @param parent
     *            ƤΥݥå
     * @param style
     *            
     */
    public EventListComposite(Composite parent, int style) {
        super(parent, style);
        initialize();
        m_shell = this.getShell();
    }

    // ----- instance ᥽å ----- //

    private void initialize() {
        GridLayout layout = new GridLayout(5, true);
        this.setLayout(layout);
        layout.marginHeight = 0;
        layout.marginWidth = 0;

        Table table = new Table(this, SWT.H_SCROLL | SWT.V_SCROLL
                | SWT.FULL_SELECTION | SWT.MULTI);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);

        GridData gridData = new GridData();
        gridData.horizontalAlignment = GridData.FILL;
        gridData.verticalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalSpan = 5;
        table.setLayoutData(gridData);

        // ơ

        // 
        this.criticalLabel = new Label(this, SWT.CENTER);
        gridData = new GridData();
        gridData.horizontalAlignment = GridData.FILL;
        gridData.verticalAlignment = GridData.FILL;
        this.criticalLabel.setLayoutData(gridData);
        this.criticalLabel.setBackground(this.getDisplay().getSystemColor(
                SWT.COLOR_RED));

        // ٹ
        this.warningLabel = new Label(this, SWT.CENTER);
        gridData = new GridData();
        gridData.horizontalAlignment = GridData.FILL;
        gridData.verticalAlignment = GridData.FILL;
        this.warningLabel.setLayoutData(gridData);
        this.warningLabel.setBackground(this.getDisplay().getSystemColor(
                SWT.COLOR_YELLOW));

        // 
        this.infoLabel = new Label(this, SWT.CENTER);
        gridData = new GridData();
        gridData.horizontalAlignment = GridData.FILL;
        gridData.verticalAlignment = GridData.FILL;
        this.infoLabel.setLayoutData(gridData);
        this.infoLabel.setBackground(this.getDisplay().getSystemColor(
                SWT.COLOR_GREEN));

        // 
        this.unknownLabel = new Label(this, SWT.CENTER);
        gridData = new GridData();
        gridData.horizontalAlignment = GridData.FILL;
        gridData.verticalAlignment = GridData.FILL;
        this.unknownLabel.setLayoutData(gridData);
        this.unknownLabel.setBackground(new Color(null, 128, 192, 255));

        // 
        this.totalLabel = new Label(this, SWT.CENTER);
        gridData = new GridData();
        gridData.horizontalAlignment = GridData.FILL;
        gridData.verticalAlignment = GridData.FILL;
        this.totalLabel.setLayoutData(gridData);

        // ơ֥ӥ塼κ
        this.tableViewer = new CommonTableViewer(table);
        this.tableViewer
                .createTableColumn(GetEventListTableDefine.get(),
                        EventTabelDefine.SORT_COLUMN_INDEX,
                        EventTabelDefine.SORT_ORDER);
        
        // ֥륯å硢٥ȥξܺپɽ
		this.tableViewer.addDoubleClickListener(
                new IDoubleClickListener() {
                    public void doubleClick(DoubleClickEvent event) {
                    	
                        // 򥢥ƥ
                        List list = (List) ((StructuredSelection)event.getSelection()).getFirstElement();
                    	
                        EventInfoDialog dialog = new EventInfoDialog(m_shell, list);
                        dialog.open();
                    }
                });
    }

    /**
     * tableViewer֤ޤ
     * 
     * @return tableViewer
     */
    public CommonTableViewer getTableViewer() {
        return this.tableViewer;
    }
    
    /**
     * ΥݥåȤѤơ֥֤ޤ
     * 
     * @return ơ֥
     */
    public Table getTable() {
        return this.tableViewer.getTable();
    }

    /**
     * ӥ塼򹹿ޤ
     * 
     * @param facilityId
     *            ɽоݤΥեƥID
     */
    public void update(String facilityId) {
        super.update();

        EventListInfo infoList = null;

        try {
            infoList = new GetFilterEvent().getFilterInfo(facilityId);
        } catch (AccessException e) {
        	if(!openAccessInformation){
        		openAccessInformation = true;
        		// ʤξ硢顼ɽ
        		MessageDialog.openInformation(null, Messages.getString("message"),
	                    Messages.getString("message.accesscontrol.16"));
        	}
        }
        
        if (infoList == null) {
            infoList = new EventListInfo();
            infoList.setEventList(new ArrayList());
        }
        else if(infoList.getEventList() == null){
        	infoList.setEventList(new ArrayList());
        }
        
        if(MonitorUIPlugin.getDefault().getPreferenceStore().getBoolean(
        		MonitorPreferencePage.P_EVENT_MESSAGE_FLG)){
        	if(infoList.getTotal() > infoList.getEventList().size()){ 
        		if(!openInformation){
        			openInformation = true;
        			// ɽĶ硢顼ɽ
        			MessageDialogWithToggle.openInformation(
        					null, 
        					Messages.getString("message"),
        					Messages.getString("message.monitor.12"), 
        					Messages.getString("message.will.not.be.displayed"), 
        					false, 
        					MonitorUIPlugin.getDefault().getPreferenceStore(), 
        					MonitorPreferencePage.P_EVENT_MESSAGE_FLG);
        			openInformation = false;
        		}
        	} 
        }

        this.updateStatus(infoList);
        Object[] args = { this.totalLabel.getText() };
        this.totalLabel.setText(Messages.getString("records", args));

        tableViewer.setInput(infoList.getEventList());
    }

    /**
     * ӥ塼򹹿ޤ
     * 
     * @param facilityId
     *            եƥID
     * @param condition
     *            
     */
    public void update(String facilityId, Property condition) {
        super.update();

        EventListInfo infoList = null;

        try {
            infoList = new GetFilterEvent()
                    .getFilterInfo(facilityId, condition);
        } catch (AccessException e) {
        	if(!openAccessInformation){
        		openAccessInformation = true;
        		// ʤξ硢顼ɽ
        		MessageDialog.openInformation(null, Messages.getString("message"),
	                    Messages.getString("message.accesscontrol.16"));
        	}
        }
        
        if (infoList == null) {
            infoList = new EventListInfo();
            infoList.setEventList(new ArrayList());
        }
        else if(infoList.getEventList() == null){
        	infoList.setEventList(new ArrayList());
        }
        
        if(MonitorUIPlugin.getDefault().getPreferenceStore().getBoolean(
        		MonitorPreferencePage.P_EVENT_MESSAGE_FLG)){
        	if(infoList.getTotal() > infoList.getEventList().size()){ 
        		if(!openInformation){
        			openInformation = true;
        			// ɽĶ硢顼ɽ
        			MessageDialogWithToggle.openInformation(
        					null, 
        					Messages.getString("message"),
        					Messages.getString("message.monitor.12"), 
        					Messages.getString("message.will.not.be.displayed"), 
        					false, 
        					MonitorUIPlugin.getDefault().getPreferenceStore(), 
        					MonitorPreferencePage.P_EVENT_MESSAGE_FLG);
        			openInformation = false;
        		}
        	} 
        }

        this.updateStatus(infoList);
        Object[] args = { this.totalLabel.getText() };
        this.totalLabel.setText(Messages.getString("filtered.records", args));

        tableViewer.setInput(infoList.getEventList());
    }

    /**
     * ơ٥򹹿ޤ
     * 
     * @param list
     */
    protected void updateStatus(EventListInfo list) {
        // ٥빹
        this.criticalLabel.setText(String.valueOf(list.getCritical()));
        this.warningLabel.setText(String.valueOf(list.getWarning()));
        this.infoLabel.setText(String.valueOf(list.getInfo()));
        this.unknownLabel.setText(String.valueOf(list.getUnKnown()));
        this.totalLabel.setText(String.valueOf(list.getTotal()));
    }
}