/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.monitor.composite;

import java.rmi.AccessException;
import java.util.ArrayList;

import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Table;

import com.clustercontrol.bean.PriorityConstant;
import com.clustercontrol.composite.CommonTableViewer;
import com.clustercontrol.monitor.action.GetFilterScope;
import com.clustercontrol.monitor.action.GetScopeListTableDefine;
import com.clustercontrol.monitor.bean.ScopeTabelDefine;
import com.clustercontrol.monitor.view.action.ScopeSpecifiedShowAction;
import com.clustercontrol.util.Messages;

/**
 * ״ƻݥåȥ饹Ǥ
 * 
 * @version 1.0.0
 * @since 1.0.0
 */
public class ScopeListComposite extends Composite {

    // ----- instance ե ----- //

    /** ơ֥ӥ塼 */
    private CommonTableViewer tableViewer = null;

    /** ٥ */
    private Label criticalLabel = null;

    /** ٹ٥ */
    private Label warningLabel = null;

    /** Υ٥ */
    private Label infoLabel = null;

    /** ٥ */
    private Label unknownLabel = null;

    /** ץ٥ */
    private Label totalLabel = null;
    
    private boolean openAccessInformation = false;

    // ----- 󥹥ȥ饯 ----- //

    /**
     * 󥹥󥹤֤ޤ
     * 
     * @param parent
     *            ƤΥݥå
     * @param style
     *            
     */
    public ScopeListComposite(Composite parent, int style) {
        super(parent, style);
        initialize();
    }

    // ----- instance ᥽å ----- //

    private void initialize() {
        GridLayout layout = new GridLayout(5, true);
        this.setLayout(layout);
        layout.marginHeight = 0;
        layout.marginWidth = 0;

        Table table = new Table(this, SWT.H_SCROLL | SWT.V_SCROLL
                | SWT.FULL_SELECTION | SWT.SINGLE);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);

        GridData gridData = new GridData();
        gridData.horizontalAlignment = GridData.FILL;
        gridData.verticalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalSpan = 5;
        table.setLayoutData(gridData);

        // ơ

        // 
        this.criticalLabel = new Label(this, SWT.CENTER);
        gridData = new GridData();
        gridData.horizontalAlignment = GridData.FILL;
        gridData.verticalAlignment = GridData.FILL;
        this.criticalLabel.setLayoutData(gridData);
        this.criticalLabel.setBackground(this.getDisplay().getSystemColor(
                SWT.COLOR_RED));

        // ٹ
        this.warningLabel = new Label(this, SWT.CENTER);
        gridData = new GridData();
        gridData.horizontalAlignment = GridData.FILL;
        gridData.verticalAlignment = GridData.FILL;
        this.warningLabel.setLayoutData(gridData);
        this.warningLabel.setBackground(this.getDisplay().getSystemColor(
                SWT.COLOR_YELLOW));

        // 
        this.infoLabel = new Label(this, SWT.CENTER);
        gridData = new GridData();
        gridData.horizontalAlignment = GridData.FILL;
        gridData.verticalAlignment = GridData.FILL;
        this.infoLabel.setLayoutData(gridData);
        this.infoLabel.setBackground(this.getDisplay().getSystemColor(
                SWT.COLOR_GREEN));

        // 
        this.unknownLabel = new Label(this, SWT.CENTER);
        gridData = new GridData();
        gridData.horizontalAlignment = GridData.FILL;
        gridData.verticalAlignment = GridData.FILL;
        this.unknownLabel.setLayoutData(gridData);
        this.unknownLabel.setBackground(new Color(null, 128, 192, 255));

        // 
        this.totalLabel = new Label(this, SWT.CENTER);
        gridData = new GridData();
        gridData.horizontalAlignment = GridData.FILL;
        gridData.verticalAlignment = GridData.FILL;
        this.totalLabel.setLayoutData(gridData);

        // ơ֥ӥ塼κ
        this.tableViewer = new CommonTableViewer(table);
        this.tableViewer
                .createTableColumn(GetScopeListTableDefine.get(),
                        ScopeTabelDefine.SORT_COLUMN_INDEX,
                        ScopeTabelDefine.SORT_ORDER);
        
        // ֥륯å硢ɽ۲˰ư
        ScopeSpecifiedShowAction listener = new ScopeSpecifiedShowAction();
		this.tableViewer.addDoubleClickListener(listener);
    }

    /**
     * tableViewer֤ޤ
     * 
     * @return tableViewer
     */
    public CommonTableViewer getTableViewer() {
        return this.tableViewer;
    }

    /**
     * ӥ塼򹹿ޤ
     * 
     * @param facilityId
     *            ɽоݤΥեƥID
     */
    public void update(String facilityId) {
        super.update();

        ArrayList infoList = null;
		try {
			infoList = new GetFilterScope().getFilterInfo(facilityId);
		} catch (AccessException e) {
			if(!openAccessInformation){
        		openAccessInformation = true;
        		// ʤξ硢顼ɽ
        		MessageDialog.openInformation(null, Messages.getString("message"),
	                    Messages.getString("message.accesscontrol.16"));
        	}
		}
        if (infoList == null) {
            infoList = new ArrayList();
        }
        
        this.updateStatus(infoList);

        tableViewer.setInput(infoList);
    }

    /**
     * ơ٥򹹿ޤ
     * 
     * @param list
     *            ǡ
     */
    protected void updateStatus(ArrayList list) {
        int[] status = new int[4];

        if (list != null) {
            int count = list.size();

            for (int i = 0; i < count; i++) {
                ArrayList data = (ArrayList) list.get(i);

                int value = ((Integer) data.get(0)).intValue();

                switch (value) {
                case PriorityConstant.TYPE_CRITICAL:
                    status[0]++;
                    break;
                case PriorityConstant.TYPE_WARNING:
                    status[1]++;
                    break;
                case PriorityConstant.TYPE_INFO:
                    status[2]++;
                    break;
                case PriorityConstant.TYPE_UNKNOWN:
                    status[3]++;
                    break;
                }
            }
        }

        // ٥빹
        this.criticalLabel.setText(String.valueOf(status[0]));
        this.warningLabel.setText(String.valueOf(status[1]));
        this.infoLabel.setText(String.valueOf(status[2]));
        this.unknownLabel.setText(String.valueOf(status[3]));
        int total = status[0] + status[1] + status[2] + status[3];
        Object[] args = { String.valueOf(total) };
        this.totalLabel.setText(Messages.getString("records", args));
    }
}