/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.monitor.dialog;

import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.TableTree;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;

import com.clustercontrol.bean.Property;
import com.clustercontrol.composite.PropertySheet;
import com.clustercontrol.dialog.CommonDialog;
import com.clustercontrol.dialog.ValidateResult;
import com.clustercontrol.monitor.action.GetEventBatchConfirmProperty;
import com.clustercontrol.util.Messages;

/**
 * ٥Ȱǧ饹Ǥ
 * 
 * @version 1.0.0
 * @since 1.0.0
 */
public class EventBatchConfirmDialog extends CommonDialog {

    //	----- instance ե ----- //

    /** ơץѥƥ */
    private PropertySheet propertySheet = null;

    // ----- 󥹥ȥ饯 ----- //

    /**
     * Υ󥹥󥹤֤ޤ
     * 
     * @param parent
     *            ƤΥ륪֥
     */
    public EventBatchConfirmDialog(Shell parent) {
        super(parent);
    }

    // ----- instance ᥽å ----- //

    /**
     * ν֤ޤ
     * 
     * @return 
     */
    protected Point getInitialSize() {
        return new Point(400, 500);
    }

    /**
     * ꥢޤ
     * 
     * @param parent
     *            ƤΥ󥹥
     */
    protected void customizeDialog(Composite parent) {
        Shell shell = this.getShell();

        // ȥ
        shell.setText(Messages.getString("dialog.monitor.confirm.all"));

        // 쥤
        GridLayout layout = new GridLayout(1, true);
        layout.marginWidth = 10;
        layout.marginHeight = 10;
        parent.setLayout(layout);

        /*
         * °ץѥƥ
         */

        // ٥
        Label label = new Label(parent, SWT.LEFT);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 1;
        label.setLayoutData(gridData);
        label.setText(Messages.getString("attribute") + " : ");

        // ץѥƥ
        TableTree table = new TableTree(parent, SWT.H_SCROLL | SWT.V_SCROLL
                | SWT.FULL_SELECTION | SWT.MULTI | SWT.BORDER);
        gridData = new GridData();
        gridData.horizontalAlignment = GridData.FILL;
        gridData.verticalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalSpan = 1;
        table.setLayoutData(gridData);

        this.propertySheet = new PropertySheet(table);

        // ץѥƥ
        Property property = new GetEventBatchConfirmProperty().getProperty();
        this.propertySheet.setInput(property);

        // 饤
        Label line = new Label(parent, SWT.SEPARATOR | SWT.HORIZONTAL);
        gridData = new GridData();
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 1;
        line.setLayoutData(gridData);

        // 
        Display display = shell.getDisplay();
        shell.setLocation((display.getBounds().width - shell.getSize().x) / 2,
                (display.getBounds().height - shell.getSize().y) / 2);
    }

    /**
     * ͥå򤷤ޤ
     * 
     * @return ڷ
     */
    protected ValidateResult validate() {
        return super.validate();
    }

    /**
     * ͤݻǡǥޤ
     * 
     * @return ǡǥ
     */
    public Property getInputData() {
        return (Property) this.propertySheet.getInput();
    }

    /**
     * ϣ˥ܥΥƥȤ֤ޤ
     * 
     * @return ϣ˥ܥΥƥ
     */
    protected String getOkButtonText() {
        return Messages.getString("ok");
    }

    /**
     * 󥻥ܥΥƥȤ֤ޤ
     * 
     * @return 󥻥ܥΥƥ
     */
    protected String getCancelButtonText() {
        return Messages.getString("cancel");
    }
}