/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.monitor.dialog;

import java.util.List;

import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.TableTree;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;

import com.clustercontrol.bean.Property;
import com.clustercontrol.composite.PropertySheet;
import com.clustercontrol.dialog.CommonDialog;
import com.clustercontrol.monitor.action.GetEventInfoProperty;
import com.clustercontrol.util.Messages;

/**
 * ٥ȴƻܺپ饹Ǥ
 * 
 * @version 2.0.0
 * @since 2.0.0
 */
public class EventInfoDialog extends CommonDialog {

    // ----- instance ե ----- //

    /** 򤵤줿ƥ */
    private List m_list = null;
    
    /** ץѥƥ */
    private PropertySheet propertySheet = null;

    // ----- 󥹥ȥ饯 ----- //

    /**
     * Υ󥹥󥹤֤ޤ
     * 
     * @param parent
     *            ƤΥ륪֥
     */
    public EventInfoDialog(Shell parent, List list) {
        super(parent);
        setShellStyle(getShellStyle() | SWT.RESIZE | SWT.MAX);
        m_list = list;
    }

    // ----- instance ᥽å ----- //

    /**
     * ν֤ޤ
     * 
     * @return 
     */
    protected Point getInitialSize() {
        return new Point(500, 500);
    }

    /**
     * ꥢޤ
     * 
     * @param parent ƤΥ󥹥
     */
    protected void customizeDialog(Composite parent) {
        Shell shell = this.getShell();

        // ȥ
        shell.setText(Messages.getString("dialog.monitor.info.events"));

        // 쥤
        GridLayout layout = new GridLayout(1, true);
        layout.marginWidth = 10;
        layout.marginHeight = 10;
        parent.setLayout(layout);

        /*
         * °ץѥƥ
         */
        
        // ٥
        Label label = new Label(parent, SWT.LEFT);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 1;
        label.setLayoutData(gridData);
        label.setText(Messages.getString("attribute") + " : ");

        // ץѥƥ
        TableTree table = new TableTree(parent, SWT.H_SCROLL | SWT.V_SCROLL
                | SWT.FULL_SELECTION | SWT.SINGLE | SWT.BORDER);
        
        gridData = new GridData();
        gridData.horizontalAlignment = GridData.FILL;
        gridData.verticalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalSpan = 1;
        table.setLayoutData(gridData);

        this.propertySheet = new PropertySheet(table);
        this.propertySheet.setCopy(false);

        // ץѥƥڤ
        Property property = new GetEventInfoProperty().getProperty(m_list);
        this.propertySheet.setInput(property);

        // 饤
        Label line = new Label(parent, SWT.SEPARATOR | SWT.HORIZONTAL);
        gridData = new GridData();
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 1;
        line.setLayoutData(gridData);

        // 
        Display display = shell.getDisplay();
        shell.setLocation((display.getBounds().width - shell.getSize().x) / 2,
                (display.getBounds().height - shell.getSize().y) / 2);
    }
    
    /**
     * ͤݻǡǥޤ
     * 
     * @return ǡǥ
     */
    public Property getInputData() {
        return (Property) this.propertySheet.getInput();
    }

    /**
     * ͤݻǡǥꤷޤ
     * 
     * @param property
     */
    public void setInputData(Property property) {
        propertySheet.setInput(property);
    }
    
    /**
     * Ĥܥޤ
     * 
     * @param parent ܥСݥå
     */
    protected void createButtonsForButtonBar(Composite parent) {
    	
        // Ĥܥ
        this.createButton(parent, IDialogConstants.CANCEL_ID, Messages.getString("ok"), false);
    }
}