/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.monitor.ui;

import org.eclipse.ui.IFolderLayout;
import org.eclipse.ui.IPageLayout;
import org.eclipse.ui.IPerspectiveFactory;

import com.clustercontrol.monitor.view.EventView;
import com.clustercontrol.monitor.view.ScopeView;
import com.clustercontrol.monitor.view.StatusView;

/**
 * ִƻ뵡ǽΥѡڥƥ֤륯饹Ǥ
 * 
 * @version 1.0.0
 * @since 1.0.0
 */
public class MonitorPerspective implements IPerspectiveFactory {

    /**
     * @see org.eclipse.ui.IPerspectiveFactory#createInitialLayout(org.eclipse.ui.IPageLayout)
     */
    public void createInitialLayout(IPageLayout layout) {
        // 󥻥åȤɲ
        layout.addActionSet("com.clustercontrol.ActionSet");
        layout.addActionSet("com.clustercontrol.collectiverun.ActionSet");
        layout.addActionSet("com.clustercontrol.jobmanagement.ActionSet");
        layout.addActionSet("com.clustercontrol.monitor.ActionSet");
        layout.addActionSet("com.clustercontrol.repository.ActionSet");
        layout.addActionSet("com.clustercontrol.syslogng.ActionSet");
        layout.addActionSet("com.clustercontrol.performance.ActionSet");
        layout.addActionSet("com.clustercontrol.accesscontrol.ActionSet");
        layout.addActionSet("com.clustercontrol.process.ActionSet");
        layout.addActionSet("com.clustercontrol.sql.ActionSet");
        layout.addActionSet("com.clustercontrol.ping.ActionSet");
        layout.addActionSet("com.clustercontrol.hinemosagent.ActionSet");
        layout.addActionSet("com.clustercontrol.snmp.ActionSet");
        layout.addActionSet("com.clustercontrol.priority.ActionSet");
        layout.addActionSet("com.clustercontrol.http.ActionSet");
        layout.addActionSet("com.clustercontrol.troubledetection.ActionSet");
        layout.addActionSet("com.clustercontrol.snmptrap.ActionSet");
        
        //ǥΰɽˤ
        layout.setEditorAreaVisible(false);

        //ǥΰID
        String editorArea = layout.getEditorArea();

        //ǥΰξ66%ե
        IFolderLayout top = layout.createFolder("top", IPageLayout.TOP,
                (float) 0.66f, editorArea);
        //ID=topΥեβ50%եκ
        IFolderLayout middle = layout.createFolder("middle",
                IPageLayout.BOTTOM, (float) 0.5f, "top");
        //ǥΰβ34%ե
        IFolderLayout bottom = layout.createFolder("bottom",
                IPageLayout.BOTTOM, (float) 0.34f, editorArea);

        top.addView(ScopeView.ID);
        middle.addView(StatusView.ID);
        bottom.addView(EventView.ID);
    }
}