/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.monitor.ui;

import java.io.StringWriter;
import java.text.MessageFormat;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

import com.clustercontrol.monitor.preference.MonitorPreferencePage;

/**
 * ִƻ뵡ǽץ饰󥯥饹Ǥ
 * 
 * @version 1.0.0
 * @since 1.0.0
 */
public class MonitorUIPlugin extends AbstractUIPlugin {

    //	 ----- static ե ----- //

    /** ץ饰Υ󥹥 */
    private static MonitorUIPlugin plugin = null;

    //	 ----- static ᥽å ----- //

    /**
     * ȤΥ󥹥󥹤֤ޤ
     * 
     * @return ȤΥ󥹥
     */
    public static MonitorUIPlugin getDefault() {
        return plugin;
    }

    /**
     * ץ饰Υ꥽Хɥꡢꤷʸ֤ޤ
     * 
     * @param key
     *            ʸ
     * @return ꤷʸ󡣥꥽Хɥ뤬̵硢⤷ϻꤷʸ ¸ߤʤϡkey֤ޤ
     */
    public static String getResourceString(String key) {
        ResourceBundle bundle = getDefault().getResourceBundle();
        try {
            return (bundle != null) ? bundle.getString(key) : key;
        } catch (MissingResourceException e) {
            return key;
        }
    }

    /**
     * ץ饰Υ꥽Хɥꡢꤷʸ֤ޤ
     * <p>
     * 
     * @param key
     *            ʸ
     * @param arguments
     *            ֤ʸ
     * @return ꤷʸ󡣥꥽Хɥ뤬̵硢⤷ϻꤷʸ ¸ߤʤϡkey֤ޤ
     * @see java.text.MessageFormat
     */
    public static String getResourceString(String key, Object[] arguments) {
        ResourceBundle bundle = getDefault().getResourceBundle();
        try {
            String message = (bundle != null) ? bundle.getString(key) : key;
            return MessageFormat.format(message, arguments);
        } catch (MissingResourceException e) {
            return key;
        }
    }

    /*
     * ͥȤˤơ侩Ƥ᥽åɷǤ
     */

    /**
     * Ϥޤ
     * 
     * @param message
     *            åʸ
     * @param e
     *            ȯ㳰
     */
    public static void log(String message, Exception e) {
        IStatus status = new Status(IStatus.ERROR, getPluginId(),
                IStatus.ERROR, message, e);
        getDefault().getLog().log(status);
    }

    /**
     * Ϥޤ
     * 
     * @param message
     *            åʸ
     */
    public static void log(String message) {
        log(message, null);
    }

    /**
     * Ϥޤ
     * 
     * @param e
     *            ȯ㳰
     */
    public static void log(Exception e) {
        StringWriter stringWriter = new StringWriter();
        String message = stringWriter.getBuffer().toString();
        log(message, e);
    }

    /**
     * ץ饰IDȤѤǤ롢ͭID֤ޤ
     * 
     * @return ץ饰ID
     * @see Bundle#getSymbolicName()
     */
    public static String getPluginId() {
        return getDefault().getBundle().getSymbolicName();
    }

    //	 ----- instance ե ----- //

    /** ꥽Хɥ */
    private ResourceBundle resourceBundle = null;

    // ----- 󥹥ȥ饯 ----- //

    /**
     * 󥹥󥹤֤ޤ
     */
    public MonitorUIPlugin() {
        super();
        plugin = this;
        try {
            resourceBundle = ResourceBundle
                    .getBundle("com.clustercontrol.monitor.ui.MonitorPluginResources");
        } catch (MissingResourceException x) {
            resourceBundle = null;
        }
    }

    // ----- instance ᥽å ----- //

    /**
     * ץ饰γκݤ˸ƤФޤ
     * 
     * @param context
     *            BundleContext֥
     * @throws Exception
     *             㳰ȯ
     */
    public void start(BundleContext context) throws Exception {
        super.start(context);
    }

    /**
     * ץ饰κݤ˸ƤФޤ
     * 
     * @param context
     *            BundleContext֥
     * @throws Exception
     *             㳰ȯ
     */
    public void stop(BundleContext context) throws Exception {
        super.stop(context);
    }

    /**
     * ץ饰ݻ꥽Хɥ֤ޤ
     * 
     * @return ꥽Хɥ
     */
    public ResourceBundle getResourceBundle() {
        return resourceBundle;
    }

    /**
     * ڡ򥤥󥹥󥹲ͤȿǤޤ
     * 
     * @param store
     *            ݻ饹
     */
    protected void initializeDefaultPreferences(IPreferenceStore store) {
        /*
         * TODO Υ᥽åɤѤ⡢ ĥݥorg.eclipse.core.runtime.preferences
         * Ѥۤ褤ȤΤȡ(Ȥ狼ʤǤ)
         */
        MonitorPreferencePage pref = new MonitorPreferencePage();
    }
}