/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.monitor.view;

import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;

import com.clustercontrol.bean.FacilityTreeItem;
import com.clustercontrol.monitor.composite.ScopeListComposite;
import com.clustercontrol.monitor.preference.MonitorPreferencePage;
import com.clustercontrol.monitor.ui.MonitorUIPlugin;
import com.clustercontrol.view.ScopeListBaseView;

/**
 * ִƻ뵡ǽݥ״ƻӥ塼饹Ǥ
 * 
 * @version 1.0.0
 * @since 1.0.0
 */
public class ScopeView extends ScopeListBaseView {
    public static final String ID = "com.clustercontrol.monitor.view.ScopeView";

    // ----- instance ե ----- //

    /** ״ƻݥå */
    private ScopeListComposite tableComposite = null;

    // ----- 󥹥ȥ饯 ----- //

    // ----- instance ᥽å ----- //

    /**
     * װơ֥ɲäޤ
     * 
     * @param parent
     *            ƤΥݥå
     * @return װơ֥륳ݥå
     */
    protected Composite createListContents(Composite parent) {
        GridLayout layout = new GridLayout(1, true);
        parent.setLayout(layout);
        layout.marginHeight = 0;
        layout.marginWidth = 0;

        this.tableComposite = new ScopeListComposite(parent, SWT.NONE);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = GridData.FILL;
        gridData.verticalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        this.tableComposite.setLayoutData(gridData);

        this.update();

        // ȿ
        IPreferenceStore store = MonitorUIPlugin.getDefault()
                .getPreferenceStore();

        this.setInterval(store
                .getInt(MonitorPreferencePage.P_SCOPE_UPDATE_CYCLE));

        if (store.getBoolean(MonitorPreferencePage.P_SCOPE_UPDATE_FLG)) {
            this.startAutoReload();
        }

        return this.tableComposite;
    }

    /**
     * 򤵤줿(Ρ)ξɽޤ
     * 
     * @param item
     *            ץĥ꡼ƥ
     */
    protected void doSelectTreeItem(FacilityTreeItem item) {
        this.tableComposite.update(item.getData().getFacilityId());
    }

    /**
     * ӥ塼򹹿ޤ
     */
    public void update() {
        FacilityTreeItem item = this.getScopeTreeComposite().getSelectItem();
        String facilityId = null;
        if (item != null) {
            facilityId = item.getData().getFacilityId();
        }

        this.tableComposite.update(facilityId);
    }
}