/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.monitor.view.action;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;

import com.clustercontrol.bean.ConfirmConstant;
import com.clustercontrol.bean.FacilityTreeItem;
import com.clustercontrol.bean.Property;
import com.clustercontrol.monitor.action.ConfirmEvent;
import com.clustercontrol.monitor.dialog.EventBatchConfirmDialog;
import com.clustercontrol.monitor.view.EventView;

/**
 * ٥ȰǧˤǧԤ󥯥饹Ǥ
 * 
 * @version 1.0.0
 * @since 1.0.0
 */
public class EventBatchConfirmAction implements IViewActionDelegate {

    //	 ----- instance ե ----- //

    private IViewPart viewPart; // ӥ塼

    // ----- instance ᥽å ----- //

    /**
     * @see org.eclipse.ui.IViewActionDelegate#init(org.eclipse.ui.IViewPart)
     */
    public void init(IViewPart viewPart) {
        this.viewPart = viewPart;
    }

    /**
     * @see org.eclipse.ui.IActionDelegate#run(org.eclipse.jface.action.IAction)
     */
    public void run(IAction action) {

        EventBatchConfirmDialog dialog = new EventBatchConfirmDialog(
                this.viewPart.getSite().getShell());

        EventView view = (EventView) this.viewPart.getAdapter(EventView.class);

        if (dialog.open() == IDialogConstants.OK_ID) {
            Property condition = dialog.getInputData();

            FacilityTreeItem item = view.getScopeTreeComposite()
                    .getSelectItem();
            String facilityId = null;
            if (item != null) {
                facilityId = item.getData().getFacilityId();
            }

            if (new ConfirmEvent().confirmBatch(ConfirmConstant.TYPE_CONFIRMED,
                    facilityId, condition)) {
                view.update();
            }
        }
    }

    /**
     * @see org.eclipse.ui.IActionDelegate#selectionChanged(org.eclipse.jface.action.IAction,
     *      org.eclipse.jface.viewers.ISelection)
     */
    public void selectionChanged(IAction action, ISelection selection) {
    }
}