/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.notify.factory;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;

import javax.ejb.CreateException;
import javax.jms.JMSException;
import javax.naming.NamingException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.accesscontrol.factory.AccessLock;
import com.clustercontrol.notify.bean.NotifyEventInfo;
import com.clustercontrol.notify.bean.NotifyInfo;
import com.clustercontrol.notify.ejb.entity.SystemNotifyEventInfoLocal;
import com.clustercontrol.notify.ejb.entity.SystemNotifyEventInfoUtil;
import com.clustercontrol.notify.ejb.entity.SystemNotifyInfoLocal;
import com.clustercontrol.notify.ejb.entity.SystemNotifyInfoUtil;
import com.clustercontrol.util.apllog.AplLogger;

/**
 * ƥξϿ饹
 *
 * @version 2.1.0
 * @since 2.1.0
 */
public class AddSystemNotify {
	
	protected static Log m_log = LogFactory.getLog( AddSystemNotify.class );
	
	/**
	 * ƥξϿ
	 * 
	 * @return Ͽ硢true
	 * @throws CreateException
	 * @throws NamingException
	 */
	@SuppressWarnings("unchecked")
	public boolean add(NotifyInfo info) throws CreateException, NamingException, JMSException {
		//å
		AccessLock.lock(AccessLock.NOTIFY);
		
//		SendQueue queue = null;
		try 
		{
			Timestamp now = new Timestamp(new Date().getTime());
			
			// ƥξ
			SystemNotifyInfoLocal notify = SystemNotifyInfoUtil.getLocalHome().create(
					info.getNotifyId(),
					info.getDescription(),
					info.getStatusFlg(),
					info.getStatusValidPeriod(),
					info.getStatusInvalidFlg(),
					info.getStatusUpdatePriority(),
					info.getEventFlg(),
					info.getInhibitionFlg(),
					info.getInhibitionFrequency(),
					info.getInhibitionPeriod(),
					now,
					now
			);
			Collection ct = notify.getSystemNotifyEventInfo();
			
			ArrayList<NotifyEventInfo> eventList = info.getNotifyEventInfo();
			ArrayList<SystemNotifyEventInfoLocal> eventLocalList = new ArrayList<SystemNotifyEventInfoLocal>();
			
			// ƥΥ٥Ⱦ
			NotifyEventInfo event = null;
			for(int index=0; index<eventList.size(); index++){
				event = (NotifyEventInfo)eventList.get(index);
				if(event != null){
					SystemNotifyEventInfoLocal local = SystemNotifyEventInfoUtil.getLocalHome().create(
							info.getNotifyId(),
							event.getPriority(),
							event.getEventNormalFlg(),
							event.getEventNormalState(),
							event.getEventInhibitionFlg(),
							event.getEventInhibitionState(),
							event.getMailFlg(),
							event.getMailAddress());
					eventLocalList.add(local);
				}
			}
			if(eventLocalList != null){
				ct.addAll(eventLocalList);
				notify.setSystemNotifyEventInfo(ct);
			}
			
//			NotifyInfoContext context = new NotifyInfoContext(NotifyInfoContext.TYPE_ADD, info.getNotifyId(), info);
//			
//			// ξ󥭥å򹹿
//			queue = new SendQueue(QueueConstant.QUEUE_NAME_LOG);
//			queue.put(context);
//			queue.terminate();
			
		} catch (CreateException e) {
			AplLogger apllog = new AplLogger("NOTIFY", "notify");
			String[] args = { info.getNotifyId() };
			apllog.put("SYS", "001", args);
			m_log.debug("add():" + e.getMessage());
			throw e;
		} catch (NamingException e) {
			AplLogger apllog = new AplLogger("NOTIFY", "notify");
			String[] args = { info.getNotifyId() };
			apllog.put("SYS", "001", args);
			m_log.debug("add():" + e.getMessage());
			throw e;
//			} catch (JMSException e) {
//			AplLogger apllog = new AplLogger("NOTIFY", "notify");
//			String[] args = { info.getNotifyId() };
//			apllog.put("SYS", "001", args);
//			m_log.debug("add():" + e.getMessage());
//			throw e;
//			}
//			finally{
//			if(queue != null){
//			queue.terminate();	
//			}
		}
		
		return true;
	}
	
}
