/*
 
 Copyright (C) 2006 NTT DATA Corporation
 
 This program is free software; you can redistribute it and/or
 Modify it under the terms of the GNU General Public License
 as published by the Free Software Foundation, version 2.
 
 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.
 
 */

package com.clustercontrol.performance.action;

import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import javax.ejb.CreateException;
import javax.ejb.RemoveException;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.widgets.Composite;
import org.jnp.interfaces.NamingContext;
import org.jnp.interfaces.NamingContextFactory;
import com.clustercontrol.ClusterControlPlugin;
import com.clustercontrol.performance.composite.RealtimeGraphComposite;
import com.clustercontrol.performance.util.CollectorItemCodeFactory;
import com.clustercontrol.performance.util.RealtimeCollectThread;
import com.clustercontrol.performance.util.RealtimeCollectorInfo;
import com.clustercontrol.performance.view.RealtimeGraphView;
import com.clustercontrol.performanceMGR.bean.CollectorItemInfo;
import com.clustercontrol.performanceMGR.ejb.session.CollectorController;
import com.clustercontrol.performanceMGR.ejb.session.CollectorControllerBean;
import com.clustercontrol.performanceMGR.ejb.session.CollectorControllerHome;
import com.clustercontrol.util.LoginManager;

/**
 * ޥ͡ȤΤԤȥ饯饹
 * 
 * @version 1.0
 * @since 1.0
 *  
 */
public class RealtimeController {
    private static int RETRYCOUNT = 1; // 顼ȯΥȥ饤

    private Collection dataCollection;

    private static RealtimeController m_instance = null;

    private CollectorController bean;

    private boolean isRun = false;
    
    private static boolean running = false;
    
    private RealtimeGraphView view;
    
    private static Composite local_parent = null;
    
	private RealtimeCollectorInfo collectorInfo = null;
    
    private Date startTimestamp;

    private Iterator itr;

    public static final String KEY_EJB_URL = "ejbUrl";

    public static final String VALUE_EJB_URL = "jnp://localhost:1099";

    /**
     * 󥹥ȥ饯 󥰥ȥȤ뤿¾Υ饹饤󥹥󥹤Ǥʤ褦ˤޤ
     */
    private RealtimeController() {
    	initialize();
    }
    private void initialize() {
    }
    
    // 󥹥󥹤֤ޤ(åӡ˼Ԥϡnull֤ޤ)
    // 󥰥ȥ
    public static synchronized RealtimeController getInstance() {
        if (m_instance == null) {
            m_instance = new RealtimeController();
            m_instance.createBean();
        }
        // åӡǤʤϡ顼ͤȤnull֤ޤ
        if (m_instance.bean == null) {
            m_instance = null;
            return null;
        } else {
            return m_instance;
        }

  }
    
    public void setCollectorInfo(RealtimeCollectorInfo collectorInfo) {
    	this.collectorInfo = collectorInfo;
    }
    
    /**
     * ޥ͡SessionBeanޤ
     *  
     */
    private void createBean() {
        try {
            // EJB֥Ȥ롣
            this.bean = getCollectorControllerHome().create();
        } catch (RemoteException e) {
            this.bean = null;
        } catch (CreateException e) {
            this.bean = null;
        } catch (NamingException e) {
            this.bean = null;
        }
    }
    
    
    /**
     * ۡ।󥿡եޤ
     * 
     * @return ۡ।󥿡ե
     * @throws NamingException
     */
    private CollectorControllerHome getCollectorControllerHome()
            throws NamingException {
        return (CollectorControllerHome) getContext().lookup(
                CollectorControllerHome.JNDI_NAME);
    }

    /**
     * NamingContextޤ
     * 
     * @return NamingContext
     * @throws NamingException
     */
    private NamingContext getContext() throws NamingException {

    	NamingContext namingContext = LoginManager.getContextManager().getNamingContext();
        
        return namingContext;
    }

    /**
     * ³URLޤ
     * 
     * @return String ³URL
     */
    private String getUrl() {

        //꥽ȥ³URL
        IPreferenceStore store = ClusterControlPlugin.getDefault()
                .getPreferenceStore();
        String url = store.getString(KEY_EJB_URL);
        if (url.compareTo("") == 0) {
            url = VALUE_EJB_URL;
        }

        return url;
    }

    /**
     * ꥢ륿򳫻Ϥޤ
     * 
     * @param interval
     * @param requestInterval
     * @param collector
     * @param itemID
     * @param facilityID
     * @param check
     * @param _subScopeNumber
     */
    public void startCollect(
    		Date timestamp,
    		int timestampId,    		
    		int interval,
    		int requestInterval,
    		RealtimeCollectThread collector,
    		//checkϺǤϻȤƤʤȽǡƤӽФȤϾfalse򥻥åȡ
    		String itemCode,
    		String itemId,
    		int deviceIndex,
    		String displayType,
    		String facilityId,
    		boolean check,
    		RealtimeGraphComposite graphComposite) {

	      ArrayList itemList = new ArrayList();
      
	      if (displayType.equals("SelectedScope") || displayType.equals("SubScope")) {
				// (subScopeNumber > 0)Υåϡդ()
				//å٤(ʤΤϥɽʤݲɽǤ褦ˤ)

	    	  itemList.add(new CollectorItemInfo(
	            		null,	// collectionID,
	            		0,		// collectorItemID,
	            		itemCode,	//collectorItemCode,
	            		deviceIndex,
	            		"",		// deviceName,
	            		false));	// thresholdFlag  // ʹƻ̵ͭ
			} else if (displayType.equals("Detail")) {
		        // ɽɬפʼܥɤ
				List itemCodeList = CollectorItemCodeFactory.getSubItemCode(itemCode);
	
	       	for (int i = 0; i < itemCodeList.size(); i++) {
	            itemList.add(new CollectorItemInfo(
	            		null,	// collectionID,
	            		i,		// collectorItemID,
	            		itemCodeList.get(i).toString(),	//collectorItemCode,
	            		deviceIndex,
	            		"",		// deviceName,
	            		false));	// thresholdFlag  // ʹƻ̵ͭ
        		}
		}
      
      
        CollectorController myBean = null;
        CollectorItemInfo[] cii = null;

        // 
        try {
            // EJB֥Ȥ롣
            myBean = getCollectorControllerHome().create();

            // 򳫻Ϥ롣
            cii = new CollectorItemInfo[itemList.size()];
            itemList.toArray(cii);
            // ǻꤹinterval(ֳ)ϡޥ͡¦Ǥμֳ֡
            // 饤ȤΥǡ¹Ԥμ¹Դֳ֤ȤʬΥư
            myBean.createRealtimeColletor(facilityId, requestInterval, itemList);
        } catch (CreateException e) {
        } catch (NamingException e) {
        } catch (RemoteException e) {
        }
        
        running = true;
        
        setStartTimestamp();
    	
      while (collectorInfo.isCurrentCollect(timestamp, timestampId)) {

    	  // 嵭create()η̡ϤǤʤǽ뤿ᡢ٥å
        	if (myBean != null) {
        		try {
                    // ιܤμͤ롣ͤ CollectedDataInfo Collection
                    if (displayType.equals("SelectedScope")) {
                			dataCollection = myBean.getRealtimeCollectedData(
            					facilityId,
//                				Integer.valueOf(itemId), // int.
                        		0,		//ɽͤ1ܤΤᡤ20
                            CollectorControllerBean.CURRENT_SCOPE);
                    } else if (displayType.equals("Detail")) {

                    		dataCollection = myBean.getRealtimeCollectedDataAll(
                        		facilityId);
                    } else if (displayType.equals("SubScope")) {
                    		dataCollection = myBean.getRealtimeCollectedData(
                        		facilityId,	// ֥פοƥס 
//                				Integer.valueOf(itemId), // int
                        		0,				// ֥ɽͤϳƥեƥǤ1ܤΤߤΤᡤ20
                            CollectorControllerBean.SUB_SCOPE);
                    	}
                    itr = dataCollection.iterator();
                } catch (RemoteException e) {
                	e.printStackTrace();
                    myBean = null;
                    itr = null;
                } // end try.
                if (itr != null) { // nullξưåǵҤ.
                		// m_timeseriesä줿Ȥߤ.
                    isRun = collector.setDataList(itr, displayType); // Ϥ
                    
                    try {
                        Thread.sleep(interval * 1000); 
                    } catch (InterruptedException e) {
                        return;
                    } // end try
                } //end if.
            } // end if.

            // whileʸΤ֤ǤsleepȡʬɽƤн褹롣
        } // end while
    }

    /**
     * run(롼פǼȤˤ֤ݤå륹ơ)Ѥޤ
     * 
     * @param _running
     */
    public void changeRunning(boolean _running) {
    	running = _running;
    }

    public static boolean isRunning() {
		return running;
	}

	public static void setRunning(boolean _running) {
		running = _running;
	}

	public Date getStartTimestamp() {
		return this.startTimestamp;
	}

	public void setStartTimestamp() {
		startTimestamp = new Date(System.currentTimeMillis());
	}
}