/*
 
 Copyright (C) 2006 NTT DATA Corporation
 
 This program is free software; you can redistribute it and/or
 Modify it under the terms of the GNU General Public License
 as published by the Free Software Foundation, version 2.
 
 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.
 
 */

package com.clustercontrol.performance.bean;

import com.clustercontrol.bean.FacilityTreeItem;
import com.clustercontrol.performanceMGR.bean.CollectorItemInfo;

/**
 * ӥǡɽDTO饹
 * 
 * @version 1.0
 * @since 1.0
 *  
 */
public class GraphProperty {

    /** ɽ */
    public static final int INVISIBLE = 0;

    /** ɽ */
    public static final int TYPE1 = 1;

    /** ɽ;ܺ */
    public static final int TYPE2 = 2;

    /** ֥ɽ */
    public static final int TYPE3 = 3;

    

    // DBMSʤɤ˳ǼȽ䤹褦ʸɽȤ.
    public static final String DISPLAY_NO = "DISPLAY_NO";  // NonDisplay
    
    public static final String DISPLAY_SELECTED_SCOPE = "DISPLAY_NO";  // SelectedScope

    public static final String DISPLAY_SCOPE_DETAILS = "DISPLAY_SCOPE_DETAILS";  // Detail

    public static final String DISPLAY_SUBSCOPE = "DISPLAY_SUBSCOPE";  // SubScope
    
    // վܺɽβݤȽ.stringboolean׸Ƥ.
    public static final String BREAKDOWN_OK = "BREAKDOWN_OK";
    public static final String BREAKDOWN_NG = "BREAKDOWN_NG";
    
    
    
    
    
    private CollectorItemInfo targetItem; // ɽоݹ

    FacilityTreeItem targetFacility; // ɽоݥեƥ

    int graphType; // ɽˡ

    /**
     * 󥹥ȥ饯
     * 
     * @param targetFacility
     * @param targetItem
     * @param graphType
     */
    public GraphProperty(FacilityTreeItem targetFacility,
            CollectorItemInfo targetItem, int graphType) {

        this.targetFacility = targetFacility;
        this.targetItem = targetItem;
        this.graphType = graphType;
    }

    /**
     * graphType ޤ
     * 
     * @return graphType
     */
    public int getGraphType() {
        return graphType;
    }

    /**
     * graphType ꤷޤ
     * 
     * @param graphType
     */
    public void setGraphType(int graphType) {
        this.graphType = graphType;
    }

    /**
     * targetFacility ޤ
     * 
     * @return targetFacility
     */
    public FacilityTreeItem getTargetFacility() {
        return targetFacility;
    }

    /**
     * targetFacility ꤷޤ
     * 
     * @param targetFacility
     */
    public void setTargetFacility(FacilityTreeItem targetFacility) {
        this.targetFacility = (FacilityTreeItem) targetFacility;
    }

    /**
     * targetItem ޤ
     * 
     * @return targetItem
     */
    public CollectorItemInfo getTargetItem() {
        return targetItem;
    }

    /**
     * targetItem ꤷޤ
     * 
     * @param targetItem
     */
    public void setTargetItem(CollectorItemInfo targetItem) {
        this.targetItem = targetItem;
    }
}