/*

 Copyright (C) 2006 NTT DATA Corporation

 This program is free software; you can redistribute it and/or
 Modify it under the terms of the GNU General Public License
 as published by the Free Software Foundation, version 2.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 */

package com.clustercontrol.performance.composite;

import java.util.ArrayList;

import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Table;

import com.clustercontrol.bean.StatusConstant;
import com.clustercontrol.composite.CommonTableViewer;
import com.clustercontrol.performance.action.RecordController;
import com.clustercontrol.performanceMGR.bean.CollectionTabelDefine;

/**
 * ݥåȥ饹Ǥ
 * 
 * @version 1.0
 * @since 1.0
 */
public class CollectionListComposite extends Composite {

    //	 ----- instance ե ----- //

    /** ơ֥ӥ塼 */
    private CommonTableViewer tableViewer = null;

    // ----- 󥹥ȥ饯 ----- //

    /**
     * 󥹥󥹤֤ޤ
     * 
     * @param parent
     *            ƤΥݥå
     * @param style
     *            
     */
    public CollectionListComposite(Composite parent, int style) {
        super(parent, style);
        initialize();
    }

    // ----- instance ᥽å ----- //

    private void initialize() {
        GridLayout layout = new GridLayout(5, true);
        this.setLayout(layout);
        layout.marginHeight = 0;
        layout.marginWidth = 0;

        Table table = new Table(this, SWT.H_SCROLL | SWT.V_SCROLL
                | SWT.FULL_SELECTION | SWT.SINGLE);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);

        GridData gridData = new GridData();
        gridData.horizontalAlignment = GridData.FILL;
        gridData.verticalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalSpan = 5;
        table.setLayoutData(gridData);

        RecordController collector = RecordController.getInstance();
        // ޥ͡㤫饪֥ȤǤ
        ArrayList list = collector.getCollectionListTableDefine();
        
        // ơ֥ӥ塼κ
        this.tableViewer = new CommonTableViewer(table);
        this.tableViewer.createTableColumn(
        		list,
                CollectionTabelDefine.SORT_COLUMN_INDEX,
                CollectionTabelDefine.SORT_ORDER);
    }

    /**
     * tableViewer֤ޤ
     * 
     * @return tableViewer
     */
    public CommonTableViewer getTableViewer() {
        return this.tableViewer;
    }

    /**
     * ӥ塼򹹿ޤ
     * 
     */
    public void update() {
        super.update();

        RecordController collector = RecordController.getInstance();

        if(collector != null){
        	tableViewer.setInput(collector.getCollectionList());
        }
    }
    
    /**
     * 򤵤ƤID֤ޤ
     *
     * @return 򤵤ƤCollectorID
     */
    public String getSelectedID() {
    	Table table = tableViewer.getTable();
    	
    	int selectionIndex = table.getSelectionIndex();
    	
    	// 򤵤Ƥʤnull֤
    	if(selectionIndex < 0){
    		return null;
    	}
    	
        return table.getItem(selectionIndex).getText(2);
    }
    
    /**
     * 򤵤Ƥμ¹Ծ֤֤ޤ
     *
     * @return 򤵤ƤCollectorID
     */
    public int getRunStatus() {
    	Table table = tableViewer.getTable();
    	String statusStr = table.getItem(table.getSelectionIndex()).getText(0);
        return StatusConstant.stringToType(statusStr);
    }
}