/*
 
 Copyright (C) 2006 NTT DATA Corporation
 
 This program is free software; you can redistribute it and/or
 Modify it under the terms of the GNU General Public License
 as published by the Free Software Foundation, version 2.
 
 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.
 
 */

package com.clustercontrol.performance.composite;

import java.awt.Color;
import java.awt.Frame;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.SWT;
import org.eclipse.swt.awt.SWT_AWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYAreaRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.data.time.Second;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesCollection;
import org.jfree.data.xy.XYDataset;

import com.clustercontrol.performance.bean.GraphConstant;
import com.clustercontrol.performance.util.Messages;
import com.clustercontrol.performance.util.RealtimeCollectorInfo;
import com.clustercontrol.performance.util.RealtimeCollectorItemInfo;
import com.clustercontrol.performance.util.CollectorItemCodeFactory;

/**
 * ꥢ륿॰ɽԤView륳ݥåȥ饹.
 * դ֤Ȥʤcomposite.
 * @version 1.0
 * @since 1.0
 */
public class RealtimeGraphComposite extends Composite {
	// դ֤composite.տʬ.
	private Composite graphComposite[] = null;
    
	public TimeSeries m_timeseries[];

    public ChartPanel chartPanel = null;
    
    private Label infoLabel;
    
    private boolean isCollect = false; 
    
	private RealtimeCollectorInfo collectorInfo = null;
    
	private RealtimeCollectorItemInfo collectorItemInfo = null;
	
	// ǡɽxΥѹǤͤˤ.
//    private boolean isXRangeAuto = true;
    
    // դɽץåȿ򥰥դƺѹǤ褦ˤ뤿.
    private ValueAxis valueaxis = null;
    private int graphPlotNum = 0;
    private int interval = 0;
    private JFreeChart jfreechart[] = null; // c -> C
    
    private Frame graphFrame = null;
    /**
     * 󥹥󥹤֤ޤ
     * 
     * @param parent
     *            ƤΥݥå
     * @param style
     *              e.g. SWT.EMBEDDED
     */
    public RealtimeGraphComposite(Composite parent, int style) {
        super(parent, style);
        initialize();
    }

    // ----- instance ᥽å ----- //

    private void initialize() {
    	graphComposite = new Composite[4];
    	
    	jfreechart = new JFreeChart[4];
    }
    
    /**
     * graphComposite˥դޤ
     * @param itemCode
     * @param subScopeNum
     * @param displayType
     * @param interval
     */
    public void addGraph(int graphId, String itemCode, String deviceName, int subScopeNum, String displayType, int interval, boolean isXRangeAuto, int graphPlotNum) {
        
    	// 1󥹥󥹤ʣդΤѿ򥰥պñ̤ǽ.
    	isCollect = false;
    	
    	this.graphPlotNum = graphPlotNum;
    	this.interval = interval;
    	
    	if (! displayType.equals("NonDisplay")) {
			createGraphComposite(graphId, itemCode, deviceName, subScopeNum, displayType, interval, isXRangeAuto, graphPlotNum);
   		}
    	// NonDisplayǤisCollect = falseΤޤ.
   }
      
    private void createGraphComposite(int graphId, String itemCode, String deviceName, int subScopeNum, String displayType, int interval, boolean isXRangeAuto, int graphPlotNum) {

    	if (! collectorItemInfo.hasDevice(graphId)) {
    		graphComposite[graphId] = new Composite(this, SWT.NULL);

 			infoLabel = new Label(graphComposite[graphId],SWT.CENTER);  // SWT.CENTER.
 			infoLabel.setText(Messages.getString("DEVICE") // "ǥХ"
 					+ " \"" + collectorItemInfo.getDeviceName(graphId)+ "\" " 
 					+ Messages.getString("NOT_EXIST"));  // "¸ߤʤΤɽޤ"
    	} else if (displayType.equals("SubScope") && subScopeNum == 0) {
        	// ֥֥ɽġ֥פ⤿ʤ׾ϡ褻
        	// ֥֥פ¸ߤޤפɽ롣(ȤǼ)

    		graphComposite[graphId] = new Composite(this, SWT.NULL);

     			infoLabel = new Label(graphComposite[graphId],SWT.CENTER);  // SWT.CENTER.
     			infoLabel.setText(Messages.getString("NOT_EXIST_SUBSCOPE"));  // "֥פ¸ߤʤΤɽޤ."
		} else if (displayType.equals("SubScope") && subScopeNum > 10) {
				
			// ɽʤ(Ի)
			// ٥ǡ֥׿10ĶƤΤɽʤ׻ݤɽ롣
			// ϲ10ǾꤷƤ롣Ȥѿ()λ롣
			
			graphComposite[graphId] = new Composite(this, SWT.NULL);
			
 			infoLabel = new Label(graphComposite[graphId],SWT.NULL);
 			infoLabel.setText(Messages.getString("MSG_SUB_SCOPE_COUNTS_OVER_10"));  // "֥פ10Ķ¸ߤΤɽޤ."

 		} else {
 			graphComposite[graphId] = new Composite(this, SWT.EMBEDDED);

 			setJFreeChart(graphId, interval, displayType, itemCode, deviceName, isXRangeAuto, graphPlotNum);
        	
        	// ѴԤʤäƤΤǡղ̤ưŪɽ()ʤ?
        	graphFrame = SWT_AWT.new_Frame(graphComposite[graphId]);
        	graphFrame.add(chartPanel);

        	isCollect = true;
 		}
		
		GridData graphGridData = new GridData();
		graphGridData.horizontalAlignment = GridData.FILL;
		graphGridData.verticalAlignment = GridData.FILL;
		graphGridData.grabExcessHorizontalSpace = true;
		graphGridData.grabExcessVerticalSpace = true;
		
		GridLayout graphLayout = new GridLayout(1, true);
		graphComposite[graphId].setLayout(graphLayout);
		graphLayout.marginHeight = 0;
		graphLayout.marginWidth = 0;	
        
		graphComposite[graphId].setLayoutData(graphGridData);  //쥤ȤλȿǤ롣
    }
    
    
    /**
     * ɽǡѴܾ
     * <p>
     * ɤΤ褦ʾ򥰥ɽ뤫ξƤޤȤ
     * ԻͤǤϥåɤޤǤƤ뤬ϸľ;Ϥꡣ...ѹʬΥ
     * </p>
     * @param interval
     *            ɽֳ()
     * @param displayType
     *            ɽ
     * @param itemCode
     *            ɽ󥳡
     * @return
     *			 ʤ
	 * @see ʤ
     */
    private void setJFreeChart(int graphId, int interval, String displayType, String itemCode, String deviceName, boolean isXRangeAuto, int graphPlotNum) {
    	  //ܽϡʲΥå̤äȤȤƽ롣
    	  // (1) ֥ɽͤǤϡ֥׿1ʾǤ뤳ȡ
    	  // (2) ׾ܺ٤ǤϡitemCode1ʾǤ뤳ȡ
    	  // (3) ɽ륰()ʲ(2ȯʳǤ10)Ǥ뤳ȡ
    	
    	  // դɽ̾Τݻ뤿Ѥ롣
    	  List graphObjectList = new ArrayList();
    	  
    	  if (displayType.equals("SelectedScope")) {
    		  	// ɽͤǤѤʤߡitemCode򥻥åȤƤ
    		  	graphObjectList.add(0,itemCode);
    	  } else if (displayType.equals("SubScope")) {
	        
				// facilityId10(2ȯǤλ)Ķ뤫ݤΥå
				// ǤϹԤʤʤ¦椹롣
				graphObjectList = collectorInfo.getSubScopeFacilityName();
      	} else if (displayType.equals("Detail")) {
            // ɽɬפʼܥɤ
      		graphObjectList = CollectorItemCodeFactory.getSubItemCode(itemCode);
      	}
		  
		  // timeseries(դɬ)ʪ(դɽѰ)Ѱդ롣
		  TimeSeriesCollection timeSeriesCollection = new TimeSeriesCollection();
		  // ɽѤTimeSeries򥰥
		  int graphNum = 0;
		  if (graphObjectList.size() > 10) {
			  // ֥׿10ĶϡfacilityIDξƬ10Ĥ򥰥ɽоݤȤϿ.
			  // âԻͤǤϡ10ĶȤϥդɽʤᡢʳ10Ķ뤳ȤϤʤ.
			  graphNum = 10;
		  } else {
			  graphNum = graphObjectList.size();
		  }
		  
		  m_timeseries = new TimeSeries[graphNum];
		  String displayNoteName = null;
		  
		  // ֥ɽɽǤϡ夫ɲäΤɽ()μ¦ɽ뤳ȤαդΤȡ
		  if (graphNum > 0) {
	         for (int i = 0; i < graphNum; i++) {
	    	  	if (displayType.equals("SubScope")) {
	    	  		displayNoteName = graphObjectList.get(i).toString();
	          	} else if (displayType.equals("Detail")) {
	          		// itemCode̾Τ֤롣
	          		displayNoteName =CollectorItemCodeFactory.getItemName(graphObjectList.get(i).toString());
	    	  	} else if (displayType.equals("SelectedScope")) {
	    	  		// ɽͤǤѤʤߡitemCode򥻥åȤƤ
	    	  		displayNoteName = graphObjectList.get(i).toString();
	    	  	}
				m_timeseries[i] = new TimeSeries(displayNoteName, Second.class);
				
				// դκץåȿ
				m_timeseries[i].setMaximumItemCount(GraphConstant.REALTIME_GRAPH_MAX_PLOT);
				
			 	timeSeriesCollection.addSeries(m_timeseries[i]);
	         }
	     }
		  chartPanel = new ChartPanel(createChart(graphId, itemCode, deviceName, displayType, timeSeriesCollection, interval,isXRangeAuto, graphPlotNum));
      }
      
      // ChartΤζ̽(ɽ͡ɽ;ܺ١֥ɽͤζ̽)
      private JFreeChart createChart(int graphId, String itemCode, String deviceName, String displayType, XYDataset xydataset,
    		  int interval, boolean isXRangeAuto, int graphPlotNum) {
    	  //դθФɽη
		String displayTypeName = Messages.getString("NULL");	//դθФλ
		boolean displayNote = false;	//(ƥɽǡ)
		if (displayType.equals("SelectedScope")) {
        	displayTypeName = Messages.getString("SCOPE_REPRESENTING_VALUE");
		} else if (displayType.equals("Detail")) {
        	displayTypeName = Messages.getString("DETAIL_SCOPE_REPRESENTING_VALUE");
        	displayNote = true;
		} else if (displayType.equals("SubScope")) {
        	displayTypeName = Messages.getString("SUB_SCOPE_REP_VAL");
        	// ץĥ꡼β¤ޤǤɽǻн褹롣
        	displayNote = true;
		}
    	
		String displayName = null;
		
		displayName = CollectorItemCodeFactory.getFullItemName(itemCode, deviceName) + " " + displayTypeName;
		
    	//ɽΰ(chart)κ
    	jfreechart[graphId] = ChartFactory.createTimeSeriesChart(
			displayName,
			Messages.getString("TIME"),
			CollectorItemCodeFactory.getMeasure(itemCode),
			xydataset,
			displayNote, //ɽ
			true,
			false);
    	
        XYPlot xyplot = jfreechart[graphId].getXYPlot();
        
        
        // privateƳǤ褦ˤɽΥդưŪǤ?
        valueaxis = xyplot.getDomainAxis(); //ΤgetƤΤ.
        valueaxis.setAutoRange(true);	// öautoRangeˤƤ.
        
        if  (! isXRangeAuto) {
	        valueaxis.setFixedAutoRange(interval * 1000D * graphPlotNum);//xɽ֡mS 12000msec=12sec
        }
        valueaxis = xyplot.getRangeAxis();

        if (CollectorItemCodeFactory.isRangeFixed(itemCode)) {
        	valueaxis.setRange(0.0D, 100D); //yΥ󥸤(ͤϥȥ)
        }
        if (displayType.equals("Detail")) {	
        	XYAreaRenderer xyRenderer = new XYAreaRenderer();
	    	xyplot.setRenderer(xyRenderer);    	//դѤߤɽˤ롣(ͤ)
        }	else if (displayType.equals("SubScope")) {
        	// դ迧ꤹ
          XYItemRenderer xyRenderer = xyplot.getRenderer();
          xyRenderer.setSeriesPaint(0, Color.BLACK);
          xyRenderer.setSeriesPaint(1, Color.BLUE);
          xyRenderer.setSeriesPaint(2, Color.GREEN);
          xyRenderer.setSeriesPaint(3, Color.PINK);
          xyRenderer.setSeriesPaint(4, Color.CYAN);
          xyRenderer.setSeriesPaint(5, Color.LIGHT_GRAY);
          xyRenderer.setSeriesPaint(6, Color.MAGENTA);
          xyRenderer.setSeriesPaint(7, Color.ORANGE);
          xyRenderer.setSeriesPaint(8, Color.YELLOW);
          xyRenderer.setSeriesPaint(9, Color.GRAY);
        }
        return jfreechart[graphId];
      }    
      
      public boolean isCollect() {
    	  return isCollect;
      }
      public void setCollectorInfo(RealtimeCollectorInfo collectorInfo) {
    		this.collectorInfo = collectorInfo;
    	}

    	public void setCollectorItemInfo(RealtimeCollectorItemInfo collectorItemInfo) {
    		this.collectorItemInfo = collectorItemInfo;
    	}
    	
	public void setValueaxisRange(double graphPlotNum, int interval) {
		
		for (int i = 0; i < collectorInfo.getGraphNum(); i++) {
			if (collectorItemInfo.isCollect(i)) {
				// öɬפ.
				if (jfreechart[i] != null) {
					XYPlot xyplot = jfreechart[i].getXYPlot();
			        valueaxis = xyplot.getDomainAxis();

					if (graphPlotNum != (valueaxis.getFixedAutoRange() * interval * 1000D)) {// graphPlotNumѹ.
						if (graphPlotNum == 0) {
							valueaxis.setAutoRange(true);	// ޤưĴˤʤʤ.
						} else if (graphPlotNum > 0 && interval == this.interval) {
							valueaxis.setFixedAutoRange(interval * 1000D * graphPlotNum);//xɽ֡mS 12000msec=12sec
						}
					} else if (interval != this.interval && interval > 0) {	// intervalѹ.
						valueaxis.setFixedAutoRange(interval * 1000D * graphPlotNum);//xɽ֡mS 12000msec=12sec
						this.interval = interval; 
					}
				}
			}
		}
		
	}
}