/*
 
 Copyright (C) 2006 NTT DATA Corporation
 
 This program is free software; you can redistribute it and/or
 Modify it under the terms of the GNU General Public License
 as published by the Free Software Foundation, version 2.
 
 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.
 
 */

package com.clustercontrol.performance.composite;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Listener;

import com.clustercontrol.performance.util.CollectorItemCodeFactory;
import com.clustercontrol.performance.util.Messages;
import com.clustercontrol.performance.util.RealtimeCollectorItemInfo;

/**
 * PropaertyDailogμtabʬΥݥåȤ륯饹
 * 
 * @version 1.0
 * @since 1.0
 */

// GroupǤΥ֥饹ϤߤȤʤ.compositeñ̤Τ.
public class RecordSetItemComposite extends Composite {

    private Combo combo = null;

    private int arrayNum;
    
    private Group group;
    
    private Button radioButton00;

    private Button radioButton01;

    private Button radioButton02;

    private Button radioButton03;
	
	private RealtimeCollectorItemInfo collectorItemInfo = null;
    
    /**
     * 󥹥ȥ饯
     * 
     * @param parent
     * @param style
     * @param _property
     */
        public RecordSetItemComposite(Composite parent, int style) {
            super(parent, style);
    }

    
    public void update(int i) {
        // ϥǡܤǽˤ뤳Ȥˤ롣
    	String displayType = null;
        boolean isRadioButton0 = false;
        boolean isRadioButton1 = false;
        boolean isRadioButton2 = false;
        boolean isRadioButton3 = false;

        // ޤ
		displayType =  collectorItemInfo.getDisplayTypeForDialog(i);
		if (displayType.equals("NonDisplay")) {
			isRadioButton0 = true;
		} else if (displayType.equals("SelectedScope")) {
			isRadioButton1 = true;
		} else if (displayType.equals("Detail")) {
			isRadioButton2 = true;
		} else if (displayType.equals("SubScope")) {
			isRadioButton3 = true;
		}
		
		// 롼פ
    	String itemCode = collectorItemInfo.getItemCodeForDialog(i);
    	group = new Group(this, SWT.NONE);
    	GridData gridDataGroup = new GridData(GridData.FILL_HORIZONTAL);
    	group.setLayoutData(gridDataGroup);
    	group.setText(Messages.getString("GRAPH_ITEM") + (i + 1));

        
    	GridLayout gridLayout00 = new GridLayout();
    	gridLayout00.numColumns = 3; //
    	group.setLayout(gridLayout00);
    	

    	// Ϥ饸ܥβսȥ󥿡ХβսȤǰۤʤ롣ľ.
    	
    	//combo
    	//     ꥹʸԽԲĤˤ뤿
    	//    SWT.READ_ONLY(ӥåȱ黻ʳλˡĤ餺).
        combo = new Combo(group, SWT.NONE | SWT.READ_ONLY);
        GridData gridDataCombo = new GridData(GridData.VERTICAL_ALIGN_BEGINNING);
        gridDataCombo.horizontalSpan = 3; //3ʬ
        combo.setLayoutData(gridDataCombo);
        
    	arrayNum = i;

    	for (int j = 0; j < collectorItemInfo.getItemNumForCollector() ; j++) {
    	        combo.add(CollectorItemCodeFactory.getFullItemName(
    	        		collectorItemInfo.getItemCodeForCollector(j),
    	        		collectorItemInfo.getDeviceNameForCollector(j)));
    	}
    	
    	int collectorComboSelectIndex = 0; 

    	if (collectorItemInfo.getItemIdForDialog(i) != null) {
    		collectorComboSelectIndex = Integer.parseInt(collectorItemInfo.getItemIdForDialog(i));
    	} 
       // 򤵤ƤȤϤɬפ.
       combo.select(collectorComboSelectIndex); //.λ꤬ʤֻʤפ򤬲ǽȤʤäƤޤ.
       combo.addSelectionListener(new SelectionListener() {
			// ̾ʤ饹ΥեѿȤݻ
			int k = arrayNum;
           public void widgetDefaultSelected(SelectionEvent e) {
            }
           public void widgetSelected(SelectionEvent e) {
        	   int selectionIndex = combo.getSelectionIndex();
               // ܺɽǽݤå
        	   // ܺɽǽݤĴ١򤵤ƤܤܺɽǤʤܤξϡ
        	   // 饸ܥΡɾܺ٥աɤԲĤȤ롣

        	   // ɽɬפʼܥɤ
        	   String itemCode = collectorItemInfo.getItemCodeForCollector(selectionIndex);
        	   String deviceIndex = collectorItemInfo.getIndexForCollector(selectionIndex);
	           
	           if (! collectorItemInfo.getItemDetailedForCollector(selectionIndex)) { // ܺɽǽǤʤ.
		           radioButton02.setEnabled(false);
		           collectorItemInfo.isItemDetailedForDialog(k, false);
		           if (radioButton02.getSelection()) {
				       	radioButton02.setSelection(false);
				       	radioButton01.setSelection(true);
				       	collectorItemInfo.setDisplayTypeForDialog(k,"SelectedScope");
		           }
	           } else {
		           if (! radioButton02.getEnabled()) {
		        	   radioButton02.setEnabled(true); // ˾ܺɽ򤵤Ƥ֤᤹.
				   collectorItemInfo.isItemDetailedForDialog(k, true);
		           }
	           	}
	           
       		String deviceName = collectorItemInfo.getDeviceNameForCollector(selectionIndex);
       		
	       	collectorItemInfo.setItemCodeForDialog(k,itemCode);
	       	collectorItemInfo.setDeviceIndexForDialog(k,deviceIndex);
	       	collectorItemInfo.setDeviceNameForDialog(k, deviceName);
	       	collectorItemInfo.setItemIdForDialog(k, Integer.toString(selectionIndex));
	       	collectorItemInfo.setHasDevice(k, true);
           }
        });
       
       // 饸ܥ(̡)
       GridData gridData00;
       
    	// 饸ܥ(ɽ)
    	radioButton00 = new Button(group, SWT.RADIO);
    	radioButton00.setText(Messages.getString("HIDDEN"));
    	gridData00 = new GridData(GridData.FILL_VERTICAL);
    	gridData00.horizontalSpan = 3; //ʬ
    	radioButton00.setLayoutData(gridData00);
    	radioButton00.setSelection(isRadioButton0);
    	arrayNum = i;
		radioButton00.addListener(SWT.Selection, new Listener() {
			// ̾ʤ饹ΥեѿȤݻ
			int j = arrayNum;
			public void handleEvent(Event event) {
				collectorItemInfo.setDisplayTypeForDialog(j,"NonDisplay");
		    }
		});
        // 饸ܥ(ɽ)
    	radioButton01 = new Button(group, SWT.RADIO);
    	radioButton01.setText(Messages.getString("SCOPE_REPRESENTING_VALUE"));
    	gridData00 = new GridData(GridData.FILL_VERTICAL);
    	radioButton01.setLayoutData(gridData00);
    	radioButton01.setSelection(isRadioButton1);
		radioButton01.addListener(SWT.Selection, new Listener() {
			// ̾ʤ饹ΥեѿȤݻ
			int j = arrayNum;
			public void handleEvent(Event event) {
				collectorItemInfo.setDisplayTypeForDialog(j,"SelectedScope");
		    }
		});
        // 饸ܥ(ɽ;ܺ)
    	radioButton02 = new Button(group, SWT.RADIO);
    	radioButton02.setText(Messages.getString("DETAIL_SCOPE_REPRESENTING_VALUE"));
    	gridData00 = new GridData(GridData.FILL_VERTICAL);
    	radioButton02.setLayoutData(gridData00);
    	radioButton02.setSelection(isRadioButton2);
	    if (! collectorItemInfo.getItemDetailed(i)) { // ܺɽǽǤʤ.
	           radioButton02.setEnabled(false);
	    }
		radioButton02.addListener(SWT.Selection, new Listener() {
			// ̾ʤ饹ΥեѿȤݻ
			int j = arrayNum;
			public void handleEvent(Event event) {
				collectorItemInfo.setDisplayTypeForDialog(j,"Detail");
		    }
		});
    	// 饸ܥ(֥ɽ)
    	radioButton03 = new Button(group, SWT.RADIO);
    	radioButton03.setText(Messages.getString("SUB_SCOPE_REP_VAL"));
    	gridData00 = new GridData(GridData.FILL_VERTICAL);
    	radioButton03.setLayoutData(gridData00);
    	radioButton03.setSelection(isRadioButton3);
		radioButton03.addListener(SWT.Selection, new Listener() {
			// ͤ򥪥֥Ǹݻ뤿̾ʤ饹Υեѿ˥åȤ.
			int j = arrayNum;
			public void handleEvent(Event event) {
				collectorItemInfo.setDisplayTypeForDialog(j,"SubScope");
		    }
		});
	    // 饸ܥ(:)
    }
    public void setCollectorItemInfo(RealtimeCollectorItemInfo collectorItemInfo) {
    	this.collectorItemInfo = collectorItemInfo;
    }
}

