/*
 
 Copyright (C) 2006 NTT DATA Corporation
 
 This program is free software; you can redistribute it and/or
 Modify it under the terms of the GNU General Public License
 as published by the Free Software Foundation, version 2.
 
 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.
 
 */

package com.clustercontrol.performance.composite.tree;

import java.util.Iterator;
import java.util.ArrayList;

import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

import com.clustercontrol.performance.util.CollectorItemCodeFactory;
import com.clustercontrol.performanceMGR.bean.CollectorItemInfo;
import com.clustercontrol.performanceMGR.bean.DeviceData;
import com.clustercontrol.performanceMGR.util.code.CollectorItemCategoryInfo;
import com.clustercontrol.performanceMGR.util.code.CollectorItemCodeInfo;
import com.clustercontrol.performanceMGR.util.code.CollectorItemTreeItem;

/**
 * ܤΥĥ꡼ڥɽ륳ݥåȥ饹Ǥ
 *
 */
public class CollectorTreeComposite extends Composite {

//	 ----- instance ե ----- //
	
	
	/** ĥ꡼ӥ塼 */
	private TreeViewer treeViewer = null;
	
	/** ĥ꡼Υƥ */
	private CollectorItemTreeItem[] treeItem;

	/** åƤܤݻ */
	private ArrayList<CollectorItemInfo> itemList;
	
	/** ID */
	private String m_collectorID = null;
	
	/** ID */
	private int collectorItemID = 0;
	
	/** ٥ȥꥹ */
	Listener subItemCheckListener;
	Listener ItemCheckDisableListener;
	
// ----- 󥹥ȥ饯 ----- //
	
	public CollectorTreeComposite(
			Composite parent, 
			int style, 
			String facilityId,
			String collectorId) {
		super(parent, style);
		
		this.itemList = new ArrayList<CollectorItemInfo>();
		
		/** եƥID򥳥ݥåȤξȤ */
		this.setData("FacilityId", facilityId); 
		
		this.m_collectorID = collectorId;
		
		this.createContents();
	}
	
	/**
	 * ΥݥåȤѤĥ꡼ӥ塼֤ޤ
	 * 
	 * @return ĥ꡼ӥ塼
	 */
	private TreeViewer getTreeViewer() {
		return this.treeViewer;
	}
	
	/**
	 * ΥݥåȤѤĥ꡼֤ޤ
	 * 
	 * @return ĥ꡼
	 */
	private Tree getTree() {
		return this.treeViewer.getTree();
	}
	
	/**
	 * ݥåȤޤ
	 */
	protected void createContents() {
		
		// ݥåȤΥ쥤
		GridLayout layout = new GridLayout(1, true);
		layout.marginHeight = 0;
		layout.marginWidth = 0;
		this.setLayout(layout);

		// ĥ꡼
		Tree tree = new Tree(this, SWT.SINGLE | SWT.BORDER | SWT.CHECK);
		
		// ĥ꡼Υ쥤ȥǡ
		GridData layoutData = new GridData();
		layoutData.horizontalAlignment = GridData.FILL;
		layoutData.verticalAlignment = GridData.FILL;
		layoutData.grabExcessHorizontalSpace = true;
		layoutData.grabExcessVerticalSpace = true;
		tree.setLayoutData(layoutData);

		// ĥ꡼ӥ塼
		this.treeViewer = new TreeViewer(tree);
		
		// ĥ꡼ӥ塼
		this.treeViewer.setContentProvider(new CollectorTreeContentProvider());
		this.treeViewer.setLabelProvider(new CollectorTreeLabelProvider());
		
		// ٥ȥꥹʤ
		setListener(true);
		
		// ɽޤ
		this.update();
	}
	
	/**
	 * GUIǥåƤܤξ֤եѿitemListȿǤޤ
	 * 
	 * @param treeItems
	 */
	private void treeToList(TreeItem[] treeItems){		
		for(int i=0; i<treeItems.length; i++){
			if(treeItems[i] != null){			
				if(treeItems[i].getChecked()){
					// ĥ꡼ݻƤǡ
					CollectorItemTreeItem treeItem = (CollectorItemTreeItem)treeItems[i].getData();
					Object obj = treeItem.getData();

					// ĥ꡼ΥƥबݻƤǡƥ꤫ܤȽꤹ롣
					if(obj instanceof CollectorItemCategoryInfo){
						// ܤƥξϤʤˤ⤷ʤ
					} else if (obj instanceof CollectorItemCodeInfo) {
						CollectorItemCodeInfo codeInfo = (CollectorItemCodeInfo)obj;
						
						int deviceIndex = 0;  // ǥХñ̤μǤʤ0
						String deviceName = null;
						
						if(treeItem.getDeviceData() != null){
							deviceIndex = treeItem.getDeviceData().getDeviceIndex();
							deviceName = treeItem.getDeviceData().getDeviceName();
						}
						
						CollectorItemInfo itemInfo = new CollectorItemInfo(
								m_collectorID,  // ID
								collectorItemID,  // ID
								codeInfo.getCode(),  // ܥ
								deviceIndex,   // ǥХΥǥå
								deviceName,  // ǥХ̾
								false  // ͥե饰
						);
						
						this.itemList.add(itemInfo);

						// ID򥤥󥯥
						collectorItemID++;
					}
				}
				
				// ǤƵŪ˽
				TreeItem[] children = treeItems[i].getItems();
				if(children != null){
					treeToList(children);
				}
			}
		}
	}
	
	private void setChecked(TreeItem treeItem, boolean checked){
		treeItem.setExpanded(true);  // ǤŸ
		treeItem.setChecked(checked);  // å

		TreeItem[] children = treeItem.getItems();
		for(int i=0; i<children.length; i++){
			if(children[i] != null){
				setChecked(children[i], checked);
			}
		}
	}
	
	private boolean setCheckedTreeItem(TreeItem[] treeItems){
		boolean checked = false;
		
		for(int i=0; i<treeItems.length; i++){
			if(treeItems[i] != null){				
				// ܥĥ꡼ݻƤǡ
				CollectorItemTreeItem collectorTreeInfo = (CollectorItemTreeItem)treeItems[i].getData();
				Object obj = collectorTreeInfo.getData();
				
				// ĥ꡼ΥƥबݻƤǡƥ꤫ܤȽꤹ
				if(obj instanceof CollectorItemCategoryInfo){
					// ܤƥξϥåϤ
					treeItems[i].setChecked(false);
				} else if (obj instanceof CollectorItemCodeInfo) {
					Iterator itr = this.itemList.iterator();
					
					// ܥꥹȤƤǤˤĤưפΤʤĴ٤
					while(itr.hasNext()){
						CollectorItemInfo itemInfo = (CollectorItemInfo)itr.next();

						if(((CollectorItemCodeInfo)obj).getCode().equals(itemInfo.getCollectorItemCode())){
							DeviceData deviceData = collectorTreeInfo.getDeviceData();

							// ǥХñ̤Ǥʤܤξ
							if(deviceData == null){
								treeItems[i].setChecked(true);
								checked = true;
							} else {	// ǥХñ̤ιܤξϥǥХ̾ޤǰפå
								if(deviceData.getDeviceName().equals(itemInfo.getDeviceName())){
									treeItems[i].setChecked(true);
									checked = true;
								}
							}
						}
					}
				}		
				// ǤƵŪ˽
				TreeItem[] children = treeItems[i].getItems();
				if(children != null){
					// ǤŸޤ
					treeItems[i].setExpanded(true);
					
					// ǤƵŪĴټꤵƤΤϥå
					// 1ĤǤåͤ true Ȥʤ롣
					if(setCheckedTreeItem(children)){
						checked = true;
					} else {
						// ǤĤޤ
						treeItems[i].setExpanded(false);
					}
				}
			}
		}
		
		return checked;
	}
	
	/**
	 * ӥ塼ɽƤ򹹿ޤ
	 */
	public void update() {
		String facilityId = (String)this.getData("FacilityId");
		
		// 򤵤ƤܥꥹȤΥԡ
		ArrayList<CollectorItemInfo> buffItemList = new ArrayList<CollectorItemInfo>();
		Iterator<CollectorItemInfo> itr = this.itemList.iterator();
		while(itr.hasNext()){
			buffItemList.add(itr.next());
		}
		
		this.treeItem = CollectorItemCodeFactory.getCollectorTree(facilityId, m_collectorID);
		
		// ĥ꡼ꤹȸݻƤܥɥꥹȤ⥯ꥢ
		this.treeViewer.setInput(this.treeItem);
		
		// öɽˤޤ
		this.setVisible(false);
		
		// Ÿ뤳ȤǡTreeViewerƤǤޤ
		this.treeViewer.expandAll();    // ĥ꡼ˤޤ
		this.treeViewer.collapseAll();  // ĥ꡼Ĥޤ
		
		// ɽޤ
		this.setVisible(true);
		
		if(buffItemList.size() != 0){
			// 򤵤ƤΤܥĥ꡼ȿǤ
			this.setItemList(buffItemList);

			// ꥹȤ˴ޤޤƤΤǿܥĥ꡼˴ޤޤʤΤ뤿ˡ
			// ߤTreeξ֤򤵤ƤܤΥꥹȤ򹹿
			// (ߤΥĥ꡼ǤʤǥХ̤ξʤɤ)
			collectorItemID = 0;  // ID򥯥ꥢ
			itemList.clear();
			treeToList(getTree().getItems());
		}
	}
	
	/**
	 * ꤵƤܤΥꥹȤ֤ޤ
	 * 
	 * @return ꤵƤܤΥꥹ
	 */
	public ArrayList getItemList() {
		return itemList;
	}
	
	/**
	 * ܤΥꥹȤꤷޤ
	 * 
	 * @param itemList ܤΥꥹ
	 */
	public void setItemList(ArrayList<CollectorItemInfo> itemList) {
		this.itemList = itemList;

		setCheckedTreeItem(getTree().getItems());
	}
	
    public void setEnabled(boolean enabled){
    	setListener(enabled);
    }
    
    private void setListener(boolean enabled){
    	// ꤵƤꥹʤ
    	if(subItemCheckListener != null){
    		this.treeViewer.getTree().removeListener(SWT.Selection, subItemCheckListener);
    		subItemCheckListener = null;
    	}
    	if(ItemCheckDisableListener != null){
    		this.treeViewer.getTree().removeListener(SWT.Selection, subItemCheckListener);
    		ItemCheckDisableListener = null;
    	}
    	
    	if(enabled){
    		this.treeViewer.getTree().addListener(SWT.Selection, 
    				subItemCheckListener = new Listener() {
    			public void handleEvent(Event event) {
    				if (event.detail == SWT.CHECK) {
    					if (((TreeItem) event.item).getChecked()) {
    	    	    		// å줿ϡå줿ܰʲιܤŸ
    						// Ƥιܤˤå
    						setChecked((TreeItem)event.item, true);
    					} else {
    						// åϤϲ⤷ʤ
    					}
						// ߤTreeξ֤򤵤ƤܤΥꥹȤ򹹿
						collectorItemID = 0;  // ID򥯥ꥢ
						itemList.clear();
						treeToList(getTree().getItems());
    				} else {
    				}
    			}
    		});
    	} else {    		
        	// setEnabledfalseꤹȥǤʤʤäƤޤ
        	// åϤʤ褦˥ꥹʤǥȥ뤹
    		this.treeViewer.getTree().addListener(SWT.Selection, 
    				ItemCheckDisableListener = new Listener() {
    			public void handleEvent(Event event) {
    				
    				if (event.detail == SWT.CHECK) {
    					if (((TreeItem) event.item).getChecked()) {
    						((TreeItem) event.item).setChecked(false);
    					} else {
    						((TreeItem) event.item).setChecked(true);
    					}
    				} else {
    					
    				}
    			}
    		});
    	}
    }
}
